/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import javafx.scene.text.Font;
import org.kordamp.ikonli.IkonHandler;

public class IkonResolver {
    private static final IkonResolver INSTANCE;
    private static final Set<IkonHandler> HANDLERS;

    private IkonResolver() {
    }

    public static IkonResolver getInstance() {
        return INSTANCE;
    }

    public IkonHandler resolveIkonHandler(String value) {
        Objects.requireNonNull(value, "Ikon description must not be null");
        for (IkonHandler handler : HANDLERS) {
            if (!handler.supports(value)) continue;
            return handler;
        }
        throw new UnsupportedOperationException("Cannot resolve '" + value + "'");
    }

    static {
        HANDLERS = new LinkedHashSet<IkonHandler>();
        INSTANCE = new IkonResolver();
        ClassLoader classLoader = IkonResolver.class.getClassLoader();
        ServiceLoader<IkonHandler> loader = ServiceLoader.load(IkonHandler.class, classLoader);
        for (IkonHandler handler : loader) {
            HANDLERS.add(handler);
            handler.setFont(Font.loadFont(classLoader.getResource(handler.getFontResourcePath()).toExternalForm(), 16.0));
        }
    }
}

