/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonHandler;
import org.kordamp.ikonli.javafx.FontIconConverter;
import org.kordamp.ikonli.javafx.Icon;
import org.kordamp.ikonli.javafx.IkonResolver;

public class FontIcon
extends Text
implements Icon {
    protected StyleableIntegerProperty iconSize;
    protected StyleableObjectProperty<Paint> iconColor;
    private StyleableObjectProperty<Ikon> iconCode;

    public static FontIcon of(Ikon ikon) {
        return FontIcon.of(ikon, 8, Color.BLACK);
    }

    public static FontIcon of(Ikon ikon, int iconSize) {
        return FontIcon.of(ikon, iconSize, Color.BLACK);
    }

    public static FontIcon of(Ikon ikon, Color iconColor) {
        return FontIcon.of(ikon, 8, iconColor);
    }

    public static FontIcon of(Ikon iconCode, int iconSize, Color iconColor) {
        FontIcon icon = new FontIcon();
        icon.setIconCode(iconCode);
        icon.setIconSize(iconSize);
        icon.setIconColor(iconColor);
        return icon;
    }

    public FontIcon() {
        this.getStyleClass().setAll((String[])new String[]{"ikonli-font-icon"});
        this.setIconSize(8);
        this.setIconColor(Color.BLACK);
        this.fontProperty().addListener((v, o, n) -> {
            int size = (int)n.getSize();
            if (size != this.getIconSize()) {
                this.setIconSize(size);
            }
        });
        this.fillProperty().addListener((v, o, n) -> {
            Paint fill = this.getIconColor();
            if (!Objects.equals(fill, n)) {
                this.setIconColor((Paint)n);
            }
        });
        this.iconCodeProperty().addListener((v, o, n) -> {
            if (n != null) {
                IkonHandler ikonHandler = IkonResolver.getInstance().resolveIkonHandler(n.getDescription());
                this.setStyle(this.normalizeStyle(this.getStyle(), "-fx-font-family", "'" + ikonHandler.getFontFamily() + "'"));
                this.setText(String.valueOf(n.getCode()));
            }
        });
    }

    public FontIcon(String iconCode) {
        this();
        this.setIconLiteral(iconCode);
    }

    public FontIcon(Ikon iconCode) {
        this();
        this.setIconCode(iconCode);
    }

    @Override
    public String toString() {
        Ikon iconCode = this.getIconCode();
        return (iconCode != null ? iconCode.getDescription() : "<undef>") + ":" + this.getIconSize() + ":" + this.getIconColor();
    }

    @Override
    public IntegerProperty iconSizeProperty() {
        if (this.iconSize == null) {
            this.iconSize = new StyleableIntegerProperty(8){

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_SIZE;
                }

                @Override
                public Object getBean() {
                    return FontIcon.this;
                }

                @Override
                public String getName() {
                    return "iconSize";
                }
            };
            this.iconSize.addListener((ChangeListener<? super Number>)((ChangeListener<Number>)(v, o, n) -> {
                Font font = this.getFont();
                this.setFont(Font.font(font.getFamily(), n.doubleValue()));
                this.setStyle(this.normalizeStyle(this.getStyle(), "-fx-font-size", n.intValue() + "px"));
            }));
        }
        return this.iconSize;
    }

    @Override
    public ObjectProperty<Paint> iconColorProperty() {
        if (this.iconColor == null) {
            this.iconColor = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_COLOR;
                }

                @Override
                public Object getBean() {
                    return FontIcon.this;
                }

                @Override
                public String getName() {
                    return "iconColor";
                }
            };
            this.iconColor.addListener((v, o, n) -> this.setFill((Paint)n));
        }
        return this.iconColor;
    }

    public ObjectProperty<Ikon> iconCodeProperty() {
        if (this.iconCode == null) {
            this.iconCode = new StyleableObjectProperty<Ikon>(){

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_CODE;
                }

                @Override
                public Object getBean() {
                    return FontIcon.this;
                }

                @Override
                public String getName() {
                    return "iconCode";
                }
            };
            this.iconCode.addListener((v, o, n) -> {
                if (!this.iconCode.isBound()) {
                    this.setIconCode((Ikon)n);
                }
            });
        }
        return this.iconCode;
    }

    @Override
    public void setIconSize(int size) {
        if (size <= 0) {
            throw new IllegalStateException("Argument 'size' must be greater than zero.");
        }
        this.iconSizeProperty().set(size);
    }

    @Override
    public int getIconSize() {
        return this.iconSizeProperty().get();
    }

    @Override
    public void setIconColor(Paint paint) {
        this.iconColorProperty().set(Objects.requireNonNull(paint, "Argument 'paint' must not be null"));
    }

    @Override
    public Paint getIconColor() {
        return (Paint)this.iconColorProperty().get();
    }

    public Ikon getIconCode() {
        return (Ikon)this.iconCodeProperty().get();
    }

    public void setIconCode(Ikon iconCode) {
        this.iconCodeProperty().set(Objects.requireNonNull(iconCode, "Argument 'code' must not be null"));
    }

    private String normalizeStyle(String style, String key, String value) {
        int start = ((String)style).indexOf(key);
        if (start != -1) {
            int end = ((String)style).indexOf(";", start);
            end = end >= start ? end : ((String)style).length() - 1;
            style = ((String)style).substring(0, start) + ((String)style).substring(end + 1);
        }
        return (String)style + key + ": " + value + ";";
    }

    public void setIconLiteral(String iconCode) {
        String[] parts = iconCode.split(":");
        this.setIconCode(IkonResolver.getInstance().resolveIkonHandler(parts[0]).resolve(parts[0]));
        this.resolveSize(iconCode, parts);
        this.resolvePaint(iconCode, parts);
    }

    public String getIconLiteral() {
        Ikon ikon = (Ikon)this.iconCodeProperty().get();
        return ikon != null ? ikon.getDescription() : null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FontIcon.getClassCssMetaData();
    }

    private void resolveSize(String iconCode, String[] parts) {
        if (parts.length > 1) {
            try {
                this.setIconSize(Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException e) {
                throw FontIcon.invalidDescription(iconCode, e);
            }
        }
    }

    private void resolvePaint(String iconCode, String[] parts) {
        Paint paint;
        if (parts.length > 2 && (paint = FontIcon.resolvePaintValue(iconCode, parts[2])) != null) {
            this.setIconColor(paint);
        }
    }

    private static Paint resolvePaintValue(String iconCode, String value) {
        try {
            return Color.valueOf(value);
        }
        catch (IllegalArgumentException e1) {
            try {
                return LinearGradient.valueOf(value);
            }
            catch (IllegalArgumentException e2) {
                try {
                    return RadialGradient.valueOf(value);
                }
                catch (IllegalArgumentException e3) {
                    throw FontIcon.invalidDescription(iconCode, e3);
                }
            }
        }
    }

    public static IllegalArgumentException invalidDescription(String description, Exception e) {
        throw new IllegalArgumentException("Description " + description + " is not a valid icon description", e);
    }

    private static class StyleableProperties {
        private static final CssMetaData<FontIcon, Number> ICON_SIZE = new CssMetaData<FontIcon, Number>("-fx-icon-size", SizeConverter.getInstance(), (Number)8){

            @Override
            public boolean isSettable(FontIcon icon) {
                return true;
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(FontIcon icon) {
                return (StyleableProperty)((Object)icon.iconSizeProperty());
            }
        };
        private static final CssMetaData<FontIcon, Paint> ICON_COLOR = new CssMetaData<FontIcon, Paint>("-fx-icon-color", PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            public boolean isSettable(FontIcon node) {
                return true;
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(FontIcon icon) {
                return (StyleableProperty)((Object)icon.iconColorProperty());
            }
        };
        private static final CssMetaData<FontIcon, Ikon> ICON_CODE = new CssMetaData<FontIcon, Ikon>("-fx-icon-code", FontIconConverter.getInstance(), null){

            @Override
            public boolean isSettable(FontIcon node) {
                return true;
            }

            @Override
            public StyleableProperty<Ikon> getStyleableProperty(FontIcon icon) {
                return (StyleableProperty)((Object)icon.iconCodeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Text.getClassCssMetaData());
            styleables.add(ICON_SIZE);
            styleables.add(ICON_COLOR);
            styleables.add(ICON_CODE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

