/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.Collection;
import java.util.Collections;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.StyledTextField;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.model.SimpleEditableStyledDocument;

public class StyleClassedTextField
extends StyledTextField<Collection<String>, Collection<String>> {
    public StyleClassedTextField() {
        super(Collections.emptyList(), (TextFlow paragraph, PS styleClasses) -> paragraph.getStyleClass().addAll((Collection<String>)styleClasses), Collections.emptyList(), (? super TextExt text, S styleClasses) -> text.getStyleClass().addAll((Collection<String>)styleClasses), new SimpleEditableStyledDocument(Collections.emptyList(), Collections.emptyList()));
    }

    public StyleClassedTextField(String text) {
        this();
        this.replaceText(text);
        this.getUndoManager().forgetHistory();
        this.getUndoManager().mark();
    }

    @Override
    public void append(String text, String styleClass) {
        this.insert(this.getLength(), text, styleClass);
    }

    @Override
    public void insert(int position, String text, String styleClass) {
        this.replace(position, position, text, Collections.singleton(styleClass));
    }

    @Override
    public void replace(int start, int end, String text, String styleClass) {
        this.replace(start, end, text, Collections.singleton(styleClass));
    }

    public void setStyleClass(int from, int to, String styleClass) {
        this.setStyle(from, to, Collections.singletonList(styleClass));
    }

    @Override
    protected void changeAlignment(TextAlignment txtAlign) {
        this.setParagraphStyle(0, Collections.singletonList(txtAlign.toString().toLowerCase()));
    }
}

