/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.Collection;
import javafx.beans.NamedArg;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.fxmisc.richtext.model.EditableStyledDocument;

public class CodeArea
extends StyleClassedTextArea {
    public CodeArea(@NamedArg(value="document") EditableStyledDocument<Collection<String>, String, Collection<String>> document) {
        super(document, false);
        this.getStyleClass().add("code-area");
        this.getStylesheets().add(CodeArea.class.getResource("code-area.css").toExternalForm());
        this.setUseInitialStyleForInsertion(true);
    }

    public CodeArea() {
        super(false);
        this.getStyleClass().add("code-area");
        this.getStylesheets().add(CodeArea.class.getResource("code-area.css").toExternalForm());
        this.setUseInitialStyleForInsertion(true);
    }

    public CodeArea(@NamedArg(value="text") String text) {
        this();
        this.appendText(text);
        this.getUndoManager().forgetHistory();
        this.getUndoManager().mark();
        this.selectRange(0, 0);
    }

    @Override
    public void selectWord() {
        if (this.getLength() == 0) {
            return;
        }
        CaretSelectionBind csb = this.getCaretSelectionBind();
        int paragraph = csb.getParagraphIndex();
        int position = csb.getColumnPosition();
        String paragraphText = this.getText(paragraph);
        BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale());
        breakIterator.setText(paragraphText);
        breakIterator.preceding(position);
        int start = breakIterator.current();
        while (start > 0 && paragraphText.charAt(start - 1) == '_') {
            if (--start <= 0 || breakIterator.isBoundary(start - 1)) continue;
            breakIterator.preceding(start);
            start = breakIterator.current();
        }
        breakIterator.following(position);
        int end = breakIterator.current();
        int len = paragraphText.length();
        while (end < len && paragraphText.charAt(end) == '_') {
            if (++end < len && !breakIterator.isBoundary(end + 1)) {
                breakIterator.following(end);
                end = breakIterator.current();
                continue;
            }
            if (!Character.isDigit(paragraphText.charAt(end))) continue;
            ++end;
        }
        csb.selectRange(paragraph, start, paragraph, end);
    }
}

