/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.validation;

import com.jfoenix.validation.base.ValidatorBase;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javafx.beans.DefaultProperty;
import javafx.scene.control.TextInputControl;
import javafx.util.converter.NumberStringConverter;

@DefaultProperty(value="icon")
public class NumberValidator
extends ValidatorBase {
    private NumberStringConverter numberStringConverter = new NumberStringConverter(){

        @Override
        public Number fromString(String string) {
            try {
                if (string == null) {
                    return null;
                }
                if ((string = string.trim()).length() < 1) {
                    return null;
                }
                NumberFormat parser = this.getNumberFormat();
                ParsePosition parsePosition = new ParsePosition(0);
                Number result = parser.parse(string, parsePosition);
                int index = parsePosition.getIndex();
                if (index == 0 || index < string.length()) {
                    throw new ParseException("Unparseable number: \"" + string + "\"", parsePosition.getErrorIndex());
                }
                return result;
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
    };

    public NumberValidator() {
    }

    public NumberValidator(String message) {
        super(message);
    }

    public NumberValidator(NumberStringConverter numberStringConverter) {
        this.numberStringConverter = numberStringConverter;
    }

    public NumberValidator(String message, NumberStringConverter numberStringConverter) {
        super(message);
        this.numberStringConverter = numberStringConverter;
    }

    @Override
    protected void eval() {
        if (this.srcControl.get() instanceof TextInputControl) {
            this.evalTextInputField();
        }
    }

    private void evalTextInputField() {
        TextInputControl textField = (TextInputControl)this.srcControl.get();
        String text = textField.getText();
        try {
            this.hasErrors.set(false);
            if (!text.isEmpty()) {
                this.numberStringConverter.fromString(text);
            }
        }
        catch (Exception e) {
            this.hasErrors.set(true);
        }
    }

    public NumberStringConverter getNumberStringConverter() {
        return this.numberStringConverter;
    }

    public void setNumberStringConverter(NumberStringConverter numberStringConverter) {
        this.numberStringConverter = numberStringConverter;
    }
}

