/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions.hamburger;

import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.transitions.CachedTransition;
import com.jfoenix.transitions.hamburger.HamburgerTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.binding.Bindings;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class HamburgerSlideCloseTransition
extends CachedTransition
implements HamburgerTransition {
    public HamburgerSlideCloseTransition() {
        super(null, null);
    }

    public HamburgerSlideCloseTransition(JFXHamburger burger) {
        super(burger, HamburgerSlideCloseTransition.createTimeline(burger));
        this.timeline.bind(Bindings.createObjectBinding(() -> HamburgerSlideCloseTransition.createTimeline(burger), ((Region)burger.getChildren().get(0)).widthProperty(), ((Region)burger.getChildren().get(0)).heightProperty()));
        this.setCycleDuration(Duration.seconds(0.3));
        this.setDelay(Duration.seconds(0.0));
        this.setOnFinished(finish -> {
            if (this.getRate() == 1.0) {
                ((Node)burger.getChildren().get(1)).setVisible(false);
            }
        });
    }

    @Override
    protected void starting() {
        super.starting();
        if (this.node.getParent() instanceof JFXRippler) {
            JFXRippler rippler = (JFXRippler)this.node.getParent();
            BorderPane p = new BorderPane(this.node);
            p.setMaxWidth(((JFXHamburger)this.node).getWidth());
            p.setMinWidth(((JFXHamburger)this.node).getWidth());
            p.addEventHandler(MouseEvent.ANY, event -> {
                if (!event.isConsumed()) {
                    event.consume();
                    this.node.fireEvent(event);
                }
            });
            rippler.setControl(p);
        }
        if (this.getRate() == -1.0) {
            ((Node)((JFXHamburger)this.node).getChildren().get(1)).setVisible(true);
        }
    }

    private static Timeline createTimeline(JFXHamburger burger) {
        double burgerWidth = ((Node)burger.getChildren().get(0)).getLayoutBounds().getWidth();
        double burgerHeight = ((Node)burger.getChildren().get(2)).getBoundsInParent().getMaxY() - ((Node)burger.getChildren().get(0)).getBoundsInParent().getMinY();
        double hypotenuse = Math.sqrt(Math.pow(burgerHeight, 2.0) + Math.pow(burgerWidth, 2.0));
        double angle = Math.toDegrees(Math.asin(burgerWidth / hypotenuse)) + 80.0;
        return new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(burger.rotateProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(0)).rotateProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(0)).translateYProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(2)).rotateProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(2)).translateYProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(1)).opacityProperty(), 1, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(1)).translateXProperty(), 0, Interpolator.EASE_BOTH)), new KeyFrame(Duration.millis(1000.0), new KeyValue(burger.rotateProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(0)).rotateProperty(), angle, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(0)).translateYProperty(), burgerHeight / 2.0 - ((Node)burger.getChildren().get(0)).getBoundsInLocal().getHeight() / 2.0, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(2)).rotateProperty(), -angle, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(2)).translateYProperty(), -(burgerHeight / 2.0 - ((Node)burger.getChildren().get(2)).getBoundsInLocal().getHeight() / 2.0), Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(1)).opacityProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(((Node)burger.getChildren().get(1)).translateXProperty(), -burger.getWidth() / 1.1, Interpolator.EASE_BOTH)));
    }

    @Override
    public Transition getAnimation(JFXHamburger burger) {
        return new HamburgerSlideCloseTransition(burger);
    }
}

