/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.base.IFXLabelFloatControl;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class PromptLinesWrapper<T extends Control> {
    private final Supplier<Text> promptTextSupplier;
    private T control;
    public StackPane line = new StackPane();
    public StackPane focusedLine = new StackPane();
    public StackPane promptContainer = new StackPane();
    private JFXAnimationTimer focusTimer;
    private JFXAnimationTimer unfocusTimer;
    private double initScale = 0.05;
    public final Scale promptTextScale = new Scale(1.0, 1.0, 0.0, 0.0);
    private final Scale scale = new Scale(this.initScale, 1.0);
    public final Rectangle clip = new Rectangle();
    public ObjectProperty<Paint> animatedPromptTextFill;
    public BooleanBinding usePromptText;
    private ObjectProperty<Paint> promptTextFill;
    private ObservableValue<?> valueProperty;
    private ObservableValue<String> promptTextProperty;
    private boolean animating = false;
    private double contentHeight = 0.0;

    public PromptLinesWrapper(T control, ObjectProperty<Paint> promptTextFill, ObservableValue<?> valueProperty, ObservableValue<String> promptTextProperty, Supplier<Text> promptTextSupplier) {
        this.control = control;
        this.promptTextSupplier = promptTextSupplier;
        this.promptTextFill = promptTextFill;
        this.valueProperty = valueProperty;
        this.promptTextProperty = promptTextProperty;
    }

    public void init(Runnable createPromptNodeRunnable, Node ... cachedNodes) {
        this.animatedPromptTextFill = new SimpleObjectProperty<Paint>((Paint)this.promptTextFill.get());
        this.usePromptText = Bindings.createBooleanBinding(this::usePromptText, this.valueProperty, this.promptTextProperty, ((IFXLabelFloatControl)this.control).labelFloatProperty(), this.promptTextFill);
        this.line.setManaged(false);
        this.line.getStyleClass().add("input-line");
        this.line.setBackground(new Background(new BackgroundFill(((IFXLabelFloatControl)this.control).getUnFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)));
        this.focusedLine.setManaged(false);
        this.focusedLine.getStyleClass().add("input-focused-line");
        this.focusedLine.setBackground(new Background(new BackgroundFill(((IFXLabelFloatControl)this.control).getFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)));
        this.focusedLine.setOpacity(0.0);
        this.focusedLine.getTransforms().add(this.scale);
        if (this.usePromptText.get()) {
            createPromptNodeRunnable.run();
        }
        this.usePromptText.addListener(observable -> {
            createPromptNodeRunnable.run();
            ((Parent)this.control).requestLayout();
        });
        Supplier promptTargetSupplier = () -> this.promptTextSupplier.get() == null ? null : this.promptTextSupplier.get().translateYProperty();
        this.focusTimer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis(1.0), JFXKeyValue.builder().setTarget(this.focusedLine.opacityProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((Node)this.control).isFocused()).build()), new JFXKeyFrame(Duration.millis(160.0), JFXKeyValue.builder().setTarget(this.scale.xProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((Node)this.control).isFocused()).build(), JFXKeyValue.builder().setTarget(this.animatedPromptTextFill).setEndValueSupplier(() -> ((IFXLabelFloatControl)this.control).getFocusColor()).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((Node)this.control).isFocused() && ((IFXLabelFloatControl)this.control).isLabelFloat()).build(), JFXKeyValue.builder().setTargetSupplier(promptTargetSupplier).setEndValueSupplier(() -> -this.contentHeight).setAnimateCondition(() -> ((IFXLabelFloatControl)this.control).isLabelFloat()).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.xProperty()).setEndValue(0.85).setAnimateCondition(() -> ((IFXLabelFloatControl)this.control).isLabelFloat()).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.yProperty()).setEndValue(0.85).setAnimateCondition(() -> ((IFXLabelFloatControl)this.control).isLabelFloat()).setInterpolator(Interpolator.EASE_BOTH).build()));
        this.unfocusTimer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis(160.0), JFXKeyValue.builder().setTargetSupplier(promptTargetSupplier).setEndValue(0).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.xProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.yProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).build()));
        this.promptContainer.getStyleClass().add("prompt-container");
        this.promptContainer.setManaged(false);
        this.promptContainer.setMouseTransparent(true);
        this.clip.setSmooth(false);
        this.clip.setX(0.0);
        this.clip.widthProperty().bind(this.promptContainer.widthProperty());
        this.promptContainer.setClip(this.clip);
        this.focusTimer.setOnFinished(() -> {
            this.animating = false;
        });
        this.unfocusTimer.setOnFinished(() -> {
            this.animating = false;
        });
        this.focusTimer.setCacheNodes(cachedNodes);
        this.unfocusTimer.setCacheNodes(cachedNodes);
        ((Node)this.control).focusedProperty().addListener(observable -> {
            if (((Node)this.control).isFocused()) {
                this.focus();
            } else {
                this.unFocus();
            }
        });
        this.promptTextFill.addListener(observable -> {
            if (!((IFXLabelFloatControl)this.control).isLabelFloat() || !((Node)this.control).isFocused()) {
                this.animatedPromptTextFill.set((Paint)this.promptTextFill.get());
            }
        });
        this.updateDisabled();
    }

    private Object getControlValue() {
        Object text = this.valueProperty.getValue();
        text = this.validateComboBox(text);
        return text;
    }

    private Object validateComboBox(Object text) {
        if (this.control instanceof ComboBox && ((ComboBox)this.control).isEditable()) {
            String editorText = ((ComboBox)this.control).getEditor().getText();
            text = editorText == null || editorText.isEmpty() ? null : text;
        }
        return text;
    }

    private void focus() {
        this.unfocusTimer.stop();
        this.animating = true;
        this.runTimer(this.focusTimer, true);
    }

    private void unFocus() {
        this.focusTimer.stop();
        this.scale.setX(this.initScale);
        this.focusedLine.setOpacity(0.0);
        if (((IFXLabelFloatControl)this.control).isLabelFloat()) {
            this.animatedPromptTextFill.set((Paint)this.promptTextFill.get());
            Object text = this.getControlValue();
            if (text == null || text.toString().isEmpty()) {
                this.animating = true;
                this.runTimer(this.unfocusTimer, true);
            }
        }
    }

    public void updateFocusColor() {
        Paint paint = ((IFXLabelFloatControl)this.control).getFocusColor();
        this.focusedLine.setBackground(paint == null ? Background.EMPTY : new Background(new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)));
    }

    public void updateUnfocusColor() {
        Paint paint = ((IFXLabelFloatControl)this.control).getUnFocusColor();
        this.line.setBackground(paint == null ? Background.EMPTY : new Background(new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)));
    }

    private void updateLabelFloat(boolean animation) {
        if (((IFXLabelFloatControl)this.control).isLabelFloat()) {
            if (((Node)this.control).isFocused()) {
                this.animateFloatingLabel(true, animation);
            } else {
                Object text = this.getControlValue();
                this.animateFloatingLabel(text != null && !text.toString().isEmpty(), animation);
            }
        }
    }

    private void animateFloatingLabel(boolean up, boolean animation) {
        if (this.promptTextSupplier.get() == null) {
            return;
        }
        if (up) {
            if (this.promptTextSupplier.get().getTranslateY() != -this.contentHeight) {
                this.unfocusTimer.stop();
                this.runTimer(this.focusTimer, animation);
            }
        } else if (this.promptTextSupplier.get().getTranslateY() != 0.0) {
            this.focusTimer.stop();
            this.runTimer(this.unfocusTimer, animation);
        }
    }

    private void runTimer(JFXAnimationTimer timer, boolean animation) {
        if (animation) {
            if (!timer.isRunning()) {
                timer.start();
            }
        } else {
            timer.applyEndValues();
        }
    }

    private boolean usePromptText() {
        Object txt = this.getControlValue();
        String promptTxt = this.promptTextProperty.getValue();
        boolean isLabelFloat = ((IFXLabelFloatControl)this.control).isLabelFloat();
        return isLabelFloat || promptTxt != null && (txt == null || txt.toString().isEmpty()) && !promptTxt.isEmpty() && !((Paint)this.promptTextFill.get()).equals(Color.TRANSPARENT);
    }

    public void layoutLines(double x, double y, double w, double h, double controlHeight, double translateY) {
        this.contentHeight = translateY;
        this.clip.setY(-this.contentHeight);
        this.clip.setHeight(controlHeight + this.contentHeight);
        this.focusedLine.resizeRelocate(x, controlHeight, w, this.focusedLine.prefHeight(-1.0));
        this.line.resizeRelocate(x, controlHeight, w, this.line.prefHeight(-1.0));
        this.promptContainer.resizeRelocate(x, y, w, h);
        this.scale.setPivotX(w / 2.0);
    }

    public void updateLabelFloatLayout() {
        if (!this.animating) {
            this.updateLabelFloat(false);
        } else if (this.unfocusTimer.isRunning()) {
            this.unfocusTimer.stop();
            this.updateLabelFloat(true);
        }
    }

    public void invalid() {
        if (((Node)this.control).isFocused()) {
            this.focus();
        }
    }

    public void updateDisabled() {
        boolean disabled = ((Node)this.control).isDisable();
        this.line.setBorder(!disabled ? Border.EMPTY : new Border(new BorderStroke(((IFXLabelFloatControl)this.control).getUnFocusColor(), BorderStrokeStyle.DASHED, CornerRadii.EMPTY, new BorderWidths(1.0))));
        this.line.setBackground(new Background(new BackgroundFill(disabled ? Color.TRANSPARENT : ((IFXLabelFloatControl)this.control).getUnFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)));
    }
}

