/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXToggleNode;
import com.jfoenix.transitions.JFXFillTransition;
import javafx.beans.binding.Bindings;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.skin.ToggleButtonSkin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public class JFXToggleNodeSkin
extends ToggleButtonSkin {
    private final StackPane selectionOverLay = new StackPane();
    private JFXRippler rippler;
    private JFXFillTransition ft;
    private Runnable releaseManualRippler = null;
    private boolean invalid = true;

    public JFXToggleNodeSkin(JFXToggleNode toggleNode) {
        super(toggleNode);
        Node graphic = ((ToggleButton)this.getSkinnable()).getGraphic();
        if (graphic != null) {
            this.selectionOverLay.getChildren().add(graphic);
        }
        this.selectionOverLay.shapeProperty().bind(((ToggleButton)this.getSkinnable()).shapeProperty());
        this.selectionOverLay.setPickOnBounds(false);
        this.rippler = new JFXRippler((Node)this.selectionOverLay, JFXRippler.RipplerPos.FRONT){

            @Override
            protected Node getMask() {
                return this.createMask();
            }

            private StackPane createMask() {
                StackPane mask = new StackPane();
                mask.shapeProperty().bind(((ToggleButton)JFXToggleNodeSkin.this.getSkinnable()).shapeProperty());
                mask.backgroundProperty().bind(Bindings.createObjectBinding(() -> new Background(new BackgroundFill(Color.WHITE, ((ToggleButton)JFXToggleNodeSkin.this.getSkinnable()).getBackground() != null && ((ToggleButton)JFXToggleNodeSkin.this.getSkinnable()).getBackground().getFills().size() > 0 ? ((ToggleButton)JFXToggleNodeSkin.this.getSkinnable()).getBackground().getFills().get(0).getRadii() : CornerRadii.EMPTY, ((ToggleButton)JFXToggleNodeSkin.this.getSkinnable()).getBackground() != null && ((ToggleButton)JFXToggleNodeSkin.this.getSkinnable()).getBackground().getFills().size() > 0 ? ((ToggleButton)JFXToggleNodeSkin.this.getSkinnable()).getBackground().getFills().get(0).getInsets() : Insets.EMPTY)), ((ToggleButton)JFXToggleNodeSkin.this.getSkinnable()).backgroundProperty()));
                mask.resize(this.getWidth() - this.snappedRightInset() - this.snappedLeftInset(), this.getHeight() - this.snappedBottomInset() - this.snappedTopInset());
                return mask;
            }
        };
        ((ToggleButton)this.getSkinnable()).selectedProperty().addListener(observable -> {
            if (!toggleNode.isDisableAnimation().booleanValue()) {
                if (this.ft == null) {
                    this.ft = new JFXFillTransition(Duration.millis(120.0), this.selectionOverLay);
                    this.ft.toValueProperty().bind(toggleNode.selectedColorProperty());
                    this.ft.fromValueProperty().bind(toggleNode.unSelectedColorProperty());
                }
                this.ft.stop();
                this.ft.setRate(((ToggleButton)this.getSkinnable()).isSelected() ? 1.0 : -1.0);
                this.ft.play();
            } else {
                this.updateSelectionBackground();
            }
        });
        ((ToggleButton)this.getSkinnable()).armedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.releaseManualRippler = this.rippler.createManualRipple();
            } else if (this.releaseManualRippler != null) {
                this.releaseManualRippler.run();
            }
        });
        toggleNode.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (!toggleNode.isDisableVisualFocus().booleanValue()) {
                if (newVal.booleanValue()) {
                    if (!((ToggleButton)this.getSkinnable()).isPressed()) {
                        this.rippler.setOverlayVisible(true);
                    }
                } else {
                    this.rippler.setOverlayVisible(false);
                }
            }
        });
        toggleNode.pressedProperty().addListener((o, oldVal, newVal) -> this.rippler.setOverlayVisible(false));
        this.updateChildren();
    }

    public void updateSelectionBackground() {
        CornerRadii radii = ((ToggleButton)this.getSkinnable()).getBackground() == null ? CornerRadii.EMPTY : ((ToggleButton)this.getSkinnable()).getBackground().getFills().get(0).getRadii();
        Insets insets = ((ToggleButton)this.getSkinnable()).getBackground() == null ? Insets.EMPTY : ((ToggleButton)this.getSkinnable()).getBackground().getFills().get(0).getInsets();
        this.selectionOverLay.setBackground(new Background(new BackgroundFill(((ToggleButton)this.getSkinnable()).isSelected() ? ((JFXToggleNode)this.getSkinnable()).getSelectedColor() : ((JFXToggleNode)this.getSkinnable()).getUnSelectedColor(), radii, insets)));
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        if (this.rippler != null) {
            this.getChildren().add(0, this.rippler);
        }
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Node)this.getChildren().get(i)).setMouseTransparent(true);
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (this.invalid) {
            this.updateSelectionBackground();
            this.invalid = false;
        }
        this.rippler.resizeRelocate(((ToggleButton)this.getSkinnable()).getLayoutBounds().getMinX(), ((ToggleButton)this.getSkinnable()).getLayoutBounds().getMinY(), ((ToggleButton)this.getSkinnable()).getWidth(), ((ToggleButton)this.getSkinnable()).getHeight());
    }
}

