/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXTimePicker;
import com.jfoenix.skins.JFXGenericPickerSkin;
import com.jfoenix.skins.JFXTimePickerContent;
import java.time.LocalTime;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class JFXTimePickerSkin
extends JFXGenericPickerSkin<LocalTime> {
    private JFXTimePicker jfxTimePicker;
    private TextField displayNode;
    private JFXTimePickerContent content;
    private JFXDialog dialog;

    public JFXTimePickerSkin(JFXTimePicker timePicker) {
        super(timePicker);
        this.jfxTimePicker = timePicker;
        timePicker.focusedProperty().addListener(observable -> {
            if (this.getEditor() != null && !timePicker.isFocused()) {
                this.reflectSetTextFromTextFieldIntoComboBoxValue();
            }
        });
        this.updateArrow(timePicker);
        ((JFXTextField)this.getEditor()).setFocusColor(timePicker.getDefaultColor());
        this.registerChangeListener(timePicker.defaultColorProperty(), obs -> this.updateArrow(timePicker));
        this.registerChangeListener(timePicker.converterProperty(), obs -> this.reflectUpdateDisplayNode());
        this.registerChangeListener(timePicker.editorProperty(), obs -> this.reflectUpdateDisplayNode());
        this.registerChangeListener(timePicker.showingProperty(), obs -> {
            if (this.jfxTimePicker.isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        });
        this.registerChangeListener(timePicker.valueProperty(), obs -> {
            this.reflectUpdateDisplayNode();
            this.jfxTimePicker.fireEvent(new ActionEvent());
        });
    }

    private void updateArrow(JFXTimePicker picker) {
        ((Region)this.arrowButton.getChildren().get(0)).setBackground(new Background(new BackgroundFill(picker.getDefaultColor(), null, null)));
        ((JFXTextField)this.getEditor()).setFocusColor(this.jfxTimePicker.getDefaultColor());
    }

    @Override
    protected Node getPopupContent() {
        if (this.content == null) {
            this.content = new JFXTimePickerContent((JFXTimePicker)this.getSkinnable());
        }
        return this.content;
    }

    @Override
    public void show() {
        if (!this.jfxTimePicker.isOverLay()) {
            super.show();
        }
        if (this.content != null) {
            this.content.init();
            this.content.clearFocus();
        }
        if (this.dialog == null && this.jfxTimePicker.isOverLay()) {
            StackPane dialogParent = this.jfxTimePicker.getDialogParent();
            if (dialogParent == null) {
                dialogParent = (StackPane)this.jfxTimePicker.getScene().getRoot();
            }
            this.dialog = new JFXDialog(dialogParent, (Region)this.getPopupContent(), JFXDialog.DialogTransition.CENTER, true);
            this.arrowButton.setOnMouseClicked(click -> {
                if (this.jfxTimePicker.isOverLay()) {
                    StackPane parent = this.jfxTimePicker.getDialogParent();
                    if (parent == null) {
                        parent = (StackPane)this.jfxTimePicker.getScene().getRoot();
                    }
                    this.dialog.show(parent);
                }
            });
        }
    }

    @Override
    protected TextField getEditor() {
        return ((JFXTimePicker)this.getSkinnable()).getEditor();
    }

    @Override
    protected StringConverter<LocalTime> getConverter() {
        return ((JFXTimePicker)this.getSkinnable()).getConverter();
    }

    @Override
    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.reflectGetEditableInputNode();
            this.displayNode.getStyleClass().add("time-picker-display-node");
            this.reflectUpdateDisplayNode();
        }
        this.displayNode.setEditable(this.jfxTimePicker.isEditable());
        return this.displayNode;
    }
}

