/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXTimePicker;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import javafx.util.converter.LocalTimeStringConverter;
import javafx.util.converter.NumberStringConverter;

public class JFXTimePickerContent
extends VBox {
    private static final String ROBOTO = "Roboto";
    private static final String SPINNER_LABEL = "spinner-label";
    protected JFXTimePicker timePicker;
    private Color fadedColor = Color.rgb(255, 255, 255, 0.67);
    private boolean is24HourView = false;
    private double contentCircleRadius = 100.0;
    private Label selectedHourLabel = new Label();
    private Label selectedMinLabel = new Label();
    private Label periodPMLabel;
    private Label periodAMLabel;
    private StackPane calendarPlaceHolder = new StackPane();
    private StackPane hoursContent;
    private StackPane minutesContent;
    private Rotate hoursPointerRotate;
    private Rotate _24HourHoursPointerRotate;
    private Rotate minsPointerRotate;
    private ObjectProperty<TimeUnit> unit = new SimpleObjectProperty<TimeUnit>(TimeUnit.HOURS);
    private DoubleProperty angle = new SimpleDoubleProperty(Math.toDegrees(0.5235987755982988));
    private StringProperty period = new SimpleStringProperty("AM");
    private ObjectProperty<Rotate> pointerRotate = new SimpleObjectProperty<Rotate>();
    private ObjectProperty<Rotate> _24HourPointerRotate = new SimpleObjectProperty<Rotate>();
    private ObjectProperty<Label> timeLabel = new SimpleObjectProperty<Label>();
    private NumberStringConverter unitConverter = new NumberStringConverter("#00");
    private ObjectProperty<LocalTime> selectedTime = new SimpleObjectProperty<LocalTime>(this, "selectedTime");

    JFXTimePickerContent(JFXTimePicker jfxTimePicker) {
        this.timePicker = jfxTimePicker;
        LocalTime time = this.timePicker.getValue() == null ? LocalTime.now() : (LocalTime)this.timePicker.getValue();
        this.is24HourView = this.timePicker.is24HourView();
        this.timePicker.valueProperty().addListener((o, oldVal, newVal) -> this.goToTime((LocalTime)newVal));
        this.getStyleClass().add("date-picker-popup");
        this.getChildren().add(this.createHeaderPane(time, this.is24HourView));
        VBox contentHolder = new VBox();
        contentHolder.getChildren().add(this.createContentPane(time, this.is24HourView));
        this.calendarPlaceHolder.getChildren().add(contentHolder);
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind(this.calendarPlaceHolder.widthProperty());
        clip.heightProperty().bind(this.calendarPlaceHolder.heightProperty());
        this.calendarPlaceHolder.setClip(clip);
        StackPane contentPlaceHolder = new StackPane(this.calendarPlaceHolder);
        this.getChildren().add(contentPlaceHolder);
        this.unit.addListener((o, oldVal, newVal) -> {
            if (newVal == TimeUnit.HOURS) {
                this.angle.set(Math.toDegrees(0.5235987755982988));
                int tmp = Integer.parseInt(this.selectedHourLabel.getText());
                if (this.is24HourView) {
                    if (tmp == 0 || tmp > 12) {
                        ((Node)this.hoursContent.getChildren().get(0)).setVisible(false);
                        ((Node)this.hoursContent.getChildren().get(1)).setVisible(true);
                    } else {
                        ((Node)this.hoursContent.getChildren().get(1)).setVisible(false);
                        ((Node)this.hoursContent.getChildren().get(0)).setVisible(true);
                    }
                }
                this.pointerRotate.set(this._24HourHoursPointerRotate);
                this._24HourPointerRotate.set(this._24HourHoursPointerRotate);
                this.timeLabel.set(this.selectedHourLabel);
            } else if (newVal == TimeUnit.MINUTES) {
                this.angle.set(Math.toDegrees(0.10471975511965977));
                this.pointerRotate.set(this.minsPointerRotate);
                this.timeLabel.set(this.selectedMinLabel);
            }
            this.swapLabelsColor(this.selectedHourLabel, this.selectedMinLabel);
            this.switchTimeUnit((TimeUnit)((Object)newVal));
        });
        if (!this.is24HourView) {
            this.period.addListener((o, oldVal, newVal) -> {
                this.swapLabelsColor(this.periodPMLabel, this.periodAMLabel);
                this.updateValue();
            });
        }
    }

    @Override
    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-time-picker.css").toExternalForm();
    }

    protected BorderPane createContentPane(LocalTime time, boolean _24HourView) {
        Circle circle = new Circle(this.contentCircleRadius);
        Circle selectionCircle = new Circle(this.contentCircleRadius / 6.0);
        circle.setFill(Color.rgb(224, 224, 224, 0.67));
        EventHandler<MouseEvent> mouseActionHandler = event -> {
            int timeValue;
            double dx = event.getX();
            double dy = event.getY();
            double shift = 9.0;
            double theta = Math.atan2(dy, dx);
            int index = (int)Math.round((180.0 + Math.toDegrees(theta)) / this.angle.get());
            if (_24HourView) {
                if ((double)this.distance(0.0, 0.0, dx, dy) >= this.contentCircleRadius - shift - 2.0 * selectionCircle.getRadius()) {
                    ((Node)this.hoursContent.getChildren().get(1)).setVisible(false);
                    ((Node)this.hoursContent.getChildren().get(0)).setVisible(true);
                    ((Rotate)this.pointerRotate.get()).setAngle((double)index * this.angle.get());
                    timeValue = (index + 9) % 12 == 0 ? 12 : (index + 9) % 12;
                } else {
                    ((Node)this.hoursContent.getChildren().get(0)).setVisible(false);
                    ((Node)this.hoursContent.getChildren().get(1)).setVisible(true);
                    ((Rotate)this._24HourPointerRotate.get()).setAngle((double)index * this.angle.get());
                    int tmp = (index + 21) % 24 <= 13 ? (index + 21) % 24 + 12 : (index + 21) % 24;
                    timeValue = tmp == 12 ? 0 : tmp;
                }
            } else {
                ((Rotate)this.pointerRotate.get()).setAngle((double)index * this.angle.get());
                int n = timeValue = (index + 9) % 12 == 0 ? 12 : (index + 9) % 12;
            }
            if (this.unit.get() == TimeUnit.MINUTES) {
                timeValue = (index + 45) % 60;
            }
            ((Label)this.timeLabel.get()).setText(this.unit.get() == TimeUnit.MINUTES ? this.unitConverter.toString(timeValue) : Integer.toString(timeValue));
            this.updateValue();
        };
        circle.setOnMousePressed(mouseActionHandler);
        circle.setOnMouseDragged(mouseActionHandler);
        this.hoursContent = this.createHoursContent(time, _24HourView);
        this.hoursContent.setMouseTransparent(true);
        this.minutesContent = this.createMinutesContent(time);
        this.minutesContent.setOpacity(0.0);
        this.minutesContent.setMouseTransparent(true);
        StackPane contentPane = new StackPane();
        contentPane.getChildren().addAll((Node[])new Node[]{circle, this.hoursContent, this.minutesContent});
        contentPane.setPadding(new Insets(12.0));
        BorderPane contentContainer = new BorderPane();
        contentContainer.setCenter(contentPane);
        contentContainer.setMinHeight(50.0);
        contentContainer.setPadding(new Insets(2.0, 12.0, 2.0, 12.0));
        return contentContainer;
    }

    private float distance(double x1, double y1, double x2, double y2) {
        return (float)Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1);
    }

    protected StackPane createHeaderPane(LocalTime time, boolean _24HourView) {
        int hour = time.getHour();
        this.selectedHourLabel.setText(String.valueOf(hour % (_24HourView ? 24 : 12) == 0 ? (_24HourView ? 0 : 12) : hour % (_24HourView ? 24 : 12)));
        this.selectedHourLabel.getStyleClass().add(SPINNER_LABEL);
        this.selectedHourLabel.setTextFill(Color.WHITE);
        this.selectedHourLabel.setFont(Font.font(ROBOTO, FontWeight.BOLD, 42.0));
        this.selectedHourLabel.setOnMouseClicked(click -> this.unit.set(TimeUnit.HOURS));
        this.selectedHourLabel.setMinWidth(49.0);
        this.selectedHourLabel.setAlignment(Pos.CENTER_RIGHT);
        this.timeLabel.set(this.selectedHourLabel);
        this.selectedMinLabel.setText(String.valueOf(this.unitConverter.toString(time.getMinute())));
        this.selectedMinLabel.getStyleClass().add(SPINNER_LABEL);
        this.selectedMinLabel.setTextFill(this.fadedColor);
        this.selectedMinLabel.setFont(Font.font(ROBOTO, FontWeight.BOLD, 42.0));
        this.selectedMinLabel.setOnMouseClicked(click -> this.unit.set(TimeUnit.MINUTES));
        Label separatorLabel = new Label(":");
        separatorLabel.setPadding(new Insets(0.0, 0.0, 4.0, 0.0));
        separatorLabel.setTextFill(this.fadedColor);
        separatorLabel.setFont(Font.font(ROBOTO, FontWeight.BOLD, 42.0));
        this.periodPMLabel = new Label("PM");
        this.periodPMLabel.getStyleClass().add(SPINNER_LABEL);
        this.periodPMLabel.setTextFill(this.fadedColor);
        this.periodPMLabel.setFont(Font.font(ROBOTO, FontWeight.BOLD, 14.0));
        this.periodPMLabel.setOnMouseClicked(click -> this.period.set("PM"));
        this.periodAMLabel = new Label("AM");
        this.periodAMLabel.getStyleClass().add(SPINNER_LABEL);
        this.periodAMLabel.setTextFill(this.fadedColor);
        this.periodAMLabel.setFont(Font.font(ROBOTO, FontWeight.BOLD, 14.0));
        this.periodAMLabel.setOnMouseClicked(click -> this.period.set("AM"));
        if (hour < 12) {
            this.periodAMLabel.setTextFill(Color.WHITE);
        } else {
            this.periodPMLabel.setTextFill(Color.WHITE);
        }
        this.period.set(hour < 12 ? "AM" : "PM");
        VBox periodContainer = new VBox();
        periodContainer.setPadding(new Insets(0.0, 0.0, 0.0, 4.0));
        periodContainer.getChildren().addAll((Node[])new Node[]{this.periodAMLabel, this.periodPMLabel});
        HBox selectedTimeContainer = new HBox();
        selectedTimeContainer.getStyleClass().add("spinner");
        selectedTimeContainer.getChildren().addAll((Node[])new Node[]{this.selectedHourLabel, separatorLabel, this.selectedMinLabel});
        if (!_24HourView) {
            selectedTimeContainer.getChildren().add(periodContainer);
        }
        selectedTimeContainer.setAlignment(Pos.CENTER);
        selectedTimeContainer.setFillHeight(false);
        StackPane headerPanel = new StackPane();
        headerPanel.getStyleClass().add("time-pane");
        headerPanel.setBackground(new Background(new BackgroundFill(this.timePicker.getDefaultColor(), CornerRadii.EMPTY, Insets.EMPTY)));
        headerPanel.setPadding(new Insets(8.0, 24.0, 8.0, 24.0));
        headerPanel.getChildren().add(selectedTimeContainer);
        return headerPanel;
    }

    private StackPane createHoursContent(LocalTime time, boolean _24HourView) {
        double starty;
        double startx;
        double yOffset;
        double xOffset;
        double angle;
        double labelSize;
        StackPane labelContainer;
        Label label;
        int val;
        int i;
        StackPane hoursPointer = new StackPane();
        StackPane _24HoursPointer = new StackPane();
        Circle selectionCircle = new Circle(this.contentCircleRadius / 6.0);
        Circle _24HourSelectionCircle = new Circle(this.contentCircleRadius / 6.0);
        selectionCircle.fillProperty().bind(this.timePicker.defaultColorProperty());
        _24HourSelectionCircle.fillProperty().bind(this.timePicker.defaultColorProperty());
        double shift = 9.0;
        double _24HourShift = 27.5;
        Line line = new Line(shift, 0.0, this.contentCircleRadius, 0.0);
        line.fillProperty().bind(this.timePicker.defaultColorProperty());
        line.strokeProperty().bind(line.fillProperty());
        line.setStrokeWidth(1.5);
        hoursPointer.getChildren().addAll((Node[])new Node[]{line, selectionCircle});
        StackPane.setAlignment(selectionCircle, Pos.CENTER_LEFT);
        Group pointerGroup = new Group();
        pointerGroup.getChildren().add(hoursPointer);
        pointerGroup.setTranslateX((-this.contentCircleRadius + shift) / 2.0);
        this.hoursPointerRotate = new Rotate(0.0, this.contentCircleRadius - shift, selectionCircle.getRadius());
        this.pointerRotate.set(this.hoursPointerRotate);
        pointerGroup.getTransforms().add(this.hoursPointerRotate);
        pointerGroup.setVisible(!this.is24HourView);
        Line _24HourLine = new Line(shift + _24HourShift, 0.0, this.contentCircleRadius, 0.0);
        _24HourLine.fillProperty().bind(this.timePicker.defaultColorProperty());
        _24HourLine.strokeProperty().bind(_24HourLine.fillProperty());
        _24HourLine.setStrokeWidth(1.5);
        _24HoursPointer.getChildren().addAll((Node[])new Node[]{_24HourLine, _24HourSelectionCircle});
        StackPane.setAlignment(_24HourSelectionCircle, Pos.CENTER_LEFT);
        Group pointer24HourGroup = new Group();
        pointer24HourGroup.getChildren().add(_24HoursPointer);
        pointer24HourGroup.setTranslateX((-this.contentCircleRadius + shift) / 2.0 + _24HourShift / 2.0);
        this._24HourHoursPointerRotate = new Rotate(0.0, this.contentCircleRadius - shift - _24HourShift, selectionCircle.getRadius());
        this._24HourPointerRotate.set(this._24HourHoursPointerRotate);
        pointer24HourGroup.getTransforms().add(this._24HourHoursPointerRotate);
        pointer24HourGroup.setVisible(this.is24HourView);
        Pane clockLabelsContainer = new Pane();
        double radius = this.contentCircleRadius - shift - selectionCircle.getRadius();
        for (i = 0; i < 12; ++i) {
            val = (i + 3) % 12 == 0 ? 12 : (i + 3) % 12;
            label = new Label(Integer.toString(val));
            label.setFont(Font.font(ROBOTO, FontWeight.BOLD, 12.0));
            label.setTextFill((val == time.getHour() % 12 || val == 12 && time.getHour() % 12 == 0) && !this.is24HourView ? Color.rgb(255, 255, 255, 0.87) : Color.rgb(0, 0, 0, 0.87));
            this.selectedHourLabel.textProperty().addListener((o, oldVal, newVal) -> {
                if (Integer.parseInt(newVal) == Integer.parseInt(label.getText())) {
                    label.setTextFill(Color.rgb(255, 255, 255, 0.87));
                } else {
                    label.setTextFill(Color.rgb(0, 0, 0, 0.87));
                }
            });
            labelContainer = new StackPane();
            labelContainer.getChildren().add(label);
            labelSize = selectionCircle.getRadius() / Math.sqrt(2.0) * 2.0;
            labelContainer.setMinSize(labelSize, labelSize);
            angle = (double)(2 * i) * Math.PI / 12.0;
            xOffset = radius * Math.cos(angle);
            yOffset = radius * Math.sin(angle);
            startx = this.contentCircleRadius + xOffset;
            starty = this.contentCircleRadius + yOffset;
            labelContainer.setLayoutX(startx - labelContainer.getMinWidth() / 2.0);
            labelContainer.setLayoutY(starty - labelContainer.getMinHeight() / 2.0);
            clockLabelsContainer.getChildren().add(labelContainer);
            if (this.is24HourView || val != time.getHour() % 12 && (val != 12 || time.getHour() % 12 != 0)) continue;
            this.hoursPointerRotate.setAngle(180.0 + Math.toDegrees(angle));
        }
        if (_24HourView) {
            radius /= 1.6;
            for (i = 0; i < 12; ++i) {
                val = (i + 3) % 12 == 0 ? 12 : (i + 3) % 12;
                label = new Label(Integer.toString(val += val == 12 ? -12 : 12) + (val == 0 ? "0" : ""));
                label.setFont(Font.font(ROBOTO, FontWeight.NORMAL, 10.0));
                label.setTextFill(val == time.getHour() % 24 || val == 0 && time.getHour() % 24 == 0 && this.is24HourView ? Color.rgb(255, 255, 255, 0.54) : Color.rgb(0, 0, 0, 0.54));
                this.selectedHourLabel.textProperty().addListener((o, oldVal, newVal) -> {
                    if (Integer.parseInt(newVal) == Integer.parseInt(label.getText())) {
                        label.setTextFill(Color.rgb(255, 255, 255, 0.54));
                    } else {
                        label.setTextFill(Color.rgb(0, 0, 0, 0.54));
                    }
                });
                labelContainer = new StackPane();
                labelContainer.getChildren().add(label);
                labelSize = selectionCircle.getRadius() / Math.sqrt(2.0) * 2.0;
                labelContainer.setMinSize(labelSize, labelSize);
                angle = (double)(2 * i) * Math.PI / 12.0;
                xOffset = radius * Math.cos(angle);
                yOffset = radius * Math.sin(angle);
                startx = this.contentCircleRadius + xOffset;
                starty = this.contentCircleRadius + yOffset;
                labelContainer.setLayoutX(startx - labelContainer.getMinWidth() / 2.0);
                labelContainer.setLayoutY(starty - labelContainer.getMinHeight() / 2.0);
                clockLabelsContainer.getChildren().add(labelContainer);
                if (val != time.getHour() % 24 && (val != 24 || time.getHour() % 24 != 0)) continue;
                this._24HourHoursPointerRotate.setAngle(180.0 + Math.toDegrees(angle));
            }
        }
        if (_24HourView) {
            return new StackPane(pointerGroup, pointer24HourGroup, clockLabelsContainer);
        }
        return new StackPane(pointerGroup, clockLabelsContainer);
    }

    private StackPane createMinutesContent(LocalTime time) {
        StackPane minsPointer = new StackPane();
        Circle selectionCircle = new Circle(this.contentCircleRadius / 6.0);
        selectionCircle.fillProperty().bind(this.timePicker.defaultColorProperty());
        Circle minCircle = new Circle(selectionCircle.getRadius() / 8.0);
        minCircle.setFill(Color.rgb(255, 255, 255, 0.87));
        minCircle.setTranslateX(selectionCircle.getRadius() - minCircle.getRadius());
        minCircle.setVisible(time.getMinute() % 5 != 0);
        this.selectedMinLabel.textProperty().addListener((o, oldVal, newVal) -> {
            if (Integer.parseInt(newVal) % 5 == 0) {
                minCircle.setVisible(false);
            } else {
                minCircle.setVisible(true);
            }
        });
        double shift = 9.0;
        Line line = new Line(shift, 0.0, this.contentCircleRadius, 0.0);
        line.fillProperty().bind(this.timePicker.defaultColorProperty());
        line.strokeProperty().bind(line.fillProperty());
        line.setStrokeWidth(1.5);
        minsPointer.getChildren().addAll((Node[])new Node[]{line, selectionCircle, minCircle});
        StackPane.setAlignment(selectionCircle, Pos.CENTER_LEFT);
        StackPane.setAlignment(minCircle, Pos.CENTER_LEFT);
        Group pointerGroup = new Group();
        pointerGroup.getChildren().add(minsPointer);
        pointerGroup.setTranslateX((-this.contentCircleRadius + shift) / 2.0);
        this.minsPointerRotate = new Rotate(0.0, this.contentCircleRadius - shift, selectionCircle.getRadius());
        pointerGroup.getTransforms().add(this.minsPointerRotate);
        Pane clockLabelsContainer = new Pane();
        double radius = this.contentCircleRadius - shift - selectionCircle.getRadius();
        for (int i = 0; i < 12; ++i) {
            StackPane labelContainer = new StackPane();
            int val = (i + 3) * 5 % 60;
            Label label = new Label(String.valueOf(this.unitConverter.toString(val)));
            label.setFont(Font.font(ROBOTO, FontWeight.BOLD, 12.0));
            label.setTextFill(val == time.getMinute() ? Color.rgb(255, 255, 255, 0.87) : Color.rgb(0, 0, 0, 0.87));
            this.selectedMinLabel.textProperty().addListener((o, oldVal, newVal) -> {
                if (Integer.parseInt(newVal) == Integer.parseInt(label.getText())) {
                    label.setTextFill(Color.rgb(255, 255, 255, 0.87));
                } else {
                    label.setTextFill(Color.rgb(0, 0, 0, 0.87));
                }
            });
            labelContainer.getChildren().add(label);
            double labelSize = selectionCircle.getRadius() / Math.sqrt(2.0) * 2.0;
            labelContainer.setMinSize(labelSize, labelSize);
            double angle = (double)(2 * i) * Math.PI / 12.0;
            double xOffset = radius * Math.cos(angle);
            double yOffset = radius * Math.sin(angle);
            double startx = this.contentCircleRadius + xOffset;
            double starty = this.contentCircleRadius + yOffset;
            labelContainer.setLayoutX(startx - labelContainer.getMinWidth() / 2.0);
            labelContainer.setLayoutY(starty - labelContainer.getMinHeight() / 2.0);
            clockLabelsContainer.getChildren().add(labelContainer);
        }
        this.minsPointerRotate.setAngle(180.0 + (double)((time.getMinute() + 45) % 60) * Math.toDegrees(0.10471975511965977));
        return new StackPane(pointerGroup, clockLabelsContainer);
    }

    ObjectProperty<LocalTime> displayedTimeProperty() {
        return this.selectedTime;
    }

    void init() {
        this.calendarPlaceHolder.setOpacity(1.0);
        if (this.unit.get() == TimeUnit.HOURS) {
            this.selectedHourLabel.setTextFill(Color.rgb(255, 255, 255, 0.87));
        } else {
            this.selectedMinLabel.setTextFill(Color.rgb(255, 255, 255, 0.87));
        }
    }

    private void swapLabelsColor(Label lbl1, Label lbl2) {
        Paint color = lbl1.getTextFill();
        lbl1.setTextFill(lbl2.getTextFill());
        lbl2.setTextFill(color);
    }

    private void switchTimeUnit(TimeUnit newVal) {
        if (newVal == TimeUnit.HOURS) {
            Timeline fadeout = new Timeline(new KeyFrame(Duration.millis(320.0), new KeyValue(this.minutesContent.opacityProperty(), 0, Interpolator.EASE_BOTH)));
            Timeline fadein = new Timeline(new KeyFrame(Duration.millis(320.0), new KeyValue(this.hoursContent.opacityProperty(), 1, Interpolator.EASE_BOTH)));
            new ParallelTransition(fadeout, fadein).play();
        } else {
            Timeline fadeout = new Timeline(new KeyFrame(Duration.millis(320.0), new KeyValue(this.hoursContent.opacityProperty(), 0, Interpolator.EASE_BOTH)));
            Timeline fadein = new Timeline(new KeyFrame(Duration.millis(320.0), new KeyValue(this.minutesContent.opacityProperty(), 1, Interpolator.EASE_BOTH)));
            new ParallelTransition(fadeout, fadein).play();
        }
    }

    void updateValue() {
        if (this.is24HourView) {
            LocalTimeStringConverter localTimeStringConverter = new LocalTimeStringConverter(FormatStyle.SHORT, Locale.GERMAN);
            this.timePicker.setValue(localTimeStringConverter.fromString(this.selectedHourLabel.getText() + ":" + this.selectedMinLabel.getText()));
        } else {
            this.timePicker.setValue(LocalTime.parse(this.selectedHourLabel.getText() + ":" + this.selectedMinLabel.getText() + " " + (String)this.period.get(), DateTimeFormatter.ofPattern("h:mm a").withLocale(Locale.ENGLISH)));
        }
    }

    private void goToTime(LocalTime time) {
        if (time != null) {
            int hour = time.getHour();
            this.selectedHourLabel.setText(Integer.toString(hour % (this.is24HourView ? 24 : 12) == 0 ? (this.is24HourView ? 0 : 12) : hour % (this.is24HourView ? 24 : 12)));
            this.selectedMinLabel.setText(this.unitConverter.toString(time.getMinute()));
            if (!this.is24HourView) {
                this.period.set(hour < 12 ? "AM" : "PM");
            }
            this.minsPointerRotate.setAngle(180.0 + (double)((time.getMinute() + 45) % 60) * Math.toDegrees(0.10471975511965977));
            this.hoursPointerRotate.setAngle(180.0 + Math.toDegrees((double)(2 * (hour - 3)) * Math.PI / 12.0));
            this._24HourHoursPointerRotate.setAngle(180.0 + Math.toDegrees((double)(2 * (hour - 3)) * Math.PI / 12.0));
        }
    }

    void clearFocus() {
        LocalTime focusTime = (LocalTime)this.timePicker.getValue();
        if (focusTime == null) {
            focusTime = LocalTime.now();
        }
        this.goToTime(focusTime);
    }

    private static enum TimeUnit {
        HOURS,
        MINUTES;

    }
}

