/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.controls.base.IFXLabelFloatControl;
import com.jfoenix.controls.base.IFXStaticControl;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import java.lang.reflect.Field;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;

public class JFXTextFieldSkin<T extends TextField>
extends TextFieldSkin {
    private boolean invalid = true;
    private Text promptText;
    private Pane textPane = (Pane)this.getChildren().get(0);
    private Node textNode = (Node)ReflectionHelper.getFieldContent(TextFieldSkin.class, this, "textNode");
    private ObservableDoubleValue textRight;
    private DoubleProperty textTranslateX = (DoubleProperty)ReflectionHelper.getFieldContent(TextFieldSkin.class, this, "textTranslateX");
    private ValidationPane<T> errorContainer;
    private PromptLinesWrapper<T> linesWrapper;

    public JFXTextFieldSkin(T textField) {
        super((TextField)textField);
        this.textRight = (ObservableDoubleValue)ReflectionHelper.getFieldContent(TextFieldSkin.class, this, "textRight");
        this.linesWrapper = new PromptLinesWrapper<T>(textField, this.promptTextFillProperty(), ((TextInputControl)textField).textProperty(), ((TextInputControl)textField).promptTextProperty(), () -> this.promptText);
        this.linesWrapper.init(() -> this.createPromptNode(), this.textPane);
        ReflectionHelper.setFieldContent(TextFieldSkin.class, this, "usePromptText", this.linesWrapper.usePromptText);
        this.errorContainer = new ValidationPane<T>(textField);
        this.getChildren().addAll((Node[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        this.registerChangeListener(((Node)textField).disableProperty(), obs -> this.linesWrapper.updateDisabled());
        this.registerChangeListener(((IFXLabelFloatControl)textField).focusColorProperty(), obs -> this.linesWrapper.updateFocusColor());
        this.registerChangeListener(((IFXLabelFloatControl)textField).unFocusColorProperty(), obs -> this.linesWrapper.updateUnfocusColor());
        this.registerChangeListener(((IFXStaticControl)textField).disableAnimationProperty(), obs -> this.errorContainer.updateClip());
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double height = ((TextField)this.getSkinnable()).getHeight();
        this.linesWrapper.layoutLines(x, y, w, h, height, Math.floor(h));
        this.errorContainer.layoutPane(x, height + this.linesWrapper.focusedLine.getHeight(), w, h);
        if (((TextField)this.getSkinnable()).getWidth() > 0.0) {
            this.updateTextPos();
        }
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            this.errorContainer.invalid(w);
            this.linesWrapper.invalid();
        }
    }

    private void updateTextPos() {
        double textWidth = this.textNode.getLayoutBounds().getWidth();
        double promptWidth = this.promptText == null ? 0.0 : this.promptText.getLayoutBounds().getWidth();
        switch (((TextField)this.getSkinnable()).getAlignment().getHpos()) {
            case CENTER: {
                this.linesWrapper.promptTextScale.setPivotX(promptWidth / 2.0);
                double midPoint = this.textRight.get() / 2.0;
                double newX = midPoint - textWidth / 2.0;
                if (!(newX + textWidth <= this.textRight.get())) break;
                this.textTranslateX.set(newX);
                break;
            }
            case LEFT: {
                this.linesWrapper.promptTextScale.setPivotX(0.0);
                break;
            }
            case RIGHT: {
                this.linesWrapper.promptTextScale.setPivotX(promptWidth);
            }
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add("text");
        this.promptText.visibleProperty().bind(this.linesWrapper.usePromptText);
        this.promptText.fontProperty().bind(((TextField)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind(((TextField)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind(this.linesWrapper.animatedPromptTextFill);
        this.promptText.setLayoutX(1.0);
        this.promptText.getTransforms().add(this.linesWrapper.promptTextScale);
        this.linesWrapper.promptContainer.getChildren().add(this.promptText);
        if (((TextField)this.getSkinnable()).isFocused() && ((IFXLabelFloatControl)((Object)this.getSkinnable())).isLabelFloat()) {
            this.promptText.setTranslateY(-Math.floor(this.textPane.getHeight()));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
        try {
            Field field = ReflectionHelper.getField(TextFieldSkin.class, "promptNode");
            Object oldValue = field.get(this);
            if (oldValue != null) {
                this.textPane.getChildren().remove(oldValue);
            }
            field.set(this, this.promptText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

