/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import java.lang.reflect.Field;
import java.util.Arrays;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.skin.TextAreaSkin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;

public class JFXTextAreaSkin
extends TextAreaSkin {
    private boolean invalid = true;
    private ScrollPane scrollPane = (ScrollPane)this.getChildren().get(0);
    private Text promptText;
    private ValidationPane<JFXTextArea> errorContainer;
    private PromptLinesWrapper<JFXTextArea> linesWrapper;

    public JFXTextAreaSkin(JFXTextArea textArea) {
        super(textArea);
        textArea.setWrapText(true);
        this.linesWrapper = new PromptLinesWrapper<JFXTextArea>(textArea, this.promptTextFillProperty(), textArea.textProperty(), textArea.promptTextProperty(), () -> this.promptText);
        this.linesWrapper.init(() -> this.createPromptNode(), this.scrollPane);
        this.errorContainer = new ValidationPane<JFXTextArea>(textArea);
        this.getChildren().addAll((Node[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        this.registerChangeListener(textArea.disableProperty(), obs -> this.linesWrapper.updateDisabled());
        this.registerChangeListener(textArea.focusColorProperty(), obs -> this.linesWrapper.updateFocusColor());
        this.registerChangeListener(textArea.unFocusColorProperty(), obs -> this.linesWrapper.updateUnfocusColor());
        this.registerChangeListener(textArea.disableAnimationProperty(), obs -> this.errorContainer.updateClip());
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double height = ((TextArea)this.getSkinnable()).getHeight();
        this.linesWrapper.layoutLines(x, y, w, h, height, this.promptText == null ? 0.0 : this.promptText.getLayoutBounds().getHeight() + 3.0);
        this.errorContainer.layoutPane(x, height + this.linesWrapper.focusedLine.getHeight(), w, h);
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            Region viewPort = (Region)this.scrollPane.getChildrenUnmodifiable().get(0);
            viewPort.setBackground(new Background(new BackgroundFill(Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)));
            viewPort.applyCss();
            this.errorContainer.invalid(w);
            this.linesWrapper.invalid();
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add("text");
        this.promptText.visibleProperty().bind(this.linesWrapper.usePromptText);
        this.promptText.fontProperty().bind(((TextArea)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind(((TextArea)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind(this.linesWrapper.animatedPromptTextFill);
        this.promptText.setLayoutX(1.0);
        this.promptText.setTranslateX(1.0);
        this.promptText.getTransforms().add(this.linesWrapper.promptTextScale);
        this.linesWrapper.promptContainer.getChildren().add(this.promptText);
        if (((TextArea)this.getSkinnable()).isFocused() && ((JFXTextArea)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-Math.floor(this.scrollPane.getHeight()));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
        try {
            Field field = ReflectionHelper.getField(TextAreaSkin.class, "promptNode");
            Object oldValue = field.get(this);
            if (oldValue != null) {
                this.removeHighlight(Arrays.asList((Node)oldValue));
            }
            field.set(this, this.promptText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

