/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXSlider;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.css.PseudoClass;
import javafx.geometry.Orientation;
import javafx.scene.control.Slider;
import javafx.scene.control.skin.SliderSkin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXSliderSkin
extends SliderSkin {
    private final Pane mouseHandlerPane = new Pane();
    private static final PseudoClass MIN_VALUE = PseudoClass.getPseudoClass("min");
    private static final PseudoClass MAX_VALUE = PseudoClass.getPseudoClass("max");
    private Text sliderValue;
    private StackPane coloredTrack;
    private StackPane thumb;
    private StackPane track = (StackPane)((Slider)this.getSkinnable()).lookup(".track");
    private StackPane animatedThumb;
    private Timeline timeline;
    private double indicatorRotation;
    private double horizontalRotation;
    private double shifting;
    private boolean isValid = false;

    public JFXSliderSkin(JFXSlider slider) {
        super(slider);
        this.thumb = (StackPane)((Slider)this.getSkinnable()).lookup(".thumb");
        this.coloredTrack = new StackPane();
        this.coloredTrack.getStyleClass().add("colored-track");
        this.coloredTrack.setMouseTransparent(true);
        this.sliderValue = new Text();
        this.sliderValue.getStyleClass().setAll((String[])new String[]{"slider-value"});
        this.animatedThumb = new StackPane();
        this.animatedThumb.getStyleClass().add("animated-thumb");
        this.animatedThumb.getChildren().add(this.sliderValue);
        this.animatedThumb.setMouseTransparent(true);
        this.animatedThumb.setScaleX(0.0);
        this.animatedThumb.setScaleY(0.0);
        this.getChildren().add(this.getChildren().indexOf(this.thumb), this.coloredTrack);
        this.getChildren().add(this.getChildren().indexOf(this.thumb), this.animatedThumb);
        this.getChildren().add(0, this.mouseHandlerPane);
        this.registerChangeListener(slider.valueFactoryProperty(), obs -> this.refreshSliderValueBinding());
        this.initListeners();
    }

    private void refreshSliderValueBinding() {
        this.sliderValue.textProperty().unbind();
        if (((JFXSlider)this.getSkinnable()).getValueFactory() != null) {
            this.sliderValue.textProperty().bind(((JFXSlider)this.getSkinnable()).getValueFactory().call((JFXSlider)this.getSkinnable()));
        } else {
            this.sliderValue.textProperty().bind(Bindings.createStringBinding(() -> {
                if (((Slider)this.getSkinnable()).getLabelFormatter() != null) {
                    return ((Slider)this.getSkinnable()).getLabelFormatter().toString(((Slider)this.getSkinnable()).getValue());
                }
                return String.valueOf(Math.round(((Slider)this.getSkinnable()).getValue()));
            }, ((Slider)this.getSkinnable()).valueProperty()));
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double layoutY;
        double layoutX;
        double height;
        double width;
        boolean horizontal;
        super.layoutChildren(x, y, w, h);
        if (!this.isValid) {
            this.initializeVariables();
            this.initAnimation(((Slider)this.getSkinnable()).getOrientation());
            this.isValid = true;
        }
        double prefWidth = this.animatedThumb.prefWidth(-1.0);
        this.animatedThumb.resize(prefWidth, this.animatedThumb.prefHeight(prefWidth));
        boolean bl = horizontal = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        if (horizontal) {
            width = this.thumb.getLayoutX() - this.snappedLeftInset();
            height = this.track.getHeight();
            layoutX = this.track.getLayoutX();
            layoutY = this.track.getLayoutY();
            this.animatedThumb.setLayoutX(this.thumb.getLayoutX() + this.thumb.getWidth() / 2.0 - this.animatedThumb.getWidth() / 2.0);
        } else {
            height = this.track.getLayoutBounds().getMaxY() + this.track.getLayoutY() - this.thumb.getLayoutY() - this.snappedBottomInset();
            width = this.track.getWidth();
            layoutX = this.track.getLayoutX();
            layoutY = this.thumb.getLayoutY();
            this.animatedThumb.setLayoutY(this.thumb.getLayoutY() + this.thumb.getHeight() / 2.0 - this.animatedThumb.getHeight() / 2.0);
        }
        this.coloredTrack.resizeRelocate(layoutX, layoutY, width, height);
        this.mouseHandlerPane.resizeRelocate(x, y, w, h);
    }

    private void initializeVariables() {
        this.shifting = 30.0 + this.thumb.getWidth();
        if (((Slider)this.getSkinnable()).getOrientation() != Orientation.HORIZONTAL) {
            this.horizontalRotation = -90.0;
        }
        if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() != JFXSlider.IndicatorPosition.LEFT) {
            this.indicatorRotation = 180.0;
            this.shifting = -this.shifting;
        }
        double rotationAngle = 45.0;
        this.sliderValue.setRotate(45.0 + this.indicatorRotation + 3.0 * this.horizontalRotation);
        this.animatedThumb.setRotate(-45.0 + this.indicatorRotation + this.horizontalRotation);
    }

    private void initListeners() {
        this.mouseHandlerPane.setOnMousePressed(this::delegateToTrack);
        this.mouseHandlerPane.setOnMouseReleased(this::delegateToTrack);
        this.mouseHandlerPane.setOnMouseDragged(this::delegateToTrack);
        this.track.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.timeline.setRate(1.0);
            this.timeline.play();
        });
        this.track.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            this.timeline.setRate(-1.0);
            this.timeline.play();
        });
        this.thumb.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.timeline.setRate(1.0);
            this.timeline.play();
        });
        this.thumb.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            this.timeline.setRate(-1.0);
            this.timeline.play();
        });
        this.refreshSliderValueBinding();
        this.updateValueStyleClass();
        ((Slider)this.getSkinnable()).valueProperty().addListener(observable -> this.updateValueStyleClass());
        ((Slider)this.getSkinnable()).orientationProperty().addListener(observable -> this.initAnimation(((Slider)this.getSkinnable()).getOrientation()));
    }

    private void delegateToTrack(MouseEvent event) {
        if (!event.isConsumed()) {
            event.consume();
            this.track.fireEvent(event);
        }
    }

    private void updateValueStyleClass() {
        ((Slider)this.getSkinnable()).pseudoClassStateChanged(MIN_VALUE, ((Slider)this.getSkinnable()).getMin() == ((Slider)this.getSkinnable()).getValue());
        ((Slider)this.getSkinnable()).pseudoClassStateChanged(MAX_VALUE, ((Slider)this.getSkinnable()).getMax() == ((Slider)this.getSkinnable()).getValue());
    }

    private void initAnimation(Orientation orientation) {
        DoubleProperty layoutProperty;
        double thumbNewPos;
        double thumbPos;
        if (orientation == Orientation.HORIZONTAL) {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                thumbPos = this.thumb.getLayoutY() - this.thumb.getHeight();
                thumbNewPos = thumbPos - this.shifting;
            } else {
                double height = this.animatedThumb.prefHeight(this.animatedThumb.prefWidth(-1.0));
                thumbPos = this.thumb.getLayoutY() - height / 2.0;
                thumbNewPos = this.thumb.getLayoutY() - height - this.thumb.getHeight();
            }
            layoutProperty = this.animatedThumb.translateYProperty();
        } else {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                thumbPos = this.thumb.getLayoutX() - this.thumb.getWidth();
                thumbNewPos = thumbPos - this.shifting;
            } else {
                double width = this.animatedThumb.prefWidth(-1.0);
                thumbPos = this.thumb.getLayoutX() - width / 2.0;
                thumbNewPos = this.thumb.getLayoutX() - width - this.thumb.getWidth();
            }
            layoutProperty = this.animatedThumb.translateXProperty();
        }
        this.clearAnimation();
        this.timeline = new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(this.animatedThumb.scaleXProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(this.animatedThumb.scaleYProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(layoutProperty, thumbPos, Interpolator.EASE_BOTH)), new KeyFrame(Duration.seconds(0.2), new KeyValue(this.animatedThumb.scaleXProperty(), 1, Interpolator.EASE_BOTH), new KeyValue(this.animatedThumb.scaleYProperty(), 1, Interpolator.EASE_BOTH), new KeyValue(layoutProperty, thumbNewPos, Interpolator.EASE_BOTH)));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearAnimation();
    }

    private void clearAnimation() {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
            this.timeline = null;
        }
    }
}

