/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXPopup;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CacheMemento;
import com.jfoenix.transitions.CachedTransition;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class JFXPopupSkin
implements Skin<JFXPopup> {
    protected JFXPopup control;
    protected StackPane container = new StackPane();
    protected Region popupContent;
    protected Node root;
    private Animation animation;
    protected Scale scale;

    public JFXPopupSkin(JFXPopup control) {
        this.control = control;
        this.scale = new Scale(1.0, 0.01, 0.0, 0.0);
        this.popupContent = control.getPopupContent();
        this.container.getStyleClass().add("jfx-popup-container");
        this.container.setBackground(new Background(new BackgroundFill(Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)));
        this.container.getChildren().add(this.popupContent);
        this.container.getTransforms().add(this.scale);
        this.container.setOpacity(0.0);
        this.root = JFXDepthManager.createMaterialNode(this.container, 4);
        this.animation = this.getAnimation();
    }

    public void reset(JFXPopup.PopupVPosition vAlign, JFXPopup.PopupHPosition hAlign, double offsetX, double offsetY) {
        this.scale.setPivotX(hAlign == JFXPopup.PopupHPosition.RIGHT ? this.container.getWidth() : 0.0);
        this.scale.setPivotY(vAlign == JFXPopup.PopupVPosition.BOTTOM ? this.container.getHeight() : 0.0);
        this.root.setTranslateX(hAlign == JFXPopup.PopupHPosition.RIGHT ? -this.container.getWidth() + offsetX : offsetX);
        this.root.setTranslateY(vAlign == JFXPopup.PopupVPosition.BOTTOM ? -this.container.getHeight() + offsetY : offsetY);
    }

    public final void animate() {
        if (this.animation.getStatus() == Animation.Status.STOPPED) {
            this.animation.play();
        }
    }

    @Override
    public JFXPopup getSkinnable() {
        return this.control;
    }

    @Override
    public Node getNode() {
        return this.root;
    }

    @Override
    public void dispose() {
        this.animation.stop();
        this.animation = null;
        this.container = null;
        this.control = null;
        this.popupContent = null;
        this.root = null;
    }

    protected Animation getAnimation() {
        return new PopupTransition();
    }

    public void init() {
        this.animation.stop();
        this.container.setOpacity(0.0);
        this.scale.setX(1.0);
        this.scale.setY(0.1);
    }

    private final class PopupTransition
    extends CachedTransition {
        PopupTransition() {
            super(JFXPopupSkin.this.root, new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(JFXPopupSkin.this.popupContent.opacityProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(JFXPopupSkin.this.scale.xProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(JFXPopupSkin.this.scale.yProperty(), 0, Interpolator.EASE_BOTH)), new KeyFrame(Duration.millis(700.0), new KeyValue(JFXPopupSkin.this.scale.xProperty(), 1, Interpolator.EASE_BOTH), new KeyValue(JFXPopupSkin.this.popupContent.opacityProperty(), 0, Interpolator.EASE_BOTH)), new KeyFrame(Duration.millis(1000.0), new KeyValue(JFXPopupSkin.this.popupContent.opacityProperty(), 1, Interpolator.EASE_BOTH), new KeyValue(JFXPopupSkin.this.scale.yProperty(), 1, Interpolator.EASE_BOTH))), new CacheMemento(JFXPopupSkin.this.popupContent));
            this.setCycleDuration(Duration.seconds(0.4));
            this.setDelay(Duration.seconds(0.0));
        }

        @Override
        protected void starting() {
            JFXPopupSkin.this.container.setOpacity(1.0);
            super.starting();
        }
    }
}

