/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.controls.behavior.JFXGenericPickerBehavior;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.stage.WindowEventDispatcher;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxBaseSkin;
import javafx.scene.control.skin.ComboBoxPopupControl;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Window;

public abstract class JFXGenericPickerSkin<T>
extends ComboBoxPopupControl<T> {
    private final EventHandler<MouseEvent> mouseEnteredEventHandler;
    private final EventHandler<MouseEvent> mousePressedEventHandler;
    private final EventHandler<MouseEvent> mouseReleasedEventHandler;
    private final EventHandler<MouseEvent> mouseExitedEventHandler;
    protected JFXGenericPickerBehavior<T> behavior;
    protected Pane arrowButton;
    protected PopupControl popup;
    private BiConsumer<String, EventType<?>> parentArrowEventHandlerTerminator = (handlerName, eventType) -> {
        try {
            EventHandler handler = (EventHandler)ReflectionHelper.getFieldContent(ComboBoxBaseSkin.class, this, handlerName);
            this.arrowButton.removeEventHandler(eventType, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    };
    private HashMap<String, Method> parentCachedMethods = new HashMap();
    Function<String, Method> methodSupplier = name -> {
        if (!this.parentCachedMethods.containsKey(name)) {
            try {
                Method method = ReflectionHelper.getMethod(ComboBoxPopupControl.class, name);
                this.parentCachedMethods.put((String)name, method);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.parentCachedMethods.get(name);
    };
    Consumer<Method> methodInvoker = method -> {
        try {
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    };
    Function<Method, Object> methodReturnInvoker = method -> {
        try {
            return method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    };

    public JFXGenericPickerSkin(ComboBoxBase<T> comboBoxBase) {
        super(comboBoxBase);
        this.behavior = new JFXGenericPickerBehavior<T>(comboBoxBase);
        this.removeParentFakeFocusListener(comboBoxBase);
        this.mouseEnteredEventHandler = event -> this.behavior.mouseEntered((MouseEvent)event);
        this.mousePressedEventHandler = event -> {
            this.behavior.mousePressed((MouseEvent)event);
            event.consume();
        };
        this.mouseReleasedEventHandler = event -> {
            this.behavior.mouseReleased((MouseEvent)event);
            event.consume();
        };
        this.mouseExitedEventHandler = event -> this.behavior.mouseExited((MouseEvent)event);
        this.arrowButton = (Pane)this.getChildren().get(0);
        this.parentArrowEventHandlerTerminator.accept("mouseEnteredEventHandler", MouseEvent.MOUSE_ENTERED);
        this.parentArrowEventHandlerTerminator.accept("mousePressedEventHandler", MouseEvent.MOUSE_PRESSED);
        this.parentArrowEventHandlerTerminator.accept("mouseReleasedEventHandler", MouseEvent.MOUSE_RELEASED);
        this.parentArrowEventHandlerTerminator.accept("mouseExitedEventHandler", MouseEvent.MOUSE_EXITED);
        this.unregisterChangeListeners(comboBoxBase.editableProperty());
        this.updateArrowButtonListeners();
        this.registerChangeListener(comboBoxBase.editableProperty(), obs -> {
            this.updateArrowButtonListeners();
            this.reflectUpdateDisplayArea();
        });
        this.removeParentPopupHandlers();
        this.popup = (PopupControl)ReflectionHelper.getFieldContent(ComboBoxPopupControl.class, this, "popup");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    private void removeParentFakeFocusListener(ComboBoxBase<T> comboBoxBase) {
        try {
            ReadOnlyBooleanProperty focusedProperty = comboBoxBase.focusedProperty();
            ExpressionHelper value = (ExpressionHelper)ReflectionHelper.getFieldContent(focusedProperty.getClass().getSuperclass(), focusedProperty, "helper");
            ChangeListener[] changeListeners = (ChangeListener[])ReflectionHelper.getFieldContent(value.getClass(), value, "changeListeners");
            for (int i = changeListeners.length - 1; i > 0; --i) {
                if (changeListeners[i] == null || !changeListeners[i].getClass().getName().contains("ComboBoxPopupControl")) continue;
                focusedProperty.removeListener(changeListeners[i]);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeParentPopupHandlers() {
        try {
            PopupControl popup = (PopupControl)ReflectionHelper.invoke(ComboBoxPopupControl.class, this, "getPopup");
            popup.setOnAutoHide(event -> this.behavior.onAutoHide(popup));
            WindowEventDispatcher dispatcher = (WindowEventDispatcher)ReflectionHelper.invoke(Window.class, popup, "getInternalEventDispatcher");
            Map compositeEventHandlersMap = (Map)ReflectionHelper.getFieldContent(EventHandlerManager.class, dispatcher.getEventHandlerManager(), "eventHandlerMap");
            compositeEventHandlersMap.remove(MouseEvent.MOUSE_CLICKED);
            popup.addEventHandler(MouseEvent.MOUSE_CLICKED, click -> this.behavior.onAutoHide(popup));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateArrowButtonListeners() {
        if (((ComboBoxBase)this.getSkinnable()).isEditable()) {
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedEventHandler);
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedEventHandler);
        } else {
            this.arrowButton.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEnteredEventHandler);
            this.arrowButton.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedEventHandler);
            this.arrowButton.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedEventHandler);
            this.arrowButton.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExitedEventHandler);
        }
    }

    protected void reflectUpdateDisplayArea() {
        this.methodInvoker.accept(this.methodSupplier.apply("updateDisplayArea"));
    }

    protected void reflectSetTextFromTextFieldIntoComboBoxValue() {
        this.methodInvoker.accept(this.methodSupplier.apply("setTextFromTextFieldIntoComboBoxValue"));
    }

    protected TextField reflectGetEditableInputNode() {
        return (TextField)this.methodReturnInvoker.apply(this.methodSupplier.apply("getEditableInputNode"));
    }

    protected void reflectUpdateDisplayNode() {
        this.methodInvoker.accept(this.methodSupplier.apply("updateDisplayNode"));
    }
}

