/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.skins.JFXDatePickerContent;
import com.jfoenix.skins.JFXGenericPickerSkin;
import java.time.LocalDate;
import java.time.YearMonth;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class JFXDatePickerSkin
extends JFXGenericPickerSkin<LocalDate> {
    private JFXDatePicker jfxDatePicker;
    private TextField displayNode;
    private JFXDatePickerContent content;
    private JFXDialog dialog;

    public JFXDatePickerSkin(JFXDatePicker datePicker) {
        super(datePicker);
        this.jfxDatePicker = datePicker;
        datePicker.focusedProperty().addListener(observable -> {
            if (this.getEditor() != null && !datePicker.isFocused()) {
                this.reflectSetTextFromTextFieldIntoComboBoxValue();
            }
        });
        this.updateArrow(datePicker);
        ((JFXTextField)this.getEditor()).setFocusColor(this.jfxDatePicker.getDefaultColor());
        this.registerChangeListener(datePicker.defaultColorProperty(), obs -> this.updateArrow(datePicker));
        this.registerChangeListener(datePicker.converterProperty(), obs -> this.reflectUpdateDisplayNode());
        this.registerChangeListener(datePicker.editableProperty(), obs -> this.reflectGetEditableInputNode());
        this.registerChangeListener(datePicker.dayCellFactoryProperty(), obs -> {
            this.reflectUpdateDisplayNode();
            this.content = null;
            this.popup = null;
        });
        this.registerChangeListener(datePicker.valueProperty(), obs -> {
            this.reflectUpdateDisplayNode();
            if (this.content != null) {
                LocalDate date = (LocalDate)this.jfxDatePicker.getValue();
                this.content.displayedYearMonthProperty().set(date != null ? YearMonth.from(date) : YearMonth.now());
                this.content.updateValues();
            }
            this.jfxDatePicker.fireEvent(new ActionEvent());
        });
        this.registerChangeListener(datePicker.showWeekNumbersProperty(), obs -> {
            if (this.content != null) {
                this.content.updateContentGrid();
                this.content.updateWeekNumberDateCells();
            }
        });
        this.registerChangeListener(datePicker.showingProperty(), obs -> {
            if (this.jfxDatePicker.isShowing()) {
                if (this.content != null) {
                    LocalDate date = (LocalDate)this.jfxDatePicker.getValue();
                    this.content.displayedYearMonthProperty().set(date != null ? YearMonth.from(date) : YearMonth.now());
                    this.content.updateValues();
                }
                this.show();
            } else {
                this.hide();
            }
        });
    }

    private void updateArrow(JFXDatePicker datePicker) {
        ((Region)this.arrowButton.getChildren().get(0)).setBackground(new Background(new BackgroundFill(datePicker.getDefaultColor(), null, null)));
        ((JFXTextField)this.getEditor()).setFocusColor(this.jfxDatePicker.getDefaultColor());
    }

    @Override
    protected Node getPopupContent() {
        if (this.content == null) {
            this.content = new JFXDatePickerContent((JFXDatePicker)this.getSkinnable());
        }
        return this.content;
    }

    @Override
    protected TextField getEditor() {
        return ((DatePicker)this.getSkinnable()).getEditor();
    }

    @Override
    protected StringConverter<LocalDate> getConverter() {
        return ((DatePicker)this.getSkinnable()).getConverter();
    }

    @Override
    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.reflectGetEditableInputNode();
            this.displayNode.getStyleClass().add("date-picker-display-node");
            this.reflectUpdateDisplayNode();
        }
        this.displayNode.setEditable(this.jfxDatePicker.isEditable());
        return this.displayNode;
    }

    @Override
    public void show() {
        if (!this.jfxDatePicker.isOverLay()) {
            super.show();
        }
        if (this.content != null) {
            this.content.init();
            this.content.clearFocus();
        }
        if (this.dialog == null && this.jfxDatePicker.isOverLay()) {
            StackPane dialogParent = this.jfxDatePicker.getDialogParent();
            if (dialogParent == null) {
                dialogParent = (StackPane)this.jfxDatePicker.getScene().getRoot();
            }
            this.dialog = new JFXDialog(dialogParent, (Region)this.getPopupContent(), JFXDialog.DialogTransition.CENTER, true);
            this.arrowButton.setOnMouseClicked(click -> {
                if (this.jfxDatePicker.isOverLay()) {
                    StackPane parent = this.jfxDatePicker.getDialogParent();
                    if (parent == null) {
                        parent = (StackPane)this.jfxDatePicker.getScene().getRoot();
                    }
                    this.dialog.show(parent);
                }
            });
        }
    }
}

