/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDecorator;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.skins.JFXCustomColorPicker;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.transitions.JFXFillTransition;
import com.sun.javafx.util.Utils;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public class JFXCustomColorPickerDialog
extends StackPane {
    public static final String rgbFieldStyle = "-fx-background-color:TRANSPARENT;-fx-font-weight: BOLD;-fx-prompt-text-fill: #808080; -fx-alignment: top-left ; -fx-max-width: 300;";
    private final Stage dialog = new Stage();
    private final AtomicInteger concurrencyController = new AtomicInteger(-1);
    private ObjectProperty<Color> currentColorProperty = new SimpleObjectProperty<Color>(Color.WHITE);
    private ObjectProperty<Color> customColorProperty = new SimpleObjectProperty<Color>(Color.TRANSPARENT);
    private Runnable onSave;
    private Scene customScene;
    private JFXCustomColorPicker curvedColorPicker;
    private ParallelTransition paraTransition;
    private JFXDecorator pickerDecorator;
    private boolean systemChange = false;
    private boolean userChange = false;
    private boolean initOnce = true;
    private Runnable initRun;
    private InvalidationListener positionAdjuster = new InvalidationListener(){

        @Override
        public void invalidated(Observable ignored) {
            if (Double.isNaN(JFXCustomColorPickerDialog.this.dialog.getWidth()) || Double.isNaN(JFXCustomColorPickerDialog.this.dialog.getHeight())) {
                return;
            }
            JFXCustomColorPickerDialog.this.dialog.widthProperty().removeListener(JFXCustomColorPickerDialog.this.positionAdjuster);
            JFXCustomColorPickerDialog.this.dialog.heightProperty().removeListener(JFXCustomColorPickerDialog.this.positionAdjuster);
            JFXCustomColorPickerDialog.this.fixPosition();
        }
    };

    public JFXCustomColorPickerDialog(Window owner) {
        Scene ownerScene;
        this.getStyleClass().add("custom-color-dialog");
        if (owner != null) {
            this.dialog.initOwner(owner);
        }
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initStyle(StageStyle.TRANSPARENT);
        this.dialog.setResizable(false);
        this.pickerDecorator = new JFXDecorator(this.dialog, (Node)this, false, false, false);
        this.pickerDecorator.setOnCloseButtonAction(() -> this.updateColor());
        this.pickerDecorator.setPickOnBounds(false);
        this.customScene = new Scene(this.pickerDecorator, Color.TRANSPARENT);
        if (owner != null && (ownerScene = owner.getScene()) != null) {
            if (ownerScene.getUserAgentStylesheet() != null) {
                this.customScene.setUserAgentStylesheet(ownerScene.getUserAgentStylesheet());
            }
            this.customScene.getStylesheets().addAll((Collection<String>)ownerScene.getStylesheets());
        }
        this.curvedColorPicker = new JFXCustomColorPicker();
        StackPane pane = new StackPane(this.curvedColorPicker);
        pane.setPadding(new Insets(18.0));
        VBox container = new VBox();
        container.getChildren().add(pane);
        JFXTabPane tabs = new JFXTabPane();
        JFXTextField rgbField = new JFXTextField();
        JFXTextField hsbField = new JFXTextField();
        JFXTextField hexField = new JFXTextField();
        rgbField.setStyle(rgbFieldStyle);
        rgbField.setPromptText("RGB Color");
        rgbField.textProperty().addListener((o, oldVal, newVal) -> this.updateColorFromUserInput((String)newVal));
        hsbField.setStyle(rgbFieldStyle);
        hsbField.setPromptText("HSB Color");
        hsbField.textProperty().addListener((o, oldVal, newVal) -> this.updateColorFromUserInput((String)newVal));
        hexField.setStyle(rgbFieldStyle);
        hexField.setPromptText("#HEX Color");
        hexField.textProperty().addListener((o, oldVal, newVal) -> this.updateColorFromUserInput((String)newVal));
        StackPane tabContent = new StackPane();
        tabContent.getChildren().add(rgbField);
        tabContent.setMinHeight(100.0);
        Tab rgbTab = new Tab("RGB");
        rgbTab.setContent(tabContent);
        Tab hsbTab = new Tab("HSB");
        hsbTab.setContent(hsbField);
        Tab hexTab = new Tab("HEX");
        hexTab.setContent(hexField);
        tabs.getTabs().add(rgbTab);
        tabs.getTabs().add(hsbTab);
        tabs.getTabs().add(hexTab);
        this.curvedColorPicker.selectedPath.addListener((o, oldVal, newVal) -> {
            if (this.paraTransition != null) {
                this.paraTransition.stop();
            }
            Region tabsHeader = (Region)tabs.lookup(".tab-header-background");
            pane.backgroundProperty().unbind();
            tabsHeader.backgroundProperty().unbind();
            JFXFillTransition fillTransition = new JFXFillTransition(Duration.millis(240.0), pane, (Color)oldVal.getFill(), (Color)newVal.getFill());
            JFXFillTransition tabsFillTransition = new JFXFillTransition(Duration.millis(240.0), tabsHeader, (Color)oldVal.getFill(), (Color)newVal.getFill());
            this.paraTransition = new ParallelTransition(fillTransition, tabsFillTransition);
            this.paraTransition.setOnFinished(finish -> {
                tabsHeader.backgroundProperty().bind(Bindings.createObjectBinding(() -> new Background(new BackgroundFill(newVal.getFill(), CornerRadii.EMPTY, Insets.EMPTY)), newVal.fillProperty()));
                pane.backgroundProperty().bind(Bindings.createObjectBinding(() -> new Background(new BackgroundFill(newVal.getFill(), CornerRadii.EMPTY, Insets.EMPTY)), newVal.fillProperty()));
            });
            this.paraTransition.play();
        });
        this.initRun = () -> {
            pane.backgroundProperty().addListener((o, oldVal, newVal) -> {
                if (this.concurrencyController.getAndSet(1) == -1) {
                    Color fontColor = ((Color)newVal.getFills().get(0).getFill()).grayscale().getRed() > 0.5 ? Color.valueOf("rgba(40, 40, 40, 0.87)") : Color.valueOf("rgba(255, 255, 255, 0.87)");
                    for (Node tabNode : tabs.lookupAll(".tab")) {
                        for (Node node : tabNode.lookupAll(".tab-label")) {
                            ((Label)node).setTextFill(fontColor);
                        }
                        for (Node node : tabNode.lookupAll(".jfx-rippler")) {
                            ((JFXRippler)node).setRipplerFill(fontColor);
                        }
                    }
                    ((Pane)tabs.lookup(".tab-selected-line")).setBackground(new Background(new BackgroundFill(fontColor, CornerRadii.EMPTY, Insets.EMPTY)));
                    this.pickerDecorator.lookupAll(".jfx-decorator-button").forEach(button -> {
                        ((JFXButton)button).setRipplerFill(fontColor);
                        ((SVGGlyph)((JFXButton)button).getGraphic()).setFill(fontColor);
                    });
                    Color newColor = (Color)newVal.getFills().get(0).getFill();
                    String hex = String.format("#%02X%02X%02X", (int)(newColor.getRed() * 255.0), (int)(newColor.getGreen() * 255.0), (int)(newColor.getBlue() * 255.0));
                    String rgb = String.format("rgba(%d, %d, %d, 1)", (int)(newColor.getRed() * 255.0), (int)(newColor.getGreen() * 255.0), (int)(newColor.getBlue() * 255.0));
                    String hsb = String.format("hsl(%d, %d%%, %d%%)", (int)newColor.getHue(), (int)(newColor.getSaturation() * 100.0), (int)(newColor.getBrightness() * 100.0));
                    if (!this.userChange) {
                        this.systemChange = true;
                        rgbField.setText(rgb);
                        hsbField.setText(hsb);
                        hexField.setText(hex);
                        this.systemChange = false;
                    }
                    this.concurrencyController.getAndSet(-1);
                }
            });
            Platform.runLater(() -> {
                pane.setBackground(new Background(new BackgroundFill(this.curvedColorPicker.getColor(this.curvedColorPicker.getSelectedIndex()), CornerRadii.EMPTY, Insets.EMPTY)));
                ((Region)tabs.lookup(".tab-header-background")).setBackground(new Background(new BackgroundFill(this.curvedColorPicker.getColor(this.curvedColorPicker.getSelectedIndex()), CornerRadii.EMPTY, Insets.EMPTY)));
                Region tabsHeader = (Region)tabs.lookup(".tab-header-background");
                pane.backgroundProperty().unbind();
                tabsHeader.backgroundProperty().unbind();
                tabsHeader.backgroundProperty().bind(Bindings.createObjectBinding(() -> new Background(new BackgroundFill(((JFXCustomColorPicker.RecentColorPath)this.curvedColorPicker.selectedPath.get()).getFill(), CornerRadii.EMPTY, Insets.EMPTY)), ((JFXCustomColorPicker.RecentColorPath)this.curvedColorPicker.selectedPath.get()).fillProperty()));
                pane.backgroundProperty().bind(Bindings.createObjectBinding(() -> new Background(new BackgroundFill(((JFXCustomColorPicker.RecentColorPath)this.curvedColorPicker.selectedPath.get()).getFill(), CornerRadii.EMPTY, Insets.EMPTY)), ((JFXCustomColorPicker.RecentColorPath)this.curvedColorPicker.selectedPath.get()).fillProperty()));
                rgbField.focusColorProperty().bind(Bindings.createObjectBinding(() -> pane.getBackground().getFills().get(0).getFill(), pane.backgroundProperty()));
                hsbField.focusColorProperty().bind(Bindings.createObjectBinding(() -> pane.getBackground().getFills().get(0).getFill(), pane.backgroundProperty()));
                hexField.focusColorProperty().bind(Bindings.createObjectBinding(() -> pane.getBackground().getFills().get(0).getFill(), pane.backgroundProperty()));
                ((Pane)this.pickerDecorator.lookup(".jfx-decorator-buttons-container")).backgroundProperty().bind(Bindings.createObjectBinding(() -> new Background(new BackgroundFill(pane.getBackground().getFills().get(0).getFill(), CornerRadii.EMPTY, Insets.EMPTY)), pane.backgroundProperty()));
                ((Pane)this.pickerDecorator.lookup(".jfx-decorator-content-container")).borderProperty().bind(Bindings.createObjectBinding(() -> new Border(new BorderStroke(pane.getBackground().getFills().get(0).getFill(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(0.0, 4.0, 4.0, 4.0))), pane.backgroundProperty()));
            });
        };
        container.getChildren().add(tabs);
        this.getChildren().add(container);
        this.setPadding(new Insets(0.0));
        this.dialog.setScene(this.customScene);
        EventHandler<KeyEvent> keyEventListener = key -> {
            switch (key.getCode()) {
                case ESCAPE: {
                    this.close();
                    break;
                }
                case ENTER: {
                    this.updateColor();
                    break;
                }
            }
        };
        this.dialog.addEventHandler(KeyEvent.ANY, keyEventListener);
    }

    private void updateColor() {
        this.close();
        this.customColorProperty.set(this.curvedColorPicker.getColor(this.curvedColorPicker.getSelectedIndex()));
        this.onSave.run();
    }

    private void updateColorFromUserInput(String colorWebString) {
        if (!this.systemChange) {
            this.userChange = true;
            try {
                this.curvedColorPicker.setColor(Color.valueOf(colorWebString));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.userChange = false;
        }
    }

    private void close() {
        this.dialog.setScene(null);
        this.dialog.close();
    }

    public void setCurrentColor(Color currentColor) {
        this.currentColorProperty.set(currentColor);
    }

    Color getCurrentColor() {
        return (Color)this.currentColorProperty.get();
    }

    ObjectProperty<Color> customColorProperty() {
        return this.customColorProperty;
    }

    void setCustomColor(Color color) {
        this.customColorProperty.set(color);
    }

    Color getCustomColor() {
        return (Color)this.customColorProperty.get();
    }

    public Runnable getOnSave() {
        return this.onSave;
    }

    public void setOnSave(Runnable onSave) {
        this.onSave = onSave;
    }

    public void setOnHidden(EventHandler<WindowEvent> onHidden) {
        this.dialog.setOnHidden(onHidden);
    }

    public void show() {
        this.dialog.setOpacity(0.0);
        if (this.dialog.getOwner() != null) {
            this.dialog.widthProperty().addListener(this.positionAdjuster);
            this.dialog.heightProperty().addListener(this.positionAdjuster);
            this.positionAdjuster.invalidated(null);
        }
        if (this.dialog.getScene() == null) {
            this.dialog.setScene(this.customScene);
        }
        this.curvedColorPicker.preAnimate();
        this.dialog.show();
        if (this.initOnce) {
            this.initRun.run();
            this.initOnce = false;
        }
        Timeline timeline = new Timeline(new KeyFrame(Duration.millis(120.0), new KeyValue(this.dialog.opacityProperty(), 1, Interpolator.EASE_BOTH)));
        timeline.setOnFinished(finish -> this.curvedColorPicker.animate());
        timeline.play();
    }

    private void fixPosition() {
        Window w = this.dialog.getOwner();
        Screen s = Utils.getScreen(w);
        Rectangle2D sb = s.getBounds();
        double xR = w.getX() + w.getWidth();
        double xL = w.getX() - this.dialog.getWidth();
        double x = sb.getMaxX() >= xR + this.dialog.getWidth() ? xR : (sb.getMinX() <= xL ? xL : Math.max(sb.getMinX(), sb.getMaxX() - this.dialog.getWidth()));
        double y = Math.max(sb.getMinY(), Math.min(sb.getMaxY() - this.dialog.getHeight(), w.getY()));
        this.dialog.setX(x);
        this.dialog.setY(y);
    }

    @Override
    public void layoutChildren() {
        super.layoutChildren();
        if (this.dialog.getMinWidth() > 0.0 && this.dialog.getMinHeight() > 0.0) {
            return;
        }
        double minWidth = Math.max(0.0, this.computeMinWidth(this.getHeight()) + (this.dialog.getWidth() - this.customScene.getWidth()));
        double minHeight = Math.max(0.0, this.computeMinHeight(this.getWidth()) + (this.dialog.getHeight() - this.customScene.getHeight()));
        this.dialog.setMinWidth(minWidth);
        this.dialog.setMinHeight(minHeight);
    }
}

