/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.skins.JFXColorPickerUI;
import com.jfoenix.transitions.CachedTransition;
import java.util.ArrayList;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

class JFXCustomColorPicker
extends Pane {
    ObjectProperty<RecentColorPath> selectedPath = new SimpleObjectProperty<RecentColorPath>();
    private MoveTo startPoint;
    private CubicCurveTo curve0To;
    private CubicCurveTo outerCircleCurveTo;
    private CubicCurveTo curve1To;
    private CubicCurveTo innerCircleCurveTo;
    private ArrayList<CubicCurve> curves = new ArrayList();
    private double distance;
    private double centerX = this.distance = 200.0;
    private double centerY = this.distance;
    private double radius = 110.0;
    private int shapesNumber = 13;
    private ArrayList<RecentColorPath> shapes = new ArrayList();
    private CachedTransition showAnimation;
    private JFXColorPickerUI hslColorPicker;

    public JFXCustomColorPicker() {
        this.setPickOnBounds(false);
        this.setMinSize(this.distance * 2.0, this.distance * 2.0);
        SimpleDoubleProperty rotationAngle = new SimpleDoubleProperty(2.1);
        this.init(rotationAngle, this.centerX + 53.0, this.centerY + 162.0);
        this.hslColorPicker = new JFXColorPickerUI((int)this.distance);
        this.hslColorPicker.setLayoutX(this.centerX - this.distance / 2.0);
        this.hslColorPicker.setLayoutY(this.centerY - this.distance / 2.0);
        this.getChildren().add(this.hslColorPicker);
        int shapesStartIndex = this.getChildren().size();
        int shapesEndIndex = shapesStartIndex + this.shapesNumber;
        for (int i = 0; i < this.shapesNumber; ++i) {
            double angle = (double)(2 * i) * Math.PI / (double)this.shapesNumber;
            RecentColorPath path = new RecentColorPath(this.startPoint, this.curve0To, this.outerCircleCurveTo, this.curve1To, this.innerCircleCurveTo);
            this.shapes.add(path);
            path.setPickOnBounds(false);
            Rotate rotate = new Rotate(Math.toDegrees(angle), this.centerX, this.centerY);
            path.getTransforms().add(rotate);
            this.getChildren().add(shapesStartIndex, path);
            path.setFill(Color.valueOf(this.getDefaultColor(i)));
            path.setFocusTraversable(true);
            path.addEventHandler(MouseEvent.MOUSE_CLICKED, (? super T event) -> {
                path.requestFocus();
                this.selectedPath.set(path);
            });
        }
        this.selectedPath.addListener((o, oldVal, newVal) -> {
            if (oldVal != null) {
                this.hslColorPicker.removeColorSelectionNode((Node)oldVal);
                oldVal.playTransition(-1.0);
            }
            while (this.getChildren().indexOf(newVal) != shapesEndIndex - 1) {
                Node temp = (Node)this.getChildren().get(shapesEndIndex - 1);
                this.getChildren().remove(shapesEndIndex - 1);
                this.getChildren().add(shapesStartIndex, temp);
            }
            newVal.setStroke(Color.rgb(255, 255, 255, 0.87));
            newVal.playTransition(1.0);
            this.hslColorPicker.moveToColor((Color)newVal.getFill());
            this.hslColorPicker.addColorSelectionNode((Node)newVal);
        });
        this.selectedPath.set((RecentColorPath)this.getChildren().get(shapesStartIndex));
    }

    public int getShapesNumber() {
        return this.shapesNumber;
    }

    public int getSelectedIndex() {
        if (this.selectedPath.get() != null) {
            return this.shapes.indexOf(this.selectedPath.get());
        }
        return -1;
    }

    public void setColor(Color color) {
        this.shapes.get(this.getSelectedIndex()).setFill(color);
        this.hslColorPicker.moveToColor(color);
    }

    public Color getColor(int index) {
        if (index >= 0 && index < this.shapes.size()) {
            return (Color)this.shapes.get(index).getFill();
        }
        return Color.WHITE;
    }

    public void preAnimate() {
        CubicCurve firstCurve = this.curves.get(0);
        double x = firstCurve.getStartX();
        double y = firstCurve.getStartY();
        firstCurve.setStartX(this.centerX);
        firstCurve.setStartY(this.centerY);
        CubicCurve secondCurve = this.curves.get(1);
        double x1 = secondCurve.getStartX();
        double y1 = secondCurve.getStartY();
        secondCurve.setStartX(this.centerX);
        secondCurve.setStartY(this.centerY);
        double cx1 = firstCurve.getControlX1();
        double cy1 = firstCurve.getControlY1();
        firstCurve.setControlX1(this.centerX + this.radius);
        firstCurve.setControlY1(this.centerY + this.radius / 2.0);
        KeyFrame keyFrame = new KeyFrame(Duration.millis(1000.0), new KeyValue(firstCurve.startXProperty(), x, Interpolator.EASE_BOTH), new KeyValue(firstCurve.startYProperty(), y, Interpolator.EASE_BOTH), new KeyValue(secondCurve.startXProperty(), x1, Interpolator.EASE_BOTH), new KeyValue(secondCurve.startYProperty(), y1, Interpolator.EASE_BOTH), new KeyValue(firstCurve.controlX1Property(), cx1, Interpolator.EASE_BOTH), new KeyValue(firstCurve.controlY1Property(), cy1, Interpolator.EASE_BOTH));
        Timeline timeline = new Timeline(keyFrame);
        this.showAnimation = new CachedTransition(this, timeline){
            {
                this.setCycleDuration(Duration.millis(240.0));
                this.setDelay(Duration.millis(0.0));
            }
        };
    }

    public void animate() {
        this.showAnimation.play();
    }

    private void init(DoubleProperty rotationAngle, double initControlX1, double initControlY1) {
        Circle innerCircle = new Circle(this.centerX, this.centerY, this.radius, Color.TRANSPARENT);
        Circle outerCircle = new Circle(this.centerX, this.centerY, this.radius * 2.0, Color.web("blue", 0.5));
        this.createQuadraticCurve(rotationAngle, initControlX1, initControlY1);
        CubicCurve innerCircleCurve = new CubicCurve();
        innerCircleCurve.startXProperty().bind(this.curves.get(0).startXProperty());
        innerCircleCurve.startYProperty().bind(this.curves.get(0).startYProperty());
        innerCircleCurve.endXProperty().bind(this.curves.get(1).startXProperty());
        innerCircleCurve.endYProperty().bind(this.curves.get(1).startYProperty());
        this.curves.get(0).startXProperty().addListener((o, oldVal, newVal) -> {
            Point2D controlPoint = this.makeControlPoint(newVal.doubleValue(), this.curves.get(0).getStartY(), innerCircle, this.shapesNumber, -1);
            innerCircleCurve.setControlX1(controlPoint.getX());
            innerCircleCurve.setControlY1(controlPoint.getY());
        });
        this.curves.get(0).startYProperty().addListener((o, oldVal, newVal) -> {
            Point2D controlPoint = this.makeControlPoint(this.curves.get(0).getStartX(), newVal.doubleValue(), innerCircle, this.shapesNumber, -1);
            innerCircleCurve.setControlX1(controlPoint.getX());
            innerCircleCurve.setControlY1(controlPoint.getY());
        });
        this.curves.get(1).startXProperty().addListener((o, oldVal, newVal) -> {
            Point2D controlPoint = this.makeControlPoint(newVal.doubleValue(), this.curves.get(1).getStartY(), innerCircle, this.shapesNumber, 1);
            innerCircleCurve.setControlX2(controlPoint.getX());
            innerCircleCurve.setControlY2(controlPoint.getY());
        });
        this.curves.get(1).startYProperty().addListener((o, oldVal, newVal) -> {
            Point2D controlPoint = this.makeControlPoint(this.curves.get(1).getStartX(), newVal.doubleValue(), innerCircle, this.shapesNumber, 1);
            innerCircleCurve.setControlX2(controlPoint.getX());
            innerCircleCurve.setControlY2(controlPoint.getY());
        });
        Point2D controlPoint = this.makeControlPoint(this.curves.get(0).getStartX(), this.curves.get(0).getStartY(), innerCircle, this.shapesNumber, -1);
        innerCircleCurve.setControlX1(controlPoint.getX());
        innerCircleCurve.setControlY1(controlPoint.getY());
        controlPoint = this.makeControlPoint(this.curves.get(1).getStartX(), this.curves.get(1).getStartY(), innerCircle, this.shapesNumber, 1);
        innerCircleCurve.setControlX2(controlPoint.getX());
        innerCircleCurve.setControlY2(controlPoint.getY());
        CubicCurve outerCircleCurve = new CubicCurve();
        outerCircleCurve.startXProperty().bind(this.curves.get(0).endXProperty());
        outerCircleCurve.startYProperty().bind(this.curves.get(0).endYProperty());
        outerCircleCurve.endXProperty().bind(this.curves.get(1).endXProperty());
        outerCircleCurve.endYProperty().bind(this.curves.get(1).endYProperty());
        controlPoint = this.makeControlPoint(this.curves.get(0).getEndX(), this.curves.get(0).getEndY(), outerCircle, this.shapesNumber, -1);
        outerCircleCurve.setControlX1(controlPoint.getX());
        outerCircleCurve.setControlY1(controlPoint.getY());
        controlPoint = this.makeControlPoint(this.curves.get(1).getEndX(), this.curves.get(1).getEndY(), outerCircle, this.shapesNumber, 1);
        outerCircleCurve.setControlX2(controlPoint.getX());
        outerCircleCurve.setControlY2(controlPoint.getY());
        this.startPoint = new MoveTo();
        this.startPoint.xProperty().bind(this.curves.get(0).startXProperty());
        this.startPoint.yProperty().bind(this.curves.get(0).startYProperty());
        this.curve0To = new CubicCurveTo();
        this.curve0To.controlX1Property().bind(this.curves.get(0).controlX1Property());
        this.curve0To.controlY1Property().bind(this.curves.get(0).controlY1Property());
        this.curve0To.controlX2Property().bind(this.curves.get(0).controlX2Property());
        this.curve0To.controlY2Property().bind(this.curves.get(0).controlY2Property());
        this.curve0To.xProperty().bind(this.curves.get(0).endXProperty());
        this.curve0To.yProperty().bind(this.curves.get(0).endYProperty());
        this.outerCircleCurveTo = new CubicCurveTo();
        this.outerCircleCurveTo.controlX1Property().bind(outerCircleCurve.controlX1Property());
        this.outerCircleCurveTo.controlY1Property().bind(outerCircleCurve.controlY1Property());
        this.outerCircleCurveTo.controlX2Property().bind(outerCircleCurve.controlX2Property());
        this.outerCircleCurveTo.controlY2Property().bind(outerCircleCurve.controlY2Property());
        this.outerCircleCurveTo.xProperty().bind(outerCircleCurve.endXProperty());
        this.outerCircleCurveTo.yProperty().bind(outerCircleCurve.endYProperty());
        this.curve1To = new CubicCurveTo();
        this.curve1To.controlX1Property().bind(this.curves.get(1).controlX2Property());
        this.curve1To.controlY1Property().bind(this.curves.get(1).controlY2Property());
        this.curve1To.controlX2Property().bind(this.curves.get(1).controlX1Property());
        this.curve1To.controlY2Property().bind(this.curves.get(1).controlY1Property());
        this.curve1To.xProperty().bind(this.curves.get(1).startXProperty());
        this.curve1To.yProperty().bind(this.curves.get(1).startYProperty());
        this.innerCircleCurveTo = new CubicCurveTo();
        this.innerCircleCurveTo.controlX1Property().bind(innerCircleCurve.controlX2Property());
        this.innerCircleCurveTo.controlY1Property().bind(innerCircleCurve.controlY2Property());
        this.innerCircleCurveTo.controlX2Property().bind(innerCircleCurve.controlX1Property());
        this.innerCircleCurveTo.controlY2Property().bind(innerCircleCurve.controlY1Property());
        this.innerCircleCurveTo.xProperty().bind(innerCircleCurve.startXProperty());
        this.innerCircleCurveTo.yProperty().bind(innerCircleCurve.startYProperty());
    }

    private void createQuadraticCurve(DoubleProperty rotationAngle, double initControlX1, double initControlY1) {
        for (int i = 0; i < 2; ++i) {
            double angle = (double)(2 * i) * Math.PI / (double)this.shapesNumber;
            double xOffset = this.radius * Math.cos(angle);
            double yOffset = this.radius * Math.sin(angle);
            double startx = this.centerX + xOffset;
            double starty = this.centerY + yOffset;
            double diffStartCenterX = startx - this.centerX;
            double diffStartCenterY = starty - this.centerY;
            double sinRotAngle = Math.sin(rotationAngle.get());
            double cosRotAngle = Math.cos(rotationAngle.get());
            double startXR = cosRotAngle * diffStartCenterX - sinRotAngle * diffStartCenterY + this.centerX;
            double startYR = sinRotAngle * diffStartCenterX + cosRotAngle * diffStartCenterY + this.centerY;
            angle = (double)(2 * i) * Math.PI / (double)this.shapesNumber;
            xOffset = this.distance * Math.cos(angle);
            yOffset = this.distance * Math.sin(angle);
            double endx = this.centerX + xOffset;
            double endy = this.centerY + yOffset;
            CubicCurve curvedLine = new CubicCurve();
            curvedLine.setStartX(startXR);
            curvedLine.setStartY(startYR);
            curvedLine.setControlX1(startXR);
            curvedLine.setControlY1(startYR);
            curvedLine.setControlX2(endx);
            curvedLine.setControlY2(endy);
            curvedLine.setEndX(endx);
            curvedLine.setEndY(endy);
            curvedLine.setStroke(Color.FORESTGREEN);
            curvedLine.setStrokeWidth(1.0);
            curvedLine.setStrokeLineCap(StrokeLineCap.ROUND);
            curvedLine.setFill(Color.TRANSPARENT);
            curvedLine.setMouseTransparent(true);
            rotationAngle.addListener((o, oldVal, newVal) -> {
                double newstartXR = cosRotAngle * diffStartCenterX - sinRotAngle * diffStartCenterY + this.centerX;
                double newstartYR = sinRotAngle * diffStartCenterX + cosRotAngle * diffStartCenterY + this.centerY;
                curvedLine.setStartX(newstartXR);
                curvedLine.setStartY(newstartYR);
            });
            this.curves.add(curvedLine);
            if (i == 0) {
                curvedLine.setControlX1(initControlX1);
                curvedLine.setControlY1(initControlY1);
                continue;
            }
            CubicCurve firstCurve = this.curves.get(0);
            double curveTheta = (double)(2 * this.curves.indexOf(curvedLine)) * Math.PI / (double)this.shapesNumber;
            curvedLine.controlX1Property().bind(Bindings.createDoubleBinding(() -> {
                double a = firstCurve.getControlX1() - this.centerX;
                double b = Math.sin(curveTheta) * (firstCurve.getControlY1() - this.centerY);
                return Math.cos(curveTheta) * a - b + this.centerX;
            }, firstCurve.controlX1Property(), firstCurve.controlY1Property()));
            curvedLine.controlY1Property().bind(Bindings.createDoubleBinding(() -> {
                double a = Math.sin(curveTheta) * (firstCurve.getControlX1() - this.centerX);
                double b = Math.cos(curveTheta) * (firstCurve.getControlY1() - this.centerY);
                return a + b + this.centerY;
            }, firstCurve.controlX1Property(), firstCurve.controlY1Property()));
            curvedLine.controlX2Property().bind(Bindings.createDoubleBinding(() -> {
                double a = firstCurve.getControlX2() - this.centerX;
                double b = firstCurve.getControlY2() - this.centerY;
                return Math.cos(curveTheta) * a - Math.sin(curveTheta) * b + this.centerX;
            }, firstCurve.controlX2Property(), firstCurve.controlY2Property()));
            curvedLine.controlY2Property().bind(Bindings.createDoubleBinding(() -> {
                double a = Math.sin(curveTheta) * (firstCurve.getControlX2() - this.centerX);
                double b = Math.cos(curveTheta) * (firstCurve.getControlY2() - this.centerY);
                return a + b + this.centerY;
            }, firstCurve.controlX2Property(), firstCurve.controlY2Property()));
        }
    }

    private String getDefaultColor(int i) {
        String color = "#FFFFFF";
        switch (i) {
            case 0: {
                color = "#8F3F7E";
                break;
            }
            case 1: {
                color = "#B5305F";
                break;
            }
            case 2: {
                color = "#CE584A";
                break;
            }
            case 3: {
                color = "#DB8D5C";
                break;
            }
            case 4: {
                color = "#DA854E";
                break;
            }
            case 5: {
                color = "#E9AB44";
                break;
            }
            case 6: {
                color = "#FEE435";
                break;
            }
            case 7: {
                color = "#99C286";
                break;
            }
            case 8: {
                color = "#01A05E";
                break;
            }
            case 9: {
                color = "#4A8895";
                break;
            }
            case 10: {
                color = "#16669B";
                break;
            }
            case 11: {
                color = "#2F65A5";
                break;
            }
            case 12: {
                color = "#4E6A9C";
                break;
            }
        }
        return color;
    }

    private Point2D rotate(Point2D a, Point2D center, double angle) {
        double resultX = center.getX() + (a.getX() - center.getX()) * Math.cos(angle) - (a.getY() - center.getY()) * Math.sin(angle);
        double resultY = center.getY() + (a.getX() - center.getX()) * Math.sin(angle) + (a.getY() - center.getY()) * Math.cos(angle);
        return new Point2D(resultX, resultY);
    }

    private Point2D makeControlPoint(double endX, double endY, Circle circle, int numSegments, int direction) {
        double controlPointDistance = 1.3333333333333333 * Math.tan(Math.PI / (double)(2 * numSegments)) * circle.getRadius();
        Point2D center = new Point2D(circle.getCenterX(), circle.getCenterY());
        Point2D end = new Point2D(endX, endY);
        Point2D perp = this.rotate(center, end, (double)direction * Math.PI / 2.0);
        Point2D diff = perp.subtract(end);
        diff = diff.normalize();
        diff = this.scale(diff, controlPointDistance);
        return end.add(diff);
    }

    private Point2D scale(Point2D a, double scale) {
        return new Point2D(a.getX() * scale, a.getY() * scale);
    }

    private final class PathClickTransition
    extends CachedTransition {
        PathClickTransition(Path path) {
            super(JFXCustomColorPicker.this, new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(((DropShadow)path.getEffect()).radiusProperty(), JFXDepthManager.getShadowAt(2).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue(((DropShadow)path.getEffect()).spreadProperty(), JFXDepthManager.getShadowAt(2).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue(((DropShadow)path.getEffect()).offsetXProperty(), JFXDepthManager.getShadowAt(2).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue(((DropShadow)path.getEffect()).offsetYProperty(), JFXDepthManager.getShadowAt(2).offsetYProperty().get(), Interpolator.EASE_BOTH), new KeyValue(path.strokeWidthProperty(), 0, Interpolator.EASE_BOTH)), new KeyFrame(Duration.millis(1000.0), new KeyValue(((DropShadow)path.getEffect()).radiusProperty(), JFXDepthManager.getShadowAt(5).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue(((DropShadow)path.getEffect()).spreadProperty(), JFXDepthManager.getShadowAt(5).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue(((DropShadow)path.getEffect()).offsetXProperty(), JFXDepthManager.getShadowAt(5).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue(((DropShadow)path.getEffect()).offsetYProperty(), JFXDepthManager.getShadowAt(5).offsetYProperty().get(), Interpolator.EASE_BOTH), new KeyValue(path.strokeWidthProperty(), 2, Interpolator.EASE_BOTH))));
            this.setCycleDuration(Duration.millis(120.0));
            this.setDelay(Duration.seconds(0.0));
            this.setAutoReverse(false);
        }
    }

    final class RecentColorPath
    extends Path {
        PathClickTransition transition;

        RecentColorPath(PathElement ... elements) {
            super(elements);
            this.setStrokeLineCap(StrokeLineCap.ROUND);
            this.setStrokeWidth(0.0);
            this.setStrokeType(StrokeType.CENTERED);
            this.setCache(true);
            JFXDepthManager.setDepth(this, 2);
            this.transition = new PathClickTransition(this);
        }

        void playTransition(double rate) {
            this.transition.setRate(rate);
            this.transition.play();
        }
    }
}

