/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class JFXComboBoxListViewSkin<T>
extends ComboBoxListViewSkin<T> {
    private boolean invalid = true;
    private Text promptText;
    private ValidationPane<JFXComboBox> errorContainer;
    private PromptLinesWrapper<JFXComboBox> linesWrapper;
    protected final ObjectProperty<Paint> promptTextFill = new StyleableObjectProperty<Paint>((Paint)Color.GRAY){

        @Override
        public Object getBean() {
            return JFXComboBoxListViewSkin.this;
        }

        @Override
        public String getName() {
            return "promptTextFill";
        }

        @Override
        public CssMetaData<JFXComboBox, Paint> getCssMetaData() {
            return StyleableProperties.PROMPT_TEXT_FILL;
        }
    };

    public JFXComboBoxListViewSkin(JFXComboBox<T> comboBox) {
        super(comboBox);
        this.linesWrapper = new PromptLinesWrapper<JFXComboBox<JFXComboBox>>(comboBox, this.promptTextFill, comboBox.valueProperty(), comboBox.promptTextProperty(), () -> this.promptText);
        this.linesWrapper.init(() -> this.createPromptNode(), new Node[0]);
        Pane arrowButton = null;
        for (Node node : this.getChildren()) {
            if (!node.getId().equals("arrow-button")) continue;
            arrowButton = (Pane)node;
            break;
        }
        if (arrowButton != null) {
            this.linesWrapper.clip.widthProperty().bind(this.linesWrapper.promptContainer.widthProperty().subtract(arrowButton.widthProperty()));
        }
        this.errorContainer = new ValidationPane<JFXComboBox<JFXComboBox>>(comboBox);
        this.getChildren().addAll((Node[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        if (comboBox.isEditable()) {
            comboBox.getEditor().setStyle("-fx-background-color:TRANSPARENT;-fx-padding: 0.333333em 0em;");
            comboBox.getEditor().promptTextProperty().unbind();
            comboBox.getEditor().setPromptText(null);
            comboBox.getEditor().textProperty().addListener((o, oldVal, newVal) -> this.linesWrapper.usePromptText.invalidate());
        }
        this.registerChangeListener(comboBox.disableProperty(), obs -> this.linesWrapper.updateDisabled());
        this.registerChangeListener(comboBox.focusColorProperty(), obs -> this.linesWrapper.updateFocusColor());
        this.registerChangeListener(comboBox.unFocusColorProperty(), obs -> this.linesWrapper.updateUnfocusColor());
        this.registerChangeListener(comboBox.disableAnimationProperty(), obs -> this.errorContainer.updateClip());
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double height = ((ComboBoxBase)this.getSkinnable()).getHeight();
        this.linesWrapper.layoutLines(x, y, w, h, height, this.promptText == null ? 0.0 : this.snapPositionX(this.promptText.getBaselineOffset() + this.promptText.getLayoutBounds().getHeight() * 0.36));
        this.errorContainer.layoutPane(x, height + this.linesWrapper.focusedLine.getHeight(), w, h);
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            this.errorContainer.invalid(w);
            this.linesWrapper.invalid();
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.textProperty().bind(((ComboBoxBase)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind(this.linesWrapper.animatedPromptTextFill);
        this.promptText.getStyleClass().addAll((String[])new String[]{"text"});
        this.promptText.getTransforms().add(this.linesWrapper.promptTextScale);
        this.promptText.visibleProperty().bind(this.linesWrapper.usePromptText);
        this.promptText.setTranslateX(1.0);
        this.linesWrapper.promptContainer.getChildren().add(this.promptText);
        if (((ComboBoxBase)this.getSkinnable()).isFocused() && ((JFXComboBox)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-this.snapPositionY(this.promptText.getBaselineOffset() + this.promptText.getLayoutBounds().getHeight() * 0.36));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXComboBoxListViewSkin.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXComboBox, Paint> PROMPT_TEXT_FILL = new CssMetaData<JFXComboBox, Paint>("-fx-prompt-text-fill", PaintConverter.getInstance(), (Paint)Color.GRAY){

            @Override
            public boolean isSettable(JFXComboBox n) {
                JFXComboBoxListViewSkin skin = (JFXComboBoxListViewSkin)n.getSkin();
                return skin.promptTextFill == null || !skin.promptTextFill.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(JFXComboBox n) {
                JFXComboBoxListViewSkin skin = (JFXComboBoxListViewSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.promptTextFill);
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(ComboBoxListViewSkin.getClassCssMetaData());
            styleables.add(PROMPT_TEXT_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

