/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.transitions.CachedTransition;
import com.jfoenix.transitions.JFXFillTransition;
import com.jfoenix.utils.JFXNodeUtils;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.skin.CheckBoxSkin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class JFXCheckBoxSkin
extends CheckBoxSkin {
    private final StackPane box = new StackPane();
    private final StackPane mark = new StackPane();
    private final StackPane indeterminateMark = new StackPane();
    private final JFXRippler rippler;
    private Transition transition;
    private Transition indeterminateTransition;
    private boolean invalid = true;
    private JFXFillTransition select;
    private final StackPane boxContainer;

    public JFXCheckBoxSkin(JFXCheckBox control) {
        super(control);
        this.indeterminateMark.getStyleClass().setAll((String[])new String[]{"indeterminate-mark"});
        this.indeterminateMark.setOpacity(0.0);
        this.indeterminateMark.setScaleX(0.0);
        this.indeterminateMark.setScaleY(0.0);
        this.mark.getStyleClass().setAll((String[])new String[]{"mark"});
        this.mark.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.mark.setOpacity(0.0);
        this.mark.setScaleX(0.0);
        this.mark.setScaleY(0.0);
        this.box.getStyleClass().setAll((String[])new String[]{"box"});
        this.box.setBorder(new Border(new BorderStroke(control.getUnCheckedColor(), BorderStrokeStyle.SOLID, new CornerRadii(2.0), new BorderWidths(2.0))));
        this.box.getChildren().setAll((Node[])new Node[]{this.indeterminateMark, this.mark});
        this.boxContainer = new StackPane();
        this.boxContainer.getChildren().add(this.box);
        this.boxContainer.getStyleClass().add("box-container");
        this.rippler = new JFXRippler((Node)this.boxContainer, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
        this.updateRippleColor();
        control.selectedProperty().addListener(observable -> {
            this.updateRippleColor();
            this.playSelectAnimation(control.isSelected(), true);
        });
        control.indeterminateProperty().addListener(observable -> {
            this.updateRippleColor();
            this.playIndeterminateAnimation(control.isIndeterminate(), true);
        });
        control.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (!control.isDisableVisualFocus().booleanValue()) {
                if (newVal.booleanValue()) {
                    if (!((CheckBox)this.getSkinnable()).isPressed()) {
                        this.rippler.setOverlayVisible(true);
                    }
                } else {
                    this.rippler.setOverlayVisible(false);
                }
            }
        });
        control.pressedProperty().addListener((o, oldVal, newVal) -> this.rippler.setOverlayVisible(false));
        this.updateChildren();
        this.transition = new CheckBoxTransition(this.mark);
        this.indeterminateTransition = new CheckBoxTransition(this.indeterminateMark);
        this.createFillTransition();
        this.registerChangeListener(control.checkedColorProperty(), obs -> {
            this.select.stop();
            this.createFillTransition();
            this.updateColors();
        });
        this.registerChangeListener(control.unCheckedColorProperty(), obs -> this.updateColors());
    }

    private void updateRippleColor() {
        this.rippler.setRipplerFill(((CheckBox)this.getSkinnable()).isSelected() ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : ((JFXCheckBox)this.getSkinnable()).getUnCheckedColor());
    }

    private void updateColors() {
        Paint color = ((CheckBox)this.getSkinnable()).isSelected() ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : ((JFXCheckBox)this.getSkinnable()).getUnCheckedColor();
        JFXNodeUtils.updateBackground(this.indeterminateMark.getBackground(), this.indeterminateMark, ((JFXCheckBox)this.getSkinnable()).getCheckedColor());
        JFXNodeUtils.updateBackground(this.box.getBackground(), this.box, ((CheckBox)this.getSkinnable()).isSelected() ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : Color.TRANSPARENT);
        this.rippler.setRipplerFill(color);
        BorderStroke borderStroke = this.box.getBorder().getStrokes().get(0);
        this.box.setBorder(new Border(new BorderStroke(color, borderStroke.getTopStyle(), borderStroke.getRadii(), borderStroke.getWidths())));
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        this.getChildren().removeIf(node -> node.getStyleClass().contains("box"));
        if (this.rippler != null) {
            this.getChildren().add(this.rippler);
        }
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.minWidth(-1.0)) + this.getLabelOffset();
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.prefWidth(-1.0)) + this.getLabelOffset();
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(super.computeMinHeight(width - this.box.minWidth(-1.0), topInset, rightInset, bottomInset, leftInset), topInset + this.box.minHeight(-1.0) + bottomInset);
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(super.computePrefHeight(width - this.box.prefWidth(-1.0), topInset, rightInset, bottomInset, leftInset), topInset + this.box.prefHeight(-1.0) + bottomInset);
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double labelOffset = this.getLabelOffset();
        CheckBox checkBox = (CheckBox)this.getSkinnable();
        double boxWidth = this.snapSize(this.box.prefWidth(-1.0));
        double boxHeight = this.snapSize(this.box.prefHeight(-1.0));
        double computeWidth = Math.max(checkBox.prefWidth(-1.0), checkBox.minWidth(-1.0));
        double labelWidth = Math.min(computeWidth - boxWidth, w - this.snapSize(boxWidth)) + labelOffset;
        double labelHeight = Math.min(checkBox.prefHeight(labelWidth), h);
        double maxHeight = Math.max(boxHeight, labelHeight);
        double xOffset = JFXCheckBoxSkin.computeXOffset(w, labelWidth + boxWidth, checkBox.getAlignment().getHpos()) + x;
        double yOffset = JFXCheckBoxSkin.computeYOffset(h, maxHeight, checkBox.getAlignment().getVpos()) + x;
        if (this.invalid) {
            if (checkBox.isIndeterminate()) {
                this.playIndeterminateAnimation(true, false);
            } else if (checkBox.isSelected()) {
                this.playSelectAnimation(true, false);
            }
            this.invalid = false;
        }
        this.layoutLabelInArea(xOffset + boxWidth + labelOffset, yOffset, labelWidth, maxHeight, checkBox.getAlignment());
        this.rippler.resize(boxWidth, boxHeight);
        this.positionInArea(this.rippler, xOffset, yOffset, boxWidth, maxHeight, 0.0, checkBox.getAlignment().getHpos(), checkBox.getAlignment().getVpos());
    }

    private double getLabelOffset() {
        return 0.2 * this.boxContainer.snappedRightInset();
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        switch (vpos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        return 0.0;
    }

    private void playSelectAnimation(Boolean selection, boolean playAnimation) {
        if (selection == null) {
            selection = false;
        }
        this.transition.setRate(selection != false ? 1.0 : -1.0);
        this.select.setRate(selection != false ? 1.0 : -1.0);
        if (playAnimation) {
            this.transition.play();
            this.select.play();
        } else {
            Insets insets;
            CornerRadii radii = this.box.getBackground() == null ? null : this.box.getBackground().getFills().get(0).getRadii();
            Insets insets2 = insets = this.box.getBackground() == null ? null : this.box.getBackground().getFills().get(0).getInsets();
            if (selection.booleanValue()) {
                this.mark.setScaleY(1.0);
                this.mark.setScaleX(1.0);
                this.mark.setOpacity(1.0);
                this.box.setBackground(new Background(new BackgroundFill(((JFXCheckBox)this.getSkinnable()).getCheckedColor(), radii, insets)));
                this.select.playFrom(this.select.getCycleDuration());
                this.transition.playFrom(this.transition.getCycleDuration());
            } else {
                this.mark.setScaleY(0.0);
                this.mark.setScaleX(0.0);
                this.mark.setOpacity(0.0);
                this.box.setBackground(new Background(new BackgroundFill(Color.TRANSPARENT, radii, insets)));
                this.select.playFrom(Duration.ZERO);
                this.transition.playFrom(Duration.ZERO);
            }
        }
        this.box.setBorder(new Border(new BorderStroke(selection != false ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : ((JFXCheckBox)this.getSkinnable()).getUnCheckedColor(), BorderStrokeStyle.SOLID, new CornerRadii(2.0), new BorderWidths(2.0))));
    }

    private void playIndeterminateAnimation(Boolean indeterminate, boolean playAnimation) {
        if (indeterminate == null) {
            indeterminate = false;
        }
        this.indeterminateTransition.setRate(indeterminate != false ? 1.0 : -1.0);
        if (playAnimation) {
            this.indeterminateTransition.play();
        } else if (indeterminate.booleanValue()) {
            CornerRadii radii = this.indeterminateMark.getBackground() == null ? null : this.indeterminateMark.getBackground().getFills().get(0).getRadii();
            Insets insets = this.indeterminateMark.getBackground() == null ? null : this.indeterminateMark.getBackground().getFills().get(0).getInsets();
            this.indeterminateMark.setOpacity(1.0);
            this.indeterminateMark.setScaleY(1.0);
            this.indeterminateMark.setScaleX(1.0);
            this.indeterminateMark.setBackground(new Background(new BackgroundFill(((JFXCheckBox)this.getSkinnable()).getCheckedColor(), radii, insets)));
            this.indeterminateTransition.playFrom(this.indeterminateTransition.getCycleDuration());
        } else {
            this.indeterminateMark.setOpacity(0.0);
            this.indeterminateMark.setScaleY(0.0);
            this.indeterminateMark.setScaleX(0.0);
            this.indeterminateTransition.playFrom(Duration.ZERO);
        }
        if (((CheckBox)this.getSkinnable()).isSelected()) {
            this.playSelectAnimation(indeterminate == false, playAnimation);
        }
    }

    private void createFillTransition() {
        this.select = new JFXFillTransition(Duration.millis(120.0), this.box, Color.TRANSPARENT, (Color)((JFXCheckBox)this.getSkinnable()).getCheckedColor());
        this.select.setInterpolator(Interpolator.EASE_OUT);
    }

    private static final class CheckBoxTransition
    extends CachedTransition {
        protected Node mark;

        CheckBoxTransition(Node mark) {
            super(null, new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(mark.opacityProperty(), 0, Interpolator.EASE_OUT), new KeyValue(mark.scaleXProperty(), 0.5, Interpolator.EASE_OUT), new KeyValue(mark.scaleYProperty(), 0.5, Interpolator.EASE_OUT)), new KeyFrame(Duration.millis(400.0), new KeyValue(mark.opacityProperty(), 1, Interpolator.EASE_OUT), new KeyValue(mark.scaleXProperty(), 0.5, Interpolator.EASE_OUT), new KeyValue(mark.scaleYProperty(), 0.5, Interpolator.EASE_OUT)), new KeyFrame(Duration.millis(1000.0), new KeyValue(mark.scaleXProperty(), 1, Interpolator.EASE_OUT), new KeyValue(mark.scaleYProperty(), 1, Interpolator.EASE_OUT))));
            this.setCycleDuration(Duration.seconds(0.12));
            this.setDelay(Duration.seconds(0.05));
            this.mark = mark;
        }

        @Override
        protected void starting() {
            super.starting();
        }

        @Override
        protected void stopping() {
            super.stopping();
            this.mark.setOpacity(this.getRate() == 1.0 ? 1.0 : 0.0);
        }
    }
}

