/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.transitions.CachedTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.skin.CheckBoxSkin;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Line;
import javafx.util.Duration;

public class JFXCheckBoxOldSkin
extends CheckBoxSkin {
    private final StackPane box = new StackPane();
    private double lineThick = 2.0;
    private double padding = 10.0;
    private double boxWidth;
    private double maxHeight;
    private double boxHeight;
    private final JFXRippler rippler;
    private Line rightLine;
    private Line leftLine;
    private final AnchorPane container = new AnchorPane();
    private double labelOffset = 0.0;
    private Transition transition;
    private boolean invalid = true;

    public JFXCheckBoxOldSkin(JFXCheckBox control) {
        super(control);
        this.box.setMinSize(20.0, 20.0);
        this.box.setPrefSize(20.0, 20.0);
        this.box.setMaxSize(20.0, 20.0);
        this.box.setBorder(new Border(new BorderStroke(control.getUnCheckedColor(), BorderStrokeStyle.SOLID, new CornerRadii(0.0), new BorderWidths(this.lineThick))));
        StackPane boxContainer = new StackPane();
        boxContainer.getChildren().add(this.box);
        boxContainer.setPadding(new Insets(this.padding));
        this.rippler = new JFXRippler((Node)boxContainer, JFXRippler.RipplerMask.CIRCLE);
        this.rippler.setRipplerFill(((CheckBox)this.getSkinnable()).isSelected() ? control.getUnCheckedColor() : control.getCheckedColor());
        this.rightLine = new Line();
        this.leftLine = new Line();
        this.rightLine.setStroke(control.getCheckedColor());
        this.rightLine.setStrokeWidth(this.lineThick);
        this.leftLine.setStroke(control.getCheckedColor());
        this.leftLine.setStrokeWidth(this.lineThick);
        this.rightLine.setVisible(false);
        this.leftLine.setVisible(false);
        this.container.getChildren().add(this.rightLine);
        this.container.getChildren().add(this.leftLine);
        this.container.getChildren().add(this.rippler);
        AnchorPane.setRightAnchor(this.rippler, this.labelOffset);
        ((CheckBox)this.getSkinnable()).selectedProperty().addListener((o, oldVal, newVal) -> {
            this.rippler.setRipplerFill(newVal != false ? control.getUnCheckedColor() : control.getCheckedColor());
            this.transition.setRate(newVal != false ? 1.0 : -1.0);
            this.transition.play();
        });
        this.updateChildren();
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        if (this.container != null) {
            this.getChildren().remove(1);
            this.getChildren().add(this.container);
        }
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.prefWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        CheckBox checkBox = (CheckBox)this.getSkinnable();
        this.boxWidth = this.snapSize(this.container.prefWidth(-1.0));
        this.boxHeight = this.snapSize(this.container.prefHeight(-1.0));
        double computeWidth = Math.max(checkBox.prefWidth(-1.0), checkBox.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
        double labelWidth = Math.min(computeWidth - this.boxWidth, w - this.snapSize(this.boxWidth)) + this.labelOffset + 2.0 * this.padding;
        double labelHeight = Math.min(checkBox.prefHeight(labelWidth), h);
        this.maxHeight = Math.max(this.boxHeight, labelHeight);
        double xOffset = JFXCheckBoxOldSkin.computeXOffset(w, labelWidth + this.boxWidth, checkBox.getAlignment().getHpos()) + x;
        double yOffset = JFXCheckBoxOldSkin.computeYOffset(h, this.maxHeight, checkBox.getAlignment().getVpos()) + x;
        if (this.invalid) {
            this.rightLine.setStartX((this.boxWidth + this.padding - this.labelOffset) / 2.0 - this.boxWidth / 5.5);
            this.rightLine.setStartY(this.maxHeight - this.padding - this.lineThick);
            this.rightLine.setEndX((this.boxWidth + this.padding - this.labelOffset) / 2.0 - this.boxWidth / 5.5);
            this.rightLine.setEndY(this.maxHeight - this.padding - this.lineThick);
            this.leftLine.setStartX((this.boxWidth + this.padding - this.labelOffset) / 2.0 - this.boxWidth / 5.5);
            this.leftLine.setStartY(this.maxHeight - this.padding - this.lineThick);
            this.leftLine.setEndX((this.boxWidth + this.padding - this.labelOffset) / 2.0 - this.boxWidth / 5.5);
            this.leftLine.setEndY(this.maxHeight - this.padding - this.lineThick);
            this.transition = new CheckBoxTransition();
            if (((CheckBox)this.getSkinnable()).isSelected()) {
                this.transition.play();
            }
            this.invalid = false;
        }
        this.layoutLabelInArea(xOffset + this.boxWidth, yOffset, labelWidth, this.maxHeight, checkBox.getAlignment());
        this.container.resize(this.boxWidth, this.boxHeight);
        this.positionInArea(this.container, xOffset, yOffset, this.boxWidth, this.maxHeight, 0.0, checkBox.getAlignment().getHpos(), checkBox.getAlignment().getVpos());
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        switch (vpos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        return 0.0;
    }

    private class CheckBoxTransition
    extends CachedTransition {
        public CheckBoxTransition() {
            super(JFXCheckBoxOldSkin.this.box, new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(JFXCheckBoxOldSkin.this.rightLine.visibleProperty(), false, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.leftLine.visibleProperty(), false, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.rotateProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.scaleXProperty(), 1, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.scaleYProperty(), 1, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.translateYProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.translateXProperty(), 0, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.opacityProperty(), 1, Interpolator.EASE_BOTH)), new KeyFrame(Duration.millis(400.0), new KeyValue(JFXCheckBoxOldSkin.this.rightLine.visibleProperty(), true, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.leftLine.visibleProperty(), true, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.rightLine.endXProperty(), (JFXCheckBoxOldSkin.this.boxWidth + JFXCheckBoxOldSkin.this.padding - JFXCheckBoxOldSkin.this.labelOffset) / 2.0 - JFXCheckBoxOldSkin.this.boxWidth / 5.5, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.rightLine.endYProperty(), JFXCheckBoxOldSkin.this.maxHeight - JFXCheckBoxOldSkin.this.padding - 2.0 * JFXCheckBoxOldSkin.this.lineThick, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.leftLine.endXProperty(), (JFXCheckBoxOldSkin.this.boxWidth + JFXCheckBoxOldSkin.this.padding - JFXCheckBoxOldSkin.this.labelOffset) / 2.0 - JFXCheckBoxOldSkin.this.boxWidth / 5.5, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.leftLine.endYProperty(), JFXCheckBoxOldSkin.this.maxHeight - JFXCheckBoxOldSkin.this.padding - 2.0 * JFXCheckBoxOldSkin.this.lineThick, Interpolator.EASE_BOTH)), new KeyFrame(Duration.millis(500.0), new KeyValue(JFXCheckBoxOldSkin.this.box.rotateProperty(), 44, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.scaleXProperty(), 0.3, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.scaleYProperty(), 0.4, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.translateYProperty(), JFXCheckBoxOldSkin.this.boxHeight / 12.0, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.box.translateXProperty(), -JFXCheckBoxOldSkin.this.boxWidth / 12.0, Interpolator.EASE_BOTH)), new KeyFrame(Duration.millis(700.0), new KeyValue(JFXCheckBoxOldSkin.this.box.opacityProperty(), 0, Interpolator.EASE_BOTH)), new KeyFrame(Duration.millis(800.0), new KeyValue(JFXCheckBoxOldSkin.this.rightLine.endXProperty(), JFXCheckBoxOldSkin.this.boxWidth - JFXCheckBoxOldSkin.this.padding - JFXCheckBoxOldSkin.this.labelOffset + JFXCheckBoxOldSkin.this.lineThick / 2.0, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.rightLine.endYProperty(), (JFXCheckBoxOldSkin.this.maxHeight - JFXCheckBoxOldSkin.this.padding) / 2.4, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.leftLine.endXProperty(), JFXCheckBoxOldSkin.this.padding + JFXCheckBoxOldSkin.this.lineThick / 4.0, Interpolator.EASE_BOTH), new KeyValue(JFXCheckBoxOldSkin.this.leftLine.endYProperty(), (JFXCheckBoxOldSkin.this.maxHeight - JFXCheckBoxOldSkin.this.padding) / 1.4, Interpolator.EASE_BOTH))));
            this.setCycleDuration(Duration.seconds(0.4));
            this.setDelay(Duration.seconds(0.0));
        }
    }
}

