/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CachedTransition;
import com.jfoenix.utils.JFXNodeUtils;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.skin.ButtonSkin;
import javafx.scene.effect.DropShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXButtonSkin
extends ButtonSkin {
    private Transition clickedAnimation;
    private JFXRippler buttonRippler = new JFXRippler((Node)((Object)this.getSkinnable())){

        @Override
        protected Node getMask() {
            StackPane mask = new StackPane();
            mask.shapeProperty().bind(((Button)JFXButtonSkin.this.getSkinnable()).shapeProperty());
            JFXNodeUtils.updateBackground(((Button)JFXButtonSkin.this.getSkinnable()).getBackground(), mask);
            mask.resize(this.getWidth() - this.snappedRightInset() - this.snappedLeftInset(), this.getHeight() - this.snappedBottomInset() - this.snappedTopInset());
            return mask;
        }

        @Override
        protected void positionControl(Node control) {
        }
    };
    private Runnable releaseManualRippler = null;
    private boolean invalid = true;
    private boolean mousePressed = false;

    public JFXButtonSkin(JFXButton button) {
        super(button);
        button.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> this.playClickAnimation(1.0));
        button.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            this.mousePressed = true;
        });
        button.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> {
            this.mousePressed = false;
        });
        button.addEventFilter(MouseEvent.MOUSE_DRAGGED, e -> {
            this.mousePressed = false;
        });
        button.ripplerFillProperty().addListener((o, oldVal, newVal) -> this.buttonRippler.setRipplerFill((Paint)newVal));
        button.armedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                if (!this.mousePressed) {
                    this.releaseManualRippler = this.buttonRippler.createManualRipple();
                    this.playClickAnimation(1.0);
                }
            } else {
                if (this.releaseManualRippler != null) {
                    this.releaseManualRippler.run();
                    this.releaseManualRippler = null;
                }
                this.playClickAnimation(-1.0);
            }
        });
        button.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (!button.disableVisualFocusProperty().get()) {
                if (newVal.booleanValue()) {
                    if (!((Button)this.getSkinnable()).isPressed()) {
                        this.buttonRippler.setOverlayVisible(true);
                    }
                } else {
                    this.buttonRippler.setOverlayVisible(false);
                }
            }
        });
        button.buttonTypeProperty().addListener((o, oldVal, newVal) -> this.updateButtonType((JFXButton.ButtonType)((Object)newVal)));
        this.updateButtonType(button.getButtonType());
        this.updateChildren();
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        if (this.buttonRippler != null) {
            this.getChildren().add(0, this.buttonRippler);
        }
        for (int i = 1; i < this.getChildren().size(); ++i) {
            Node child = (Node)this.getChildren().get(i);
            if (!(child instanceof Text)) continue;
            child.setMouseTransparent(true);
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.invalid) {
            if (((JFXButton)this.getSkinnable()).getRipplerFill() == null) {
                for (int i = this.getChildren().size() - 1; i >= 1; --i) {
                    if (this.getChildren().get(i) instanceof Text) {
                        this.buttonRippler.setRipplerFill(((Text)this.getChildren().get(i)).getFill());
                        ((Text)this.getChildren().get(i)).fillProperty().addListener((o, oldVal, newVal) -> this.buttonRippler.setRipplerFill((Paint)newVal));
                    } else {
                        if (!(this.getChildren().get(i) instanceof Label)) continue;
                        this.buttonRippler.setRipplerFill(((Label)this.getChildren().get(i)).getTextFill());
                        ((Label)this.getChildren().get(i)).textFillProperty().addListener((o, oldVal, newVal) -> this.buttonRippler.setRipplerFill((Paint)newVal));
                    }
                    break;
                }
            } else {
                this.buttonRippler.setRipplerFill(((JFXButton)this.getSkinnable()).getRipplerFill());
            }
            this.invalid = false;
        }
        this.buttonRippler.resizeRelocate(((Button)this.getSkinnable()).getLayoutBounds().getMinX(), ((Button)this.getSkinnable()).getLayoutBounds().getMinY(), ((Button)this.getSkinnable()).getWidth(), ((Button)this.getSkinnable()).getHeight());
        this.layoutLabelInArea(x, y, w, h);
    }

    private void updateButtonType(JFXButton.ButtonType type) {
        switch (type) {
            case RAISED: {
                JFXDepthManager.setDepth((Node)((Object)this.getSkinnable()), 2);
                this.clickedAnimation = new ButtonClickTransition((Node)((Object)this.getSkinnable()), (DropShadow)((Button)this.getSkinnable()).getEffect());
                ((Button)this.getSkinnable()).setPickOnBounds(false);
                break;
            }
            default: {
                ((Button)this.getSkinnable()).setEffect(null);
                ((Button)this.getSkinnable()).setPickOnBounds(true);
            }
        }
    }

    private void playClickAnimation(double rate) {
        if (!(this.clickedAnimation == null || this.clickedAnimation.getCurrentTime().equals(this.clickedAnimation.getCycleDuration()) && rate == 1.0)) {
            this.clickedAnimation.setRate(rate);
            this.clickedAnimation.play();
        }
    }

    private static class ButtonClickTransition
    extends CachedTransition {
        ButtonClickTransition(Node node, DropShadow shadowEffect) {
            super(node, new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(shadowEffect.radiusProperty(), JFXDepthManager.getShadowAt(2).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue(shadowEffect.spreadProperty(), JFXDepthManager.getShadowAt(2).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue(shadowEffect.offsetXProperty(), JFXDepthManager.getShadowAt(2).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue(shadowEffect.offsetYProperty(), JFXDepthManager.getShadowAt(2).offsetYProperty().get(), Interpolator.EASE_BOTH)), new KeyFrame(Duration.millis(1000.0), new KeyValue(shadowEffect.radiusProperty(), JFXDepthManager.getShadowAt(5).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue(shadowEffect.spreadProperty(), JFXDepthManager.getShadowAt(5).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue(shadowEffect.offsetXProperty(), JFXDepthManager.getShadowAt(5).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue(shadowEffect.offsetYProperty(), JFXDepthManager.getShadowAt(5).offsetYProperty().get(), Interpolator.EASE_BOTH))));
            this.setCycleDuration(Duration.seconds(0.2));
            this.setDelay(Duration.seconds(0.0));
        }
    }
}

