/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.pannable.gestures;

import com.jfoenix.controls.pannable.base.IPannablePane;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class PanningGestures<T extends Node> {
    private T canvas;
    private final DragContext sceneDragContext = new DragContext();
    private final DoubleProperty minScaleProperty = new SimpleDoubleProperty(0.1);
    private final DoubleProperty maxScaleProperty = new SimpleDoubleProperty(10.0);
    private final DoubleProperty zoomSpeedProperty = new SimpleDoubleProperty(1.2);
    private SimpleBooleanProperty useViewportGestures = null;
    private boolean bound = false;
    private final EventHandler<MouseEvent> onMousePressedEventHandler = event -> {
        if (!event.isSecondaryButtonDown()) {
            return;
        }
        this.sceneDragContext.mouseAnchorX = event.getSceneX();
        this.sceneDragContext.mouseAnchorY = event.getSceneY();
        this.sceneDragContext.translateAnchorX = ((Node)this.canvas).getTranslateX();
        this.sceneDragContext.translateAnchorY = ((Node)this.canvas).getTranslateY();
    };
    private final EventHandler<MouseEvent> onMouseDraggedEventHandler = event -> {
        if (!event.isSecondaryButtonDown()) {
            return;
        }
        Bounds parentLayoutBounds = ((Node)this.canvas).getParent().getLayoutBounds();
        Bounds boundsInParent = ((Node)this.canvas).getBoundsInParent();
        double newTransX = this.sceneDragContext.translateAnchorX + event.getSceneX() - this.sceneDragContext.mouseAnchorX;
        ((Node)this.canvas).setTranslateX(this.bound(newTransX, parentLayoutBounds.getWidth(), boundsInParent.getWidth()));
        double newTransY = this.sceneDragContext.translateAnchorY + event.getSceneY() - this.sceneDragContext.mouseAnchorY;
        ((Node)this.canvas).setTranslateY(this.bound(newTransY, parentLayoutBounds.getHeight(), boundsInParent.getHeight()));
        event.consume();
    };
    private final EventHandler<ScrollEvent> onScrollEventHandler = event -> {
        double scale = ((IPannablePane)this.canvas).getScale();
        scale = event.getDeltaY() < 0.0 ? (scale /= this.getZoomSpeed()) : (scale *= this.getZoomSpeed());
        scale = PanningGestures.clamp(scale, this.minScaleProperty.get(), this.maxScaleProperty.get());
        Point2D currentPoint = ((Node)this.canvas).parentToLocal(event.getX(), event.getY());
        ((IPannablePane)this.canvas).setScale(scale);
        Point2D newPoint = ((Node)this.canvas).localToParent(currentPoint);
        Bounds parentLayoutBounds = ((Node)this.canvas).getParent().getLayoutBounds();
        Bounds boundsInParent = ((Node)this.canvas).getBoundsInParent();
        double lowerBound = parentLayoutBounds.getWidth() - boundsInParent.getWidth() - 20.0;
        ((Node)this.canvas).setTranslateX(this.bound(((Node)this.canvas).getTranslateX() - (newPoint.getX() - event.getX()), parentLayoutBounds.getWidth(), boundsInParent.getWidth()));
        ((Node)this.canvas).setTranslateY(this.bound(((Node)this.canvas).getTranslateY() - (newPoint.getY() - event.getY()), parentLayoutBounds.getHeight(), boundsInParent.getHeight()));
        event.consume();
    };

    public PanningGestures(T canvas) {
        this.canvas = canvas;
    }

    public double getMinScale() {
        return this.minScaleProperty.get();
    }

    public void setMinScale(double minScale) {
        this.minScaleProperty.set(minScale);
    }

    public DoubleProperty minScaleProperty() {
        return this.minScaleProperty;
    }

    public double getMaxScale() {
        return this.maxScaleProperty.get();
    }

    public DoubleProperty maxScaleProperty() {
        return this.maxScaleProperty;
    }

    public void setMaxScale(double maxScale) {
        this.maxScaleProperty.set(maxScale);
    }

    public double getZoomSpeed() {
        return this.zoomSpeedProperty.get();
    }

    public DoubleProperty zoomSpeedProperty() {
        return this.zoomSpeedProperty;
    }

    public void setZoomSpeed(double zoomSpeed) {
        this.zoomSpeedProperty.set(zoomSpeed);
    }

    public final BooleanProperty useViewPortGesturesProperty() {
        return this.useViewportGestures;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    private double bound(double newTrans, double parentSize, double canvasSize) {
        if (!this.bound) {
            return newTrans;
        }
        double lowerBound = parentSize - canvasSize - 20.0 * ((IPannablePane)this.canvas).getScale();
        newTrans = parentSize > canvasSize ? 1.0 : this.inBound(lowerBound, 1.0, newTrans);
        return newTrans;
    }

    private double inBound(double lowerBound, double upperBound, double val) {
        if (val < lowerBound) {
            val = lowerBound;
        } else if (val > upperBound) {
            val = upperBound;
        }
        return val;
    }

    public static double clamp(double value, double min, double max) {
        if (Double.compare(value, min) < 0) {
            return min;
        }
        if (Double.compare(value, max) > 0) {
            return max;
        }
        return value;
    }

    public static <T extends Node> PanningGestures<T> attachViewPortGestures(T pannableCanvas) {
        return PanningGestures.attachViewPortGestures(pannableCanvas, false);
    }

    public static <T extends Node> PanningGestures<T> attachViewPortGestures(T pannableCanvas, boolean configurable) {
        PanningGestures<T> panningGestures = new PanningGestures<T>(pannableCanvas);
        if (configurable) {
            panningGestures.useViewportGestures = new SimpleBooleanProperty(true);
            panningGestures.useViewportGestures.addListener((ChangeListener<? super Boolean>)((ChangeListener<Boolean>)(o, oldVal, newVal) -> {
                Parent parent = (Parent)pannableCanvas.parentProperty().get();
                if (parent == null) {
                    return;
                }
                if (newVal.booleanValue()) {
                    parent.addEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
                    parent.addEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
                    parent.addEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
                } else {
                    parent.removeEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
                    parent.removeEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
                    parent.removeEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
                }
            }));
        }
        pannableCanvas.parentProperty().addListener((o, oldVal, newVal) -> {
            if (oldVal != null) {
                oldVal.removeEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
                oldVal.removeEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
                oldVal.removeEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
            }
            if (newVal != null) {
                newVal.addEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
                newVal.addEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
                newVal.addEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
            }
        });
        return panningGestures;
    }

    private static class DragContext {
        double mouseAnchorX;
        double mouseAnchorY;
        double translateAnchorX;
        double translateAnchorY;

        private DragContext() {
        }
    }
}

