/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.controls.cells.editors.base.GenericEditableTableCell;
import java.util.function.Consumer;
import javafx.scene.input.MouseEvent;

public class OnPressedEditableTableCell<S, T>
extends GenericEditableTableCell<S, T> {
    public OnPressedEditableTableCell() {
        this.init();
    }

    public OnPressedEditableTableCell(EditorNodeBuilder builder) {
        super(builder);
        this.init();
    }

    public OnPressedEditableTableCell(EditorNodeBuilder builder, Consumer<Exception> exConsumer) {
        super(builder, exConsumer);
        this.init();
    }

    private void init() {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, (? super T click) -> {
            OnPressedEditableTableCell editingCell;
            if (this.getTableView().getEditingCell() != null && !this.isEditing() && (editingCell = (OnPressedEditableTableCell)this.getTableView().getProperties().remove(OnPressedEditableTableCell.class)) != null) {
                editingCell.commitHelper(true);
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, (? super T click) -> {
            if (!this.isEmpty() && this.isEditable() && !this.isEditing() && this.getTableColumn().isEditable()) {
                this.getTableView().edit(this.getIndex(), this.getTableColumn());
            }
        });
    }

    @Override
    public void startEdit() {
        super.startEdit();
        if (this.isEditing()) {
            this.getTableView().getProperties().put(OnPressedEditableTableCell.class, this);
        }
    }

    @Override
    public void commitEdit(T newValue) {
        super.commitEdit(newValue);
        this.getTableView().getProperties().remove(OnPressedEditableTableCell.class);
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.getTableView().getProperties().remove(OnPressedEditableTableCell.class);
    }
}

