/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.cells.editors.TextFieldEditorBuilder;
import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.controls.cells.editors.base.JFXTreeTableCell;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;

public class GenericEditableTreeTableCell<S, T>
extends JFXTreeTableCell<S, T> {
    protected EditorNodeBuilder builder;
    protected Region editorNode;
    protected Consumer<Exception> commitExceptionConsumer = null;
    private BiFunction<Integer, Integer, Integer> stepFunction = (index, direction) -> 0;

    public GenericEditableTreeTableCell() {
        this(new TextFieldEditorBuilder());
    }

    public GenericEditableTreeTableCell(EditorNodeBuilder builder) {
        this(builder, null);
    }

    public GenericEditableTreeTableCell(EditorNodeBuilder builder, Consumer<Exception> exConsumer) {
        this.builder = builder;
        this.commitExceptionConsumer = exConsumer;
    }

    protected void commitHelper(boolean losingFocus) {
        block4: {
            if (this.editorNode == null) {
                return;
            }
            try {
                this.builder.validateValue();
                this.commitEdit(this.builder.getValue());
                this.builder.nullEditorNode();
                this.editorNode = null;
            }
            catch (Exception ex) {
                if (this.commitExceptionConsumer != null) {
                    this.commitExceptionConsumer.accept(ex);
                }
                if (!losingFocus) break block4;
                this.cancelEdit();
            }
        }
    }

    protected Object getValue() {
        return this.getItem();
    }

    @Override
    public void startEdit() {
        if (this.isEditable() && this.checkGroupedColumn()) {
            super.startEdit();
            if (this.editorNode == null) {
                this.createEditorNode();
            } else {
                this.builder.setValue(this.getValue());
            }
            this.builder.startEdit();
            this.setGraphic(this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }

    @Override
    public void cancelEdit() {
        this.editorNode = null;
        super.cancelEdit();
        this.builder.cancelEdit();
        this.builder.setValue(this.getValue());
        this.builder.nullEditorNode();
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    private boolean checkGroupedColumn() {
        boolean allowEdit = true;
        if (this.getTreeTableRow().getTreeItem() != null) {
            Object rowObject = this.getTreeTableRow().getTreeItem().getValue();
            if (rowObject instanceof RecursiveTreeObject && rowObject.getClass() == RecursiveTreeObject.class) {
                allowEdit = false;
            } else if (this.getTableColumn() instanceof JFXTreeTableColumn && ((JFXTreeTableColumn)this.getTableColumn()).isGrouped() && this.getTreeTableRow().getTreeItem().getParent() != null && this.getTreeTableRow().getTreeItem().getParent().getValue().getClass() == RecursiveTreeObject.class) {
                allowEdit = false;
            }
        }
        return allowEdit;
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing() && this.checkGroupedColumn()) {
            if (this.editorNode != null) {
                this.builder.setValue(this.getValue());
            }
            this.setGraphic(this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.builder.updateItem(item, empty);
        } else {
            Object value = this.getValue();
            if (value instanceof Node) {
                this.setGraphic((Node)value);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(value == null ? null : String.valueOf(value));
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createEditorNode() {
        EventHandler<KeyEvent> keyEventsHandler = t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.commitHelper(false);
            } else if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
            } else if (t.getCode() == KeyCode.TAB) {
                this.commitHelper(false);
                this.editNext(!t.isShiftDown());
            }
        };
        ChangeListener<Boolean> focusChangeListener = (observable, oldValue, newValue) -> {
            if (this.editorNode != null && !newValue.booleanValue()) {
                this.commitHelper(true);
            }
        };
        this.editorNode = this.builder.createNode(this.getValue(), keyEventsHandler, focusChangeListener);
    }

    public BiFunction<Integer, Integer, Integer> getStepFunction() {
        return this.stepFunction;
    }

    public void setStepFunction(BiFunction<Integer, Integer, Integer> stepFunction) {
        this.stepFunction = stepFunction;
    }

    /*
     * WARNING - void declaration
     */
    private void editNext(boolean forward) {
        void var4_11;
        void var4_9;
        ArrayList columns = new ArrayList();
        for (TreeTableColumn treeTableColumn : this.getTreeTableView().getColumns()) {
            columns.addAll(this.getLeaves(treeTableColumn));
        }
        int index = this.getIndex();
        int n = columns.indexOf(this.getTableColumn());
        if (forward) {
            void var4_7;
            if (++var4_7 > columns.size() - 1) {
                boolean bl = false;
                index += this.stepFunction.apply(index, 1).intValue();
            }
        } else if (--var4_9 < 0) {
            int n2 = columns.size() - 1;
            index += this.stepFunction.apply(index, -1).intValue();
        }
        if (columns.size() < 2 && index == this.getIndex()) {
            return;
        }
        TreeTableColumn nextColumn = (TreeTableColumn)columns.get((int)var4_11);
        if (nextColumn != null) {
            this.getTreeTableView().edit(index, nextColumn);
            this.getTreeTableView().scrollToColumn(nextColumn);
        }
    }

    private List<TreeTableColumn<S, ?>> getLeaves(TreeTableColumn<S, ?> root) {
        ArrayList columns = new ArrayList();
        if (root.getColumns().isEmpty()) {
            if (root.isEditable()) {
                columns.add(root);
            }
            return columns;
        }
        for (TreeTableColumn treeTableColumn : root.getColumns()) {
            columns.addAll(this.getLeaves(treeTableColumn));
        }
        return columns;
    }
}

