/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.cells.editors.TextFieldEditorBuilder;
import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;

public class GenericEditableTableCell<S, T>
extends TableCell<S, T> {
    protected EditorNodeBuilder builder;
    protected Region editorNode;
    protected Consumer<Exception> commitExceptionConsumer = null;
    private BiFunction<Integer, Integer, Integer> stepFunction = (index, direction) -> 0;

    public GenericEditableTableCell() {
        this(new TextFieldEditorBuilder());
    }

    public GenericEditableTableCell(EditorNodeBuilder builder) {
        this(builder, null);
    }

    public GenericEditableTableCell(EditorNodeBuilder builder, Consumer<Exception> exConsumer) {
        this.builder = builder;
        this.commitExceptionConsumer = exConsumer;
    }

    protected void commitHelper(boolean losingFocus) {
        block4: {
            if (this.editorNode == null) {
                return;
            }
            try {
                this.builder.validateValue();
                this.commitEdit(this.builder.getValue());
                this.builder.nullEditorNode();
                this.editorNode = null;
            }
            catch (Exception ex) {
                if (this.commitExceptionConsumer != null) {
                    this.commitExceptionConsumer.accept(ex);
                }
                if (!losingFocus) break block4;
                this.cancelEdit();
            }
        }
    }

    protected Object getValue() {
        return this.getItem();
    }

    @Override
    public void startEdit() {
        if (this.isEditable()) {
            super.startEdit();
            this.getTableView().getFocusModel().focus(this.getTableRow().getIndex(), this.getTableColumn());
            if (this.editorNode == null) {
                this.createEditorNode();
            } else {
                this.builder.setValue(this.getValue());
            }
            this.builder.startEdit();
            this.setGraphic(this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }

    @Override
    public void cancelEdit() {
        this.editorNode = null;
        super.cancelEdit();
        this.builder.cancelEdit();
        this.builder.setValue(this.getValue());
        this.builder.nullEditorNode();
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.editorNode != null) {
                this.builder.setValue(this.getValue());
            }
            this.setGraphic(this.editorNode);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.builder.updateItem(item, empty);
        } else {
            Object value = this.getValue();
            if (value instanceof Node) {
                this.setGraphic((Node)value);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(value == null ? null : String.valueOf(value));
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }

    private void createEditorNode() {
        EventHandler<KeyEvent> keyEventsHandler = t -> {
            if (t.getCode() == KeyCode.ENTER) {
                this.commitHelper(false);
            } else if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
            } else if (t.getCode() == KeyCode.TAB) {
                this.commitHelper(false);
                this.editNext(!t.isShiftDown());
            }
        };
        ChangeListener<Boolean> focusChangeListener = (observable, oldValue, newValue) -> {
            if (this.editorNode != null && !newValue.booleanValue()) {
                this.commitHelper(true);
            }
        };
        this.editorNode = this.builder.createNode(this.getValue(), keyEventsHandler, focusChangeListener);
    }

    public BiFunction<Integer, Integer, Integer> getStepFunction() {
        return this.stepFunction;
    }

    public void setStepFunction(BiFunction<Integer, Integer, Integer> stepFunction) {
        this.stepFunction = stepFunction;
    }

    /*
     * WARNING - void declaration
     */
    private void editNext(boolean forward) {
        void var4_11;
        void var4_9;
        ArrayList columns = new ArrayList();
        for (TableColumn tableColumn : this.getTableView().getColumns()) {
            columns.addAll(this.getLeaves(tableColumn));
        }
        int index = this.getIndex();
        int n = columns.indexOf(this.getTableColumn());
        if (forward) {
            void var4_7;
            if (++var4_7 > columns.size() - 1) {
                boolean bl = false;
                index += this.stepFunction.apply(index, 1).intValue();
            }
        } else if (--var4_9 < 0) {
            int n2 = columns.size() - 1;
            index += this.stepFunction.apply(index, -1).intValue();
        }
        if (columns.size() < 2 && index == this.getIndex()) {
            return;
        }
        TableColumn nextColumn = (TableColumn)columns.get((int)var4_11);
        if (nextColumn != null) {
            this.getTableView().edit(index, nextColumn);
            this.getTableView().scrollToColumn(nextColumn);
        }
    }

    private List<TableColumn<S, ?>> getLeaves(TableColumn<S, ?> rootColumn) {
        ArrayList columns = new ArrayList();
        if (rootColumn.getColumns().isEmpty()) {
            if (rootColumn.isEditable()) {
                columns.add(rootColumn);
            }
            return columns;
        }
        for (TableColumn tableColumn : rootColumn.getColumns()) {
            columns.addAll(this.getLeaves(tableColumn));
        }
        return columns;
    }
}

