/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors;

import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;

public abstract class TextFieldEditorBase<T>
implements EditorNodeBuilder<T> {
    protected JFXTextField textField;
    protected final ValidatorBase[] validators;

    public TextFieldEditorBase(ValidatorBase ... validators) {
        this.validators = validators;
    }

    @Override
    public void startEdit() {
        Platform.runLater(() -> {
            this.textField.selectAll();
            this.textField.requestFocus();
        });
    }

    @Override
    public void cancelEdit() {
    }

    @Override
    public void updateItem(T item, boolean empty) {
        Platform.runLater(() -> {
            this.textField.selectAll();
            this.textField.requestFocus();
        });
    }

    @Override
    public Region createNode(T value, EventHandler<KeyEvent> keyEventsHandler, ChangeListener<Boolean> focusChangeListener) {
        this.textField = value == null ? new JFXTextField() : new JFXTextField(String.valueOf(value));
        this.textField.setOnKeyPressed(keyEventsHandler);
        this.textField.getValidators().addAll((ValidatorBase[])this.validators);
        this.textField.focusedProperty().addListener(focusChangeListener);
        return this.textField;
    }

    @Override
    public void setValue(T value) {
        this.textField.setText(value == null ? null : String.valueOf(value));
    }

    @Override
    public void validateValue() throws Exception {
        if (!this.textField.validate()) {
            throw new Exception("Invalid value");
        }
    }

    @Override
    public void nullEditorNode() {
        this.textField = null;
    }
}

