/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXRippler;
import com.jfoenix.utils.JFXNodeUtils;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;

public class JFXTreeCell<T>
extends TreeCell<T> {
    protected JFXRippler cellRippler = new JFXRippler((Node)this){

        @Override
        protected Node getMask() {
            Region clip = new Region();
            JFXNodeUtils.updateBackground(JFXTreeCell.this.getBackground(), clip);
            double width = this.control.getLayoutBounds().getWidth();
            double height = this.control.getLayoutBounds().getHeight();
            clip.resize(width, height);
            return clip;
        }

        @Override
        protected void positionControl(Node control) {
        }
    };
    private HBox hbox;
    private StackPane selectedPane = new StackPane();
    private InvalidationListener treeItemGraphicInvalidationListener = observable -> this.updateDisplay(this.getItem(), this.isEmpty());
    private WeakInvalidationListener weakTreeItemGraphicListener = new WeakInvalidationListener(this.treeItemGraphicInvalidationListener);
    private WeakReference<TreeItem<T>> treeItemRef;

    public JFXTreeCell() {
        this.selectedPane.getStyleClass().add("selection-bar");
        this.selectedPane.setBackground(new Background(new BackgroundFill(Color.RED, CornerRadii.EMPTY, Insets.EMPTY)));
        this.selectedPane.setPrefWidth(3.0);
        this.selectedPane.setMouseTransparent(true);
        this.selectedProperty().addListener((o, oldVal, newVal) -> this.selectedPane.setVisible(newVal != false));
        InvalidationListener treeItemInvalidationListener = observable -> {
            TreeItem newTreeItem;
            TreeItem oldTreeItem;
            TreeItem treeItem = oldTreeItem = this.treeItemRef == null ? null : (TreeItem)this.treeItemRef.get();
            if (oldTreeItem != null) {
                oldTreeItem.graphicProperty().removeListener(this.weakTreeItemGraphicListener);
            }
            if ((newTreeItem = this.getTreeItem()) != null) {
                newTreeItem.graphicProperty().addListener(this.weakTreeItemGraphicListener);
                this.treeItemRef = new WeakReference<TreeItem<TreeItem<T>>>(newTreeItem);
            }
        };
        WeakInvalidationListener weakTreeItemListener = new WeakInvalidationListener(treeItemInvalidationListener);
        this.treeItemProperty().addListener(weakTreeItemListener);
        if (this.getTreeItem() != null) {
            this.getTreeItem().graphicProperty().addListener(this.weakTreeItemGraphicListener);
        }
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        if (!this.getChildren().contains(this.selectedPane)) {
            this.getChildren().add(0, this.cellRippler);
            this.cellRippler.rippler.clear();
            this.getChildren().add(0, this.selectedPane);
        }
        this.cellRippler.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        this.cellRippler.releaseRipple();
        this.selectedPane.resizeRelocate(0.0, 0.0, this.selectedPane.prefWidth(-1.0), this.getHeight());
        this.selectedPane.setVisible(this.isSelected());
    }

    private void updateDisplay(T item, boolean empty) {
        if (item == null || empty) {
            this.hbox = null;
            this.setText(null);
            this.setGraphic(null);
        } else {
            TreeItem treeItem = this.getTreeItem();
            if (treeItem != null && treeItem.getGraphic() != null) {
                if (item instanceof Node) {
                    this.setText(null);
                    if (this.hbox == null) {
                        this.hbox = new HBox(3.0);
                    }
                    this.hbox.getChildren().setAll((Node[])new Node[]{treeItem.getGraphic(), (Node)item});
                    this.setGraphic(this.hbox);
                } else {
                    this.hbox = null;
                    this.setText(item.toString());
                    this.setGraphic(treeItem.getGraphic());
                }
            } else {
                this.hbox = null;
                if (item instanceof Node) {
                    this.setText(null);
                    this.setGraphic((Node)item);
                } else {
                    this.setText(item.toString());
                    this.setGraphic(null);
                }
            }
        }
    }

    @Override
    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.updateDisplay(item, empty);
        this.setMouseTransparent(item == null || empty);
    }
}

