/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.scene.NodeHelper;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.control.skin.TooltipSkin;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public class JFXTooltip
extends Tooltip {
    private static TooltipBehavior BEHAVIOR = new TooltipBehavior(Duration.millis(650.0), Duration.millis(1500.0), Duration.millis(200.0));
    private Node root = null;
    private boolean hiding = false;
    private JFXAnimationTimer animation = new JFXAnimationTimer(JFXKeyFrame.builder().setDuration(Duration.millis(150.0)).setAnimateCondition(() -> !this.hiding).setKeyValues(JFXKeyValue.builder().setTargetSupplier(() -> this.root.opacityProperty()).setEndValue(1).build(), JFXKeyValue.builder().setTargetSupplier(() -> this.root.scaleXProperty()).setEndValue(1).build(), JFXKeyValue.builder().setTargetSupplier(() -> this.root.scaleYProperty()).setEndValue(1).build()).build(), JFXKeyFrame.builder().setDuration(Duration.millis(75.0)).setAnimateCondition(() -> this.hiding).setKeyValues(JFXKeyValue.builder().setTargetSupplier(() -> this.root.opacityProperty()).setEndValue(0).build()).build());
    private Pos pos = Pos.BOTTOM_CENTER;
    private double margin = 8.0;
    private static final String DEFAULT_STYLE_CLASS = "jfx-tooltip";
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);

    public static void setHoverDelay(Duration duration) {
        JFXTooltip.BEHAVIOR.setHoverDelay(duration == null ? Duration.millis(650.0) : duration);
    }

    public static void setVisibleDuration(Duration duration) {
        JFXTooltip.BEHAVIOR.setVisibleDuration(duration == null ? Duration.millis(1500.0) : duration);
    }

    public static void setLeftDelay(Duration duration) {
        JFXTooltip.BEHAVIOR.setLeftDelay(duration == null ? Duration.millis(200.0) : duration);
    }

    public static void install(Node node, JFXTooltip tooltip) {
        JFXTooltip.BEHAVIOR.install(node, tooltip);
    }

    public static void install(Node node, JFXTooltip tooltip, Pos pos) {
        tooltip.setPos(pos);
        JFXTooltip.BEHAVIOR.install(node, tooltip);
    }

    public static void uninstall(Node node) {
        JFXTooltip.BEHAVIOR.uninstall(node);
    }

    public JFXTooltip() {
        this(null);
    }

    public JFXTooltip(String text, Pos pos) {
        this(text);
        this.setPos(pos);
    }

    public JFXTooltip(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.eventHandlerManager.addEventHandler(WindowEvent.WINDOW_SHOWING, (? super T event) -> {
            this.root = this.getScene().getRoot();
            this.root.setOpacity(0.0);
            this.root.setScaleY(0.8);
            this.root.setScaleX(0.8);
            this.animation.setOnFinished(null);
        });
        this.eventHandlerManager.addEventHandler(WindowEvent.WINDOW_SHOWN, (? super T event) -> {
            this.setAnchorX(this.getUpdatedAnchorX(this.getAnchorX()));
            this.setAnchorY(this.getUpdatedAnchorY(this.getAnchorY()));
            this.animation.reverseAndContinue();
        });
    }

    public Pos getPos() {
        return this.pos;
    }

    public void setPos(Pos pos) {
        this.pos = pos == null ? Pos.BOTTOM_CENTER : pos;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    private double getUpdatedAnchorY(double anchor) {
        switch (this.pos.getVpos()) {
            case CENTER: {
                return anchor - this.getHeight() / 2.0;
            }
            case TOP: 
            case BASELINE: {
                return anchor - this.getHeight();
            }
        }
        return anchor;
    }

    private double getUpdatedAnchorX(double anchor) {
        switch (this.pos.getHpos()) {
            case CENTER: {
                return anchor - this.getWidth() / 2.0;
            }
            case LEFT: {
                return anchor - this.getWidth();
            }
        }
        return anchor;
    }

    @Override
    public void hide() {
        this.hiding = true;
        this.animation.setOnFinished(() -> super.hide());
        this.animation.reverseAndContinue();
    }

    @Override
    public void show(Node ownerNode, double anchorX, double anchorY) {
        this.hiding = false;
        Bounds sceneBounds = ownerNode.localToScene(ownerNode.getBoundsInLocal());
        if (this.isShowing()) {
            this.animation.setOnFinished(null);
            this.animation.reverseAndContinue();
            anchorX = this.ownerX(ownerNode, sceneBounds) + this.getHPosForNode(sceneBounds);
            anchorY = this.ownerY(ownerNode, sceneBounds) + this.getVPosForNode(sceneBounds);
            this.setAnchorY(this.getUpdatedAnchorY(anchorY));
            this.setAnchorX(this.getUpdatedAnchorX(anchorX));
        } else {
            anchorX = this.ownerX(ownerNode, sceneBounds) + this.getHPosForNode(sceneBounds);
            anchorY = this.ownerY(ownerNode, sceneBounds) + this.getVPosForNode(sceneBounds);
            super.show(ownerNode, anchorX, anchorY);
        }
    }

    private double ownerX(Node ownerNode, Bounds sceneBounds) {
        Window parent = ownerNode.getScene().getWindow();
        return parent.getX() + sceneBounds.getMinX() + ownerNode.getScene().getX();
    }

    private double ownerY(Node ownerNode, Bounds sceneBounds) {
        Window parent = ownerNode.getScene().getWindow();
        return parent.getY() + sceneBounds.getMinY() + ownerNode.getScene().getY();
    }

    public void showOnAnchors(Node ownerNode, double anchorX, double anchorY) {
        this.hiding = false;
        Bounds sceneBounds = ownerNode.localToScene(ownerNode.getBoundsInLocal());
        if (this.isShowing()) {
            this.animation.setOnFinished(null);
            this.animation.reverseAndContinue();
            this.setAnchorX(this.getUpdatedAnchorX(anchorX += this.ownerX(ownerNode, sceneBounds)));
            this.setAnchorY(this.getUpdatedAnchorY(anchorY += this.ownerY(ownerNode, sceneBounds)));
        } else {
            super.show(ownerNode, anchorX += this.ownerX(ownerNode, sceneBounds), anchorY += this.ownerY(ownerNode, sceneBounds));
        }
    }

    private double getHPosForNode(Bounds sceneBounds) {
        double hx = -this.margin;
        switch (this.pos.getHpos()) {
            case CENTER: {
                hx = sceneBounds.getWidth() / 2.0;
                break;
            }
            case RIGHT: {
                hx = sceneBounds.getWidth() + this.margin;
            }
        }
        return hx;
    }

    private double getVPosForNode(Bounds sceneBounds) {
        double vy = -this.margin;
        switch (this.pos.getVpos()) {
            case CENTER: {
                vy = sceneBounds.getHeight() / 2.0;
                break;
            }
            case BOTTOM: {
                vy = sceneBounds.getHeight() + this.margin;
            }
        }
        return vy;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TooltipSkin(this){
            {
                Node node = this.getNode();
                node.setEffect(null);
            }
        };
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return super.buildEventDispatchChain(tail).prepend(this.eventHandlerManager);
    }

    private static class TooltipBehavior {
        private static String TOOLTIP_PROP = "jfoenix-tooltip";
        private Timeline hoverTimer = new Timeline();
        private Timeline visibleTimer = new Timeline();
        private Timeline leftTimer = new Timeline();
        private Node hoveredNode;
        private JFXTooltip nextTooltip;
        private JFXTooltip currentTooltip;
        private EventHandler<MouseEvent> moveHandler = event -> {
            if (this.visibleTimer.getStatus() == Animation.Status.RUNNING) {
                return;
            }
            this.hoveredNode = (Node)event.getSource();
            Object property = this.hoveredNode.getProperties().get(TOOLTIP_PROP);
            if (property instanceof JFXTooltip) {
                JFXTooltip tooltip = (JFXTooltip)property;
                this.ensureHoveredNodeIsVisible(() -> {
                    if (this.leftTimer.getStatus() == Animation.Status.RUNNING) {
                        if (this.currentTooltip != null) {
                            this.currentTooltip.hide();
                        }
                        this.currentTooltip = tooltip;
                        this.showTooltip(tooltip);
                        this.leftTimer.stop();
                        this.visibleTimer.playFromStart();
                    } else {
                        this.nextTooltip = tooltip;
                        this.hoverTimer.stop();
                        this.hoverTimer.playFromStart();
                    }
                });
            } else {
                this.uninstall(this.hoveredNode);
            }
        };
        private WeakEventHandler<MouseEvent> weakMoveHandler = new WeakEventHandler<MouseEvent>(this.moveHandler);
        private EventHandler<MouseEvent> exitHandler = event -> {
            if (this.hoverTimer.getStatus() == Animation.Status.RUNNING) {
                this.hoverTimer.stop();
            } else if (this.visibleTimer.getStatus() == Animation.Status.RUNNING) {
                this.visibleTimer.stop();
                this.leftTimer.playFromStart();
            }
            this.hoveredNode = null;
            this.nextTooltip = null;
        };
        private WeakEventHandler<MouseEvent> weakExitHandler = new WeakEventHandler<MouseEvent>(this.exitHandler);
        private EventHandler<MouseEvent> pressedHandler = event -> {
            this.hoverTimer.stop();
            this.visibleTimer.stop();
            this.leftTimer.stop();
            if (this.currentTooltip != null) {
                this.currentTooltip.hide();
            }
            this.hoveredNode = null;
            this.currentTooltip = null;
            this.nextTooltip = null;
        };
        private WeakEventHandler<MouseEvent> weakPressedHandler = new WeakEventHandler<MouseEvent>(this.pressedHandler);

        private TooltipBehavior(Duration hoverDelay, Duration visibleDuration, Duration leftDelay) {
            this.setHoverDelay(hoverDelay);
            this.hoverTimer.setOnFinished(event -> {
                this.ensureHoveredNodeIsVisible(() -> {
                    NodeOrientation nodeOrientation = this.hoveredNode.getEffectiveNodeOrientation();
                    this.nextTooltip.getScene().setNodeOrientation(nodeOrientation);
                    this.showTooltip(this.nextTooltip);
                    this.currentTooltip = this.nextTooltip;
                    this.hoveredNode = null;
                    this.visibleTimer.playFromStart();
                });
                this.nextTooltip = null;
            });
            this.setVisibleDuration(visibleDuration);
            this.visibleTimer.setOnFinished(event -> this.hideCurrentTooltip());
            this.setLeftDelay(leftDelay);
            this.leftTimer.setOnFinished(event -> this.hideCurrentTooltip());
        }

        private void setHoverDelay(Duration duration) {
            this.hoverTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(duration, new KeyValue[0])});
        }

        private void setVisibleDuration(Duration duration) {
            this.visibleTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(duration, new KeyValue[0])});
        }

        private void setLeftDelay(Duration duration) {
            this.leftTimer.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(duration, new KeyValue[0])});
        }

        private void hideCurrentTooltip() {
            this.currentTooltip.hide();
            this.currentTooltip = null;
            this.hoveredNode = null;
        }

        private void showTooltip(JFXTooltip tooltip) {
            tooltip.show(this.hoveredNode, -1.0, -1.0);
        }

        private void install(Node node, JFXTooltip tooltip) {
            if (node == null) {
                return;
            }
            if (tooltip == null) {
                this.uninstall(node);
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.weakMoveHandler);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.weakExitHandler);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.weakPressedHandler);
            node.addEventHandler(MouseEvent.MOUSE_MOVED, this.weakMoveHandler);
            node.addEventHandler(MouseEvent.MOUSE_EXITED, this.weakExitHandler);
            node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.weakPressedHandler);
            node.getProperties().put(TOOLTIP_PROP, tooltip);
        }

        private void uninstall(Node node) {
            if (node == null) {
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.weakMoveHandler);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.weakExitHandler);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.weakPressedHandler);
            Object tooltip = node.getProperties().get(TOOLTIP_PROP);
            if (tooltip != null) {
                node.getProperties().remove(TOOLTIP_PROP);
                if (tooltip.equals(this.currentTooltip) || tooltip.equals(this.nextTooltip)) {
                    this.weakPressedHandler.handle(null);
                }
            }
        }

        private void ensureHoveredNodeIsVisible(Runnable visibleRunnable) {
            boolean treeVisible;
            Window owner = this.getWindow(this.hoveredNode);
            if (owner != null && owner.isShowing() && (treeVisible = NodeHelper.isTreeVisible(this.hoveredNode))) {
                visibleRunnable.run();
            }
        }

        private Window getWindow(Node node) {
            Scene scene = node == null ? null : node.getScene();
            return scene == null ? null : scene.getWindow();
        }
    }
}

