/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.skins.JFXToggleNodeSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.ColorConverter;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleButton;
import javafx.scene.paint.Color;

@DefaultProperty(value="graphic")
public class JFXToggleNode
extends ToggleButton {
    private static final String DEFAULT_STYLE_CLASS = "jfx-toggle-node";
    private StyleableObjectProperty<Color> selectedColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$000(), this, "selectedColor", Color.rgb(0, 0, 0, 0.2));
    private StyleableObjectProperty<Color> unSelectedColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$100(), this, "unSelectedCOlor", Color.TRANSPARENT);
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.access$200(), this, "disableAnimation", false);
    private StyleableBooleanProperty disableVisualFocus = new SimpleStyleableBooleanProperty(StyleableProperties.access$300(), this, "disableVisualFocus", false);

    public JFXToggleNode() {
        this.initialize();
    }

    public JFXToggleNode(String text) {
        super(text);
        this.initialize();
    }

    public JFXToggleNode(Node graphic) {
        super("", graphic);
        this.initialize();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new JFXToggleNodeSkin(this);
    }

    private void initialize() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
    }

    @Override
    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-toggle-node.css").toExternalForm();
    }

    public final StyleableObjectProperty<Color> selectedColorProperty() {
        return this.selectedColor;
    }

    public final Color getSelectedColor() {
        return this.selectedColor == null ? Color.rgb(0, 0, 0, 0.2) : (Color)this.selectedColorProperty().get();
    }

    public final void setSelectedColor(Color selectedColor) {
        this.selectedColorProperty().set(selectedColor);
    }

    public final StyleableObjectProperty<Color> unSelectedColorProperty() {
        return this.unSelectedColor;
    }

    public final Color getUnSelectedColor() {
        return this.unSelectedColor == null ? Color.TRANSPARENT : (Color)this.unSelectedColorProperty().get();
    }

    public final void setUnSelectedColor(Color unSelectedColor) {
        this.unSelectedColorProperty().set(unSelectedColor);
    }

    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    public final void setDisableAnimation(Boolean disabled) {
        this.disableAnimationProperty().set(disabled);
    }

    public final StyleableBooleanProperty disableVisualFocusProperty() {
        return this.disableVisualFocus;
    }

    public final Boolean isDisableVisualFocus() {
        return this.disableVisualFocus != null && this.disableVisualFocusProperty().get();
    }

    public final void setDisableVisualFocus(Boolean disabled) {
        this.disableVisualFocusProperty().set(disabled);
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXToggleNode.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXToggleNode, Color> SELECTED_COLOR = new CssMetaData<JFXToggleNode, Color>("-jfx-toggle-color", ColorConverter.getInstance(), Color.rgb(255, 255, 255, 0.87)){

            @Override
            public boolean isSettable(JFXToggleNode control) {
                return control.selectedColor == null || !control.selectedColor.isBound();
            }

            @Override
            public StyleableProperty<Color> getStyleableProperty(JFXToggleNode control) {
                return control.selectedColorProperty();
            }
        };
        private static final CssMetaData<JFXToggleNode, Color> UNSELECTED_COLOR = new CssMetaData<JFXToggleNode, Color>("-jfx-untoggle-color", ColorConverter.getInstance(), Color.TRANSPARENT){

            @Override
            public boolean isSettable(JFXToggleNode control) {
                return control.unSelectedColor == null || !control.unSelectedColor.isBound();
            }

            @Override
            public StyleableProperty<Color> getStyleableProperty(JFXToggleNode control) {
                return control.unSelectedColorProperty();
            }
        };
        private static final CssMetaData<JFXToggleNode, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXToggleNode, Boolean>("-jfx-disable-animation", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(JFXToggleNode control) {
                return control.disableAnimation == null || !control.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXToggleNode control) {
                return control.disableAnimationProperty();
            }
        };
        private static final CssMetaData<JFXToggleNode, Boolean> DISABLE_VISUAL_FOCUS = new CssMetaData<JFXToggleNode, Boolean>("-jfx-disable-visual-focus", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(JFXToggleNode control) {
                return control.disableVisualFocus == null || !control.disableVisualFocus.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXToggleNode control) {
                return control.disableVisualFocusProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return SELECTED_COLOR;
        }

        static /* synthetic */ CssMetaData access$100() {
            return UNSELECTED_COLOR;
        }

        static /* synthetic */ CssMetaData access$200() {
            return DISABLE_ANIMATION;
        }

        static /* synthetic */ CssMetaData access$300() {
            return DISABLE_VISUAL_FOCUS;
        }

        static {
            ArrayList styleables = new ArrayList(ToggleButton.getClassCssMetaData());
            Collections.addAll(styleables, SELECTED_COLOR, UNSELECTED_COLOR, DISABLE_ANIMATION, DISABLE_VISUAL_FOCUS);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

