/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.skins.JFXToggleButtonSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleButton;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JFXToggleButton
extends ToggleButton {
    private static final String DEFAULT_STYLE_CLASS = "jfx-toggle-button";
    private StyleableObjectProperty<Paint> toggleColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$000(), this, "toggleColor", Color.valueOf("#009688"));
    private StyleableObjectProperty<Paint> untoggleColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$100(), this, "unToggleColor", Color.valueOf("#FAFAFA"));
    private StyleableObjectProperty<Paint> toggleLineColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$200(), this, "toggleLineColor", Color.valueOf("#77C2BB"));
    private StyleableObjectProperty<Paint> untoggleLineColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$300(), this, "unToggleLineColor", Color.valueOf("#999999"));
    private final StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.access$400(), this, "size", 10.0);
    private StyleableBooleanProperty disableVisualFocus = new SimpleStyleableBooleanProperty(StyleableProperties.access$500(), this, "disableVisualFocus", false);
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.access$600(), this, "disableAnimation", false);

    public JFXToggleButton() {
        this.initialize();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElements.length && i < 15; ++i) {
            if (!stackTraceElements[i].getClassName().toLowerCase().contains(".scenebuilder.kit.fxom.")) continue;
            this.setText("ToggleButton");
            break;
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new JFXToggleButtonSkin(this);
    }

    private void initialize() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
    }

    @Override
    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-toggle-button.css").toExternalForm();
    }

    public Paint getToggleColor() {
        return this.toggleColor == null ? Color.valueOf("#009688") : (Paint)this.toggleColor.get();
    }

    public StyleableObjectProperty<Paint> toggleColorProperty() {
        return this.toggleColor;
    }

    public void setToggleColor(Paint color) {
        this.toggleColor.set(color);
    }

    public Paint getUnToggleColor() {
        return this.untoggleColor == null ? Color.valueOf("#FAFAFA") : (Paint)this.untoggleColor.get();
    }

    public StyleableObjectProperty<Paint> unToggleColorProperty() {
        return this.untoggleColor;
    }

    public void setUnToggleColor(Paint color) {
        this.untoggleColor.set(color);
    }

    public Paint getToggleLineColor() {
        return this.toggleLineColor == null ? Color.valueOf("#77C2BB") : (Paint)this.toggleLineColor.get();
    }

    public StyleableObjectProperty<Paint> toggleLineColorProperty() {
        return this.toggleLineColor;
    }

    public void setToggleLineColor(Paint color) {
        this.toggleLineColor.set(color);
    }

    public Paint getUnToggleLineColor() {
        return this.untoggleLineColor == null ? Color.valueOf("#999999") : (Paint)this.untoggleLineColor.get();
    }

    public StyleableObjectProperty<Paint> unToggleLineColorProperty() {
        return this.untoggleLineColor;
    }

    public void setUnToggleLineColor(Paint color) {
        this.untoggleLineColor.set(color);
    }

    public double getSize() {
        return this.size.get();
    }

    public StyleableDoubleProperty sizeProperty() {
        return this.size;
    }

    public void setSize(double size) {
        this.size.set(size);
    }

    public final StyleableBooleanProperty disableVisualFocusProperty() {
        return this.disableVisualFocus;
    }

    public final Boolean isDisableVisualFocus() {
        return this.disableVisualFocus != null && this.disableVisualFocusProperty().get();
    }

    public final void setDisableVisualFocus(Boolean disabled) {
        this.disableVisualFocusProperty().set(disabled);
    }

    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    public final void setDisableAnimation(Boolean disabled) {
        this.disableAnimationProperty().set(disabled);
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXToggleButton.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXToggleButton, Paint> TOGGLE_COLOR = new CssMetaData<JFXToggleButton, Paint>("-jfx-toggle-color", PaintConverter.getInstance(), (Paint)Color.valueOf("#009688")){

            @Override
            public boolean isSettable(JFXToggleButton control) {
                return control.toggleColor == null || !control.toggleColor.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(JFXToggleButton control) {
                return control.toggleColorProperty();
            }
        };
        private static final CssMetaData<JFXToggleButton, Paint> UNTOGGLE_COLOR = new CssMetaData<JFXToggleButton, Paint>("-jfx-untoggle-color", PaintConverter.getInstance(), (Paint)Color.valueOf("#FAFAFA")){

            @Override
            public boolean isSettable(JFXToggleButton control) {
                return control.untoggleColor == null || !control.untoggleColor.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(JFXToggleButton control) {
                return control.unToggleColorProperty();
            }
        };
        private static final CssMetaData<JFXToggleButton, Paint> TOGGLE_LINE_COLOR = new CssMetaData<JFXToggleButton, Paint>("-jfx-toggle-line-color", PaintConverter.getInstance(), (Paint)Color.valueOf("#77C2BB")){

            @Override
            public boolean isSettable(JFXToggleButton control) {
                return control.toggleLineColor == null || !control.toggleLineColor.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(JFXToggleButton control) {
                return control.toggleLineColorProperty();
            }
        };
        private static final CssMetaData<JFXToggleButton, Paint> UNTOGGLE_LINE_COLOR = new CssMetaData<JFXToggleButton, Paint>("-jfx-untoggle-line-color", PaintConverter.getInstance(), (Paint)Color.valueOf("#999999")){

            @Override
            public boolean isSettable(JFXToggleButton control) {
                return control.untoggleLineColor == null || !control.untoggleLineColor.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(JFXToggleButton control) {
                return control.unToggleLineColorProperty();
            }
        };
        private static final CssMetaData<JFXToggleButton, Number> SIZE = new CssMetaData<JFXToggleButton, Number>("-jfx-size", StyleConverter.getSizeConverter(), (Number)10.0){

            @Override
            public boolean isSettable(JFXToggleButton control) {
                return !control.size.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(JFXToggleButton control) {
                return control.sizeProperty();
            }
        };
        private static final CssMetaData<JFXToggleButton, Boolean> DISABLE_VISUAL_FOCUS = new CssMetaData<JFXToggleButton, Boolean>("-jfx-disable-visual-focus", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(JFXToggleButton control) {
                return control.disableVisualFocus == null || !control.disableVisualFocus.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXToggleButton control) {
                return control.disableVisualFocusProperty();
            }
        };
        private static final CssMetaData<JFXToggleButton, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXToggleButton, Boolean>("-jfx-disable-animation", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(JFXToggleButton control) {
                return control.disableAnimation == null || !control.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXToggleButton control) {
                return control.disableAnimationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return TOGGLE_COLOR;
        }

        static /* synthetic */ CssMetaData access$100() {
            return UNTOGGLE_COLOR;
        }

        static /* synthetic */ CssMetaData access$200() {
            return TOGGLE_LINE_COLOR;
        }

        static /* synthetic */ CssMetaData access$300() {
            return UNTOGGLE_LINE_COLOR;
        }

        static /* synthetic */ CssMetaData access$400() {
            return SIZE;
        }

        static /* synthetic */ CssMetaData access$500() {
            return DISABLE_VISUAL_FOCUS;
        }

        static /* synthetic */ CssMetaData access$600() {
            return DISABLE_ANIMATION;
        }

        static {
            ArrayList styleables = new ArrayList(ToggleButton.getClassCssMetaData());
            Collections.addAll(styleables, SIZE, TOGGLE_COLOR, UNTOGGLE_COLOR, TOGGLE_LINE_COLOR, UNTOGGLE_LINE_COLOR, DISABLE_VISUAL_FOCUS, DISABLE_ANIMATION);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

