/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.FakeFocusJFXTextField;
import com.jfoenix.controls.ValidationControl;
import com.jfoenix.controls.base.IFXValidatableControl;
import com.jfoenix.skins.JFXTimePickerSkin;
import com.jfoenix.validation.base.ValidatorBase;
import java.time.LocalTime;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.scene.AccessibleRole;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import javafx.util.converter.LocalTimeStringConverter;

public class JFXTimePicker
extends ComboBoxBase<LocalTime>
implements IFXValidatableControl {
    private ObjectProperty<StackPane> dialogParent = new SimpleObjectProperty<Object>(null);
    private ObjectProperty<StringConverter<LocalTime>> converter = new SimpleObjectProperty<Object>(this, "converter", null);
    private StringConverter<LocalTime> defaultConverter = new LocalTimeStringConverter(FormatStyle.SHORT, Locale.getDefault());
    private BooleanProperty _24HourView = new SimpleBooleanProperty(false);
    private ReadOnlyObjectWrapper<TextField> editor;
    private ValidationControl validationControl = new ValidationControl(this);
    private static final String DEFAULT_STYLE_CLASS = "jfx-time-picker";
    private StyleableBooleanProperty overLay = new SimpleStyleableBooleanProperty(StyleableProperties.access$000(), this, "overLay", false);
    private StyleableObjectProperty<Paint> defaultColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$100(), this, "defaultColor", Color.valueOf("#009688"));

    public JFXTimePicker() {
        this.initialize();
    }

    public JFXTimePicker(LocalTime localTime) {
        this.setValue(localTime);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.DATE_PICKER);
        this.setEditable(true);
    }

    @Override
    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-time-picker.css").toExternalForm();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new JFXTimePickerSkin(this);
    }

    public final ObjectProperty<StackPane> dialogParentProperty() {
        return this.dialogParent;
    }

    public final StackPane getDialogParent() {
        return (StackPane)this.dialogParentProperty().get();
    }

    public final void setDialogParent(StackPane dialogParent) {
        this.dialogParentProperty().set(dialogParent);
    }

    public final ObjectProperty<StringConverter<LocalTime>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<LocalTime> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<LocalTime> getConverter() {
        StringConverter converter = (StringConverter)this.converterProperty().get();
        if (converter != null) {
            return converter;
        }
        return this.defaultConverter;
    }

    public final BooleanProperty _24HourViewProperty() {
        return this._24HourView;
    }

    public final boolean is24HourView() {
        return this._24HourViewProperty().get();
    }

    public final void set24HourView(boolean value) {
        this._24HourViewProperty().setValue(value);
    }

    public final TextField getEditor() {
        return (TextField)this.editorProperty().get();
    }

    public final ReadOnlyObjectProperty<TextField> editorProperty() {
        if (this.editor == null) {
            this.editor = new ReadOnlyObjectWrapper(this, "editor");
            FakeFocusJFXTextField editorNode = new FakeFocusJFXTextField();
            this.focusedProperty().addListener((obj, oldVal, newVal) -> {
                if (this.getEditor() != null) {
                    editorNode.setFakeFocus((boolean)newVal);
                }
            });
            editorNode.activeValidatorWritableProperty().bind(this.activeValidatorProperty());
            this.editor.set(editorNode);
        }
        return this.editor.getReadOnlyProperty();
    }

    @Override
    public ValidatorBase getActiveValidator() {
        return this.validationControl.getActiveValidator();
    }

    @Override
    public ReadOnlyObjectProperty<ValidatorBase> activeValidatorProperty() {
        return this.validationControl.activeValidatorProperty();
    }

    @Override
    public ObservableList<ValidatorBase> getValidators() {
        return this.validationControl.getValidators();
    }

    @Override
    public void setValidators(ValidatorBase ... validators) {
        this.validationControl.setValidators(validators);
    }

    @Override
    public boolean validate() {
        return this.validationControl.validate();
    }

    @Override
    public void resetValidation() {
        this.validationControl.resetValidation();
    }

    public final StyleableBooleanProperty overLayProperty() {
        return this.overLay;
    }

    public final boolean isOverLay() {
        return this.overLay != null && this.overLayProperty().get();
    }

    public final void setOverLay(boolean overLay) {
        this.overLayProperty().set(overLay);
    }

    public Paint getDefaultColor() {
        return this.defaultColor == null ? Color.valueOf("#009688") : (Paint)this.defaultColor.get();
    }

    public StyleableObjectProperty<Paint> defaultColorProperty() {
        return this.defaultColor;
    }

    public void setDefaultColor(Paint color) {
        this.defaultColor.set(color);
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXTimePicker.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXTimePicker, Paint> DEFAULT_COLOR = new CssMetaData<JFXTimePicker, Paint>("-jfx-default-color", PaintConverter.getInstance(), (Paint)Color.valueOf("#009688")){

            @Override
            public boolean isSettable(JFXTimePicker control) {
                return control.defaultColor == null || !control.defaultColor.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(JFXTimePicker control) {
                return control.defaultColorProperty();
            }
        };
        private static final CssMetaData<JFXTimePicker, Boolean> OVERLAY = new CssMetaData<JFXTimePicker, Boolean>("-jfx-overlay", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(JFXTimePicker control) {
                return control.overLay == null || !control.overLay.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXTimePicker control) {
                return control.overLayProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return OVERLAY;
        }

        static /* synthetic */ CssMetaData access$100() {
            return DEFAULT_COLOR;
        }

        static {
            ArrayList styleables = new ArrayList(ComboBoxBase.getClassCssMetaData());
            Collections.addAll(styleables, DEFAULT_COLOR, OVERLAY);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

