/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.skins.JFXRadioButtonSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.ColorConverter;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class JFXRadioButton
extends RadioButton {
    private static final String DEFAULT_STYLE_CLASS = "jfx-radio-button";
    private static final String USER_AGENT_STYLESHEET = JFoenixResources.load("css/controls/jfx-radio-button.css").toExternalForm();
    private StyleableObjectProperty<Color> selectedColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$000(), this, "selectedColor", Color.valueOf("#0F9D58"));
    private StyleableObjectProperty<Color> unSelectedColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$100(), this, "unSelectedColor", Color.valueOf("#5A5A5A"));
    private StyleableBooleanProperty disableVisualFocus = new SimpleStyleableBooleanProperty(StyleableProperties.access$200(), this, "disableVisualFocus", false);
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.access$300(), this, "disableAnimation", false);

    public JFXRadioButton(String text) {
        super(text);
        this.initialize();
    }

    public JFXRadioButton() {
        this.initialize();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElements.length && i < 15; ++i) {
            if (!stackTraceElements[i].getClassName().toLowerCase().contains(".scenebuilder.kit.fxom.")) continue;
            this.setText("RadioButton");
            break;
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new JFXRadioButtonSkin(this);
    }

    @Override
    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    private void initialize() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
    }

    public final StyleableObjectProperty<Color> selectedColorProperty() {
        return this.selectedColor;
    }

    public final Color getSelectedColor() {
        return this.selectedColor == null ? Color.rgb(0, 0, 0, 0.2) : (Color)this.selectedColorProperty().get();
    }

    public final void setSelectedColor(Color selectedColor) {
        this.selectedColorProperty().set(selectedColor);
    }

    public final StyleableObjectProperty<Color> unSelectedColorProperty() {
        return this.unSelectedColor;
    }

    public final Color getUnSelectedColor() {
        return this.unSelectedColor == null ? Color.TRANSPARENT : (Color)this.unSelectedColorProperty().get();
    }

    public final void setUnSelectedColor(Color unSelectedColor) {
        this.unSelectedColorProperty().set(unSelectedColor);
    }

    public final StyleableBooleanProperty disableVisualFocusProperty() {
        return this.disableVisualFocus;
    }

    public final Boolean isDisableVisualFocus() {
        return this.disableVisualFocus != null && this.disableVisualFocusProperty().get();
    }

    public final void setDisableVisualFocus(Boolean disabled) {
        this.disableVisualFocusProperty().set(disabled);
    }

    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    public final void setDisableAnimation(Boolean disabled) {
        this.disableAnimationProperty().set(disabled);
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXRadioButton.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXRadioButton, Color> SELECTED_COLOR = new CssMetaData<JFXRadioButton, Color>("-jfx-selected-color", ColorConverter.getInstance(), Color.valueOf("#0F9D58")){

            @Override
            public boolean isSettable(JFXRadioButton control) {
                return control.selectedColor == null || !control.selectedColor.isBound();
            }

            @Override
            public StyleableProperty<Color> getStyleableProperty(JFXRadioButton control) {
                return control.selectedColorProperty();
            }
        };
        private static final CssMetaData<JFXRadioButton, Color> UNSELECTED_COLOR = new CssMetaData<JFXRadioButton, Color>("-jfx-unselected-color", ColorConverter.getInstance(), Color.valueOf("#5A5A5A")){

            @Override
            public boolean isSettable(JFXRadioButton control) {
                return control.unSelectedColor == null || !control.unSelectedColor.isBound();
            }

            @Override
            public StyleableProperty<Color> getStyleableProperty(JFXRadioButton control) {
                return control.unSelectedColorProperty();
            }
        };
        private static final CssMetaData<JFXRadioButton, Boolean> DISABLE_VISUAL_FOCUS = new CssMetaData<JFXRadioButton, Boolean>("-jfx-disable-visual-focus", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(JFXRadioButton control) {
                return control.disableVisualFocus == null || !control.disableVisualFocus.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXRadioButton control) {
                return control.disableVisualFocusProperty();
            }
        };
        private static final CssMetaData<JFXRadioButton, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXRadioButton, Boolean>("-jfx-disable-animation", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(JFXRadioButton control) {
                return control.disableAnimation == null || !control.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXRadioButton control) {
                return control.disableAnimationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return SELECTED_COLOR;
        }

        static /* synthetic */ CssMetaData access$100() {
            return UNSELECTED_COLOR;
        }

        static /* synthetic */ CssMetaData access$200() {
            return DISABLE_VISUAL_FOCUS;
        }

        static /* synthetic */ CssMetaData access$300() {
            return DISABLE_ANIMATION;
        }

        static {
            ArrayList styleables = new ArrayList(RadioButton.getClassCssMetaData());
            Collections.addAll(styleables, SELECTED_COLOR, UNSELECTED_COLOR, DISABLE_VISUAL_FOCUS, DISABLE_ANIMATION);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

