/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXListCell;
import com.jfoenix.skins.JFXListViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.SizeConverter;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;

public class JFXListView<T>
extends ListView<T> {
    private ObjectProperty<Integer> depthProperty = new SimpleObjectProperty<Integer>(0);
    private ReadOnlyDoubleWrapper currentVerticalGapProperty = new ReadOnlyDoubleWrapper();
    private BooleanProperty showTooltip = new SimpleBooleanProperty(false);
    @Deprecated
    private ObjectProperty<Node> groupnode = new SimpleObjectProperty<Label>(new Label("GROUP"));
    @Deprecated
    private ReadOnlyObjectWrapper<Integer> overAllIndexProperty = new ReadOnlyObjectWrapper<Integer>(-1);
    @Deprecated
    private ObjectProperty<ObservableList<JFXListView<?>>> sublistsProperty = new SimpleObjectProperty(FXCollections.observableArrayList());
    @Deprecated
    private LinkedHashMap<Integer, JFXListView<?>> sublistsIndices = new LinkedHashMap();
    private static final String DEFAULT_STYLE_CLASS = "jfx-list-view";
    private boolean allowClear = true;
    private StyleableDoubleProperty verticalGap = new SimpleStyleableDoubleProperty(StyleableProperties.access$000(), this, "verticalGap", 0.0);
    private StyleableBooleanProperty expanded = new SimpleStyleableBooleanProperty(StyleableProperties.access$100(), this, "expanded", false);

    public JFXListView() {
        this.setCellFactory(listView -> new JFXListCell());
        this.initialize();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new JFXListViewSkin(this);
    }

    public ObjectProperty<Integer> depthProperty() {
        return this.depthProperty;
    }

    public int getDepth() {
        return (Integer)this.depthProperty.get();
    }

    public void setDepth(int depth) {
        this.depthProperty.set(depth);
    }

    ReadOnlyDoubleProperty currentVerticalGapProperty() {
        return this.currentVerticalGapProperty.getReadOnlyProperty();
    }

    private void expand() {
        this.currentVerticalGapProperty.set(this.verticalGap.get());
    }

    private void collapse() {
        this.currentVerticalGapProperty.set(0.0);
    }

    public final BooleanProperty showTooltipProperty() {
        return this.showTooltip;
    }

    public final boolean isShowTooltip() {
        return this.showTooltipProperty().get();
    }

    public final void setShowTooltip(boolean showTooltip) {
        this.showTooltipProperty().set(showTooltip);
    }

    @Deprecated
    public Node getGroupnode() {
        return (Node)this.groupnode.get();
    }

    @Deprecated
    public void setGroupnode(Node node) {
        this.groupnode.set(node);
    }

    @Deprecated
    public ReadOnlyObjectProperty<Integer> overAllIndexProperty() {
        return this.overAllIndexProperty.getReadOnlyProperty();
    }

    @Deprecated
    void addSublist(JFXListView<?> subList, int index) {
        if (!((ObservableList)this.sublistsProperty.get()).contains(subList)) {
            ((ObservableList)this.sublistsProperty.get()).add(subList);
            this.sublistsIndices.put(index, subList);
            subList.getSelectionModel().selectedIndexProperty().addListener((o, oldVal, newVal) -> {
                if (newVal.intValue() != -1) {
                    this.updateOverAllSelectedIndex();
                }
            });
        }
    }

    private void updateOverAllSelectedIndex() {
        if (this.getSelectionModel().getSelectedIndex() != -1) {
            int selectedIndex = this.getSelectionModel().getSelectedIndex();
            Iterator<Map.Entry<Integer, JFXListView<?>>> itr = this.sublistsIndices.entrySet().iterator();
            int preItemsSize = 0;
            while (itr.hasNext()) {
                Map.Entry<Integer, JFXListView<?>> entry = itr.next();
                if (entry.getKey() >= selectedIndex) continue;
                preItemsSize += entry.getValue().getItems().size() - 1;
            }
            this.overAllIndexProperty.set(selectedIndex + preItemsSize);
        } else {
            Iterator<Map.Entry<Integer, JFXListView<?>>> itr = this.sublistsIndices.entrySet().iterator();
            ArrayList<Integer> selectedList = new ArrayList<Integer>();
            while (itr.hasNext()) {
                Map.Entry<Integer, JFXListView<?>> entry = itr.next();
                if (entry.getValue().getSelectionModel().getSelectedIndex() == -1) continue;
                selectedList.add(entry.getKey());
            }
            if (selectedList.size() > 0) {
                itr = this.sublistsIndices.entrySet().iterator();
                int preItemsSize = 0;
                while (itr.hasNext()) {
                    Map.Entry<Integer, JFXListView<?>> entry = itr.next();
                    if (entry.getKey() >= (Integer)selectedList.get(0)) continue;
                    preItemsSize += entry.getValue().getItems().size() - 1;
                }
                this.overAllIndexProperty.set(preItemsSize + (Integer)selectedList.get(0) + this.sublistsIndices.get(selectedList.get(0)).getSelectionModel().getSelectedIndex());
            } else {
                this.overAllIndexProperty.set(-1);
            }
        }
    }

    private void initialize() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.expanded.addListener((ChangeListener<? super Boolean>)((ChangeListener<Boolean>)(o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.expand();
            } else {
                this.collapse();
            }
        }));
        this.verticalGap.addListener((ChangeListener<? super Number>)((ChangeListener<Number>)(o, oldVal, newVal) -> {
            if (this.isExpanded().booleanValue()) {
                this.expand();
            } else {
                this.collapse();
            }
        }));
        ((ObservableList)this.sublistsProperty.get()).addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded() && !c.wasUpdated() && !c.wasReplaced()) continue;
                if (((ObservableList)this.sublistsProperty.get()).size() == 1) {
                    this.getSelectionModel().selectedItemProperty().addListener((o, oldVal, newVal) -> this.clearSelection(this));
                    this.addEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, Event::consume);
                }
                c.getAddedSubList().forEach(item -> item.getSelectionModel().selectedItemProperty().addListener((o, oldVal, newVal) -> this.clearSelection((JFXListView<?>)item)));
            }
        });
        this.getSelectionModel().selectedIndexProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.intValue() != -1) {
                this.updateOverAllSelectedIndex();
            }
        });
    }

    private void clearSelection(JFXListView<?> selectedList) {
        if (this.allowClear) {
            this.allowClear = false;
            if (this != selectedList) {
                this.getSelectionModel().clearSelection();
            }
            for (int i = 0; i < ((ObservableList)this.sublistsProperty.get()).size(); ++i) {
                if (((ObservableList)this.sublistsProperty.get()).get(i) == selectedList) continue;
                ((JFXListView)((ObservableList)this.sublistsProperty.get()).get(i)).getSelectionModel().clearSelection();
            }
            this.allowClear = true;
        }
    }

    public void propagateMouseEventsToParent() {
        this.addEventHandler(MouseEvent.ANY, (? super T e) -> {
            e.consume();
            this.getParent().fireEvent(e);
        });
    }

    public Double getVerticalGap() {
        return this.verticalGap == null ? 0.0 : this.verticalGap.get();
    }

    public StyleableDoubleProperty verticalGapProperty() {
        return this.verticalGap;
    }

    public void setVerticalGap(Double gap) {
        this.verticalGap.set(gap);
    }

    public Boolean isExpanded() {
        return this.expanded != null && this.expanded.get();
    }

    public StyleableBooleanProperty expandedProperty() {
        return this.expanded;
    }

    public void setExpanded(Boolean expanded) {
        this.expanded.set(expanded);
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXListView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXListView<?>, Number> VERTICAL_GAP = new CssMetaData<JFXListView<?>, Number>("-jfx-vertical-gap", SizeConverter.getInstance(), 0){

            @Override
            public boolean isSettable(JFXListView<?> control) {
                return ((JFXListView)control).verticalGap == null || !((JFXListView)control).verticalGap.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(JFXListView<?> control) {
                return control.verticalGapProperty();
            }
        };
        private static final CssMetaData<JFXListView<?>, Boolean> EXPANDED = new CssMetaData<JFXListView<?>, Boolean>("-jfx-expanded", BooleanConverter.getInstance(), false){

            @Override
            public boolean isSettable(JFXListView<?> control) {
                return control.getHeight() == 0.0 && (((JFXListView)control).expanded == null || !((JFXListView)control).expanded.isBound());
            }

            public StyleableBooleanProperty getStyleableProperty(JFXListView<?> control) {
                return control.expandedProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return VERTICAL_GAP;
        }

        static /* synthetic */ CssMetaData access$100() {
            return EXPANDED;
        }

        static {
            ArrayList styleables = new ArrayList(ListView.getClassCssMetaData());
            Collections.addAll(styleables, VERTICAL_GAP, EXPANDED);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

