/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.cache.CachePolicy;
import com.jfoenix.controls.events.JFXDrawerEvent;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXDrawerKeyValue;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import javafx.util.Duration;

public class JFXDrawer
extends StackPane {
    private List<JFXKeyValue<?>> animatedValues = new ArrayList();
    private HashMap<WritableValue<?>, JFXDrawerKeyValue<?>> initValues = new HashMap();
    private HashMap<WritableValue<?>, Supplier<?>> currentValue = new HashMap();
    private StackPane overlayPane = new StackPane();
    StackPane sidePane = new StackPane();
    private StackPane content = new StackPane();
    private StackPane contentHolder = new StackPane();
    private Region paddingPane = new Region();
    private Duration holdTime = Duration.seconds(0.2);
    private PauseTransition holdTimer = new PauseTransition(this.holdTime);
    private double initOffset = 30.0;
    private DoubleProperty initTranslate = new SimpleDoubleProperty();
    private double activeOffset = 20.0;
    private double startMouse = -1.0;
    private double startTranslate = -1.0;
    private double startSize = -1.0;
    private double contentMinSize = -1.0;
    private boolean openCalled = false;
    private boolean closeCalled = true;
    private DoubleProperty translateProperty = this.sidePane.translateXProperty();
    private DoubleProperty defaultSizeProperty = new SimpleDoubleProperty();
    private DoubleProperty maxSizeProperty = this.sidePane.maxWidthProperty();
    private DoubleProperty prefSizeProperty = this.sidePane.prefWidthProperty();
    private ReadOnlyDoubleProperty sizeProperty = this.sidePane.widthProperty();
    private DoubleProperty paddingSizeProperty = this.paddingPane.minWidthProperty();
    private SimpleObjectProperty<DrawerDirection> directionProperty = new SimpleObjectProperty<DrawerDirection>(DrawerDirection.LEFT);
    final ChangeListener<Number> translateChangeListener = (o, oldVal, newVal) -> {
        if (!this.openCalled && this.closeCalled && ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * newVal.doubleValue() > ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * this.initTranslate.get() / 2.0) {
            this.openCalled = true;
            this.closeCalled = false;
            this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.OPENING));
        } else if (this.openCalled && !this.closeCalled && ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * newVal.doubleValue() < ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * this.initTranslate.get() / 2.0) {
            this.closeCalled = true;
            this.openCalled = false;
            this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.CLOSING));
        }
    };
    private double translateTo = 0.0;
    private double resizeTo = 0.0;
    private DoubleBinding initTranslateBinding;
    private double tempDrawerSize = this.getDefaultDrawerSize();
    private Duration duration;
    private JFXAnimationTimer translateTimer;
    private DoubleProperty miniDrawerSize = new SimpleDoubleProperty(-1.0);
    private ArrayList<Callback<Void, Boolean>> callBacks = new ArrayList();
    private SimpleObjectProperty<CachePolicy> cachePolicy = new SimpleObjectProperty<CachePolicy<Node>>(CachePolicy.NONE);
    private BooleanProperty overLayVisible = new SimpleBooleanProperty(true);
    private boolean resizable = false;
    private boolean resizeContent = false;
    private ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosed = new ObjectPropertyBase<EventHandler<JFXDrawerEvent>>(){

        @Override
        protected void invalidated() {
            JFXDrawer.this.setEventHandler(JFXDrawerEvent.CLOSED, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return JFXDrawer.this;
        }

        @Override
        public String getName() {
            return "onClosed";
        }
    };
    private ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosing = new ObjectPropertyBase<EventHandler<JFXDrawerEvent>>(){

        @Override
        protected void invalidated() {
            JFXDrawer.this.setEventHandler(JFXDrawerEvent.CLOSING, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return JFXDrawer.this;
        }

        @Override
        public String getName() {
            return "onClosing";
        }
    };
    private ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpened = new ObjectPropertyBase<EventHandler<JFXDrawerEvent>>(){

        @Override
        protected void invalidated() {
            JFXDrawer.this.setEventHandler(JFXDrawerEvent.OPENED, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return JFXDrawer.this;
        }

        @Override
        public String getName() {
            return "onOpened";
        }
    };
    private ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpening = new ObjectPropertyBase<EventHandler<JFXDrawerEvent>>(){

        @Override
        protected void invalidated() {
            JFXDrawer.this.setEventHandler(JFXDrawerEvent.OPENING, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return JFXDrawer.this;
        }

        @Override
        public String getName() {
            return "onOpening";
        }
    };
    private EventHandler<MouseEvent> mouseDragHandler = mouseEvent -> {
        if (!mouseEvent.isConsumed()) {
            double sizeLimit;
            mouseEvent.consume();
            if (this.startSize == -1.0) {
                this.startSize = this.sizeProperty.get();
            }
            double directionValue = this.getDirection().doubleValue();
            double eventPoint = this.getDirection() == DrawerDirection.RIGHT || this.getDirection() == DrawerDirection.LEFT ? mouseEvent.getSceneX() : mouseEvent.getSceneY();
            double mouseDiff = this.startTranslate + eventPoint - this.startMouse;
            double d = sizeLimit = this.getDirection() == DrawerDirection.LEFT || this.getDirection() == DrawerDirection.RIGHT ? this.getWidth() : this.getHeight();
            if (directionValue * mouseDiff <= 0.0) {
                if (this.resizable || this.hasMiniSize()) {
                    double newSize = this.startSize + directionValue * mouseDiff;
                    double drawerMinSize = this.hasMiniSize() ? this.getMiniDrawerSize() : this.getDefaultDrawerSize();
                    if (newSize > drawerMinSize) {
                        this.maxSizeProperty.set(newSize);
                        this.prefSizeProperty.set(newSize);
                        double opacity = this.hasMiniSize() ? (newSize - this.getMiniDrawerSize()) / (this.getDefaultDrawerSize() - this.getMiniDrawerSize()) : 1.0 - this.translateProperty.get() / this.initTranslate.get();
                        opacity = opacity > 1.0 ? 1.0 : opacity;
                        opacity = opacity < 0.0 ? 0.0 : opacity;
                        this.overlayPane.setOpacity(opacity);
                        for (JFXKeyValue<?> value : this.animatedValues) {
                            if (!value.isValid()) continue;
                            WritableValue<?> target = value.getTarget();
                            JFXDrawerKeyValue<?> initValue = this.initValues.get(target);
                            target.setValue(value.getInterpolator().interpolate(initValue.getOpenValueSupplier().get(), initValue.getCloseValueSupplier().get(), 1.0 - opacity));
                        }
                        if (this.isResizeContent()) {
                            this.paddingSizeProperty.set(Math.min(newSize, sizeLimit - this.contentMinSize));
                        }
                    } else {
                        this.maxSizeProperty.set(drawerMinSize);
                        double translation = this.hasMiniSize() ? 0.0 : directionValue * (this.startSize - this.getDefaultDrawerSize()) + mouseDiff;
                        this.translateProperty.set(translation);
                        double opacity = this.hasMiniSize() ? (newSize - this.getMiniDrawerSize()) / (this.getDefaultDrawerSize() - this.getMiniDrawerSize()) : 1.0 - this.translateProperty.get() / this.initTranslate.get();
                        opacity = opacity > 1.0 ? 1.0 : opacity;
                        opacity = opacity < 0.0 ? 0.0 : opacity;
                        this.overlayPane.setOpacity(opacity);
                        if (this.isResizeContent()) {
                            this.paddingSizeProperty.set(drawerMinSize + directionValue * translation);
                        }
                    }
                } else {
                    this.translateProperty.set(mouseDiff);
                    this.overlayPane.setOpacity(1.0 - this.translateProperty.get() / this.initTranslate.get());
                    if (this.isResizeContent()) {
                        this.paddingSizeProperty.set(this.getDefaultDrawerSize() + directionValue * mouseDiff);
                    }
                }
            } else {
                if (this.resizable || this.hasMiniSize()) {
                    double newSize = this.startSize + directionValue * mouseDiff;
                    if (newSize <= sizeLimit) {
                        newSize = this.resizable ? newSize : (newSize < this.getDefaultDrawerSize() ? newSize : this.getDefaultDrawerSize());
                        this.maxSizeProperty.set(newSize);
                        this.prefSizeProperty.set(newSize);
                        double opacity = this.hasMiniSize() ? (newSize - this.getMiniDrawerSize()) / (this.getDefaultDrawerSize() - this.getMiniDrawerSize()) : 1.0 - this.translateProperty.get() / this.initTranslate.get();
                        opacity = opacity > 1.0 ? 1.0 : opacity;
                        opacity = opacity < 0.0 ? 0.0 : opacity;
                        this.overlayPane.setOpacity(opacity);
                        for (JFXKeyValue<?> value : this.animatedValues) {
                            if (!value.isValid()) continue;
                            WritableValue<?> target = value.getTarget();
                            JFXDrawerKeyValue<?> initValue = this.initValues.get(target);
                            target.setValue(value.getInterpolator().interpolate(initValue.getCloseValueSupplier().get(), initValue.getOpenValueSupplier().get(), opacity));
                        }
                        if (this.isResizeContent()) {
                            this.paddingSizeProperty.set(Math.min(newSize, sizeLimit - this.contentMinSize));
                        }
                    } else if (this.resizable) {
                        this.maxSizeProperty.set(-1.0);
                        this.prefSizeProperty.set(-1.0);
                    }
                }
                this.translateProperty.set(0.0);
                if (!this.hasMiniSize()) {
                    this.overlayPane.setOpacity(1.0 - this.translateProperty.get() / this.initTranslate.get());
                }
            }
        }
    };
    private EventHandler<MouseEvent> mousePressedHandler = mouseEvent -> {
        this.translateTimer.setOnFinished(null);
        this.translateTimer.stop();
        this.startMouse = this.directionProperty.get() == DrawerDirection.RIGHT || this.directionProperty.get() == DrawerDirection.LEFT ? mouseEvent.getSceneX() : mouseEvent.getSceneY();
        this.startTranslate = this.translateProperty.get();
        this.startSize = this.sizeProperty.get();
        this.contentMinSize = -1.0;
        if (this.isResizeContent()) {
            this.contentMinSize = this.getDirection() == DrawerDirection.LEFT || this.getDirection() == DrawerDirection.RIGHT ? this.content.minWidth(-1.0) : this.content.minHeight(-1.0);
        }
    };
    private EventHandler<MouseEvent> mouseReleasedHandler = mouseEvent -> {
        double direction = ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue();
        if (this.prefSizeProperty.get() != -1.0) {
            this.tryPartialAnimation(direction);
            this.updateTempDrawerSize();
        }
        this.startMouse = -1.0;
        this.startTranslate = -1.0;
        this.startSize = this.sizeProperty.get();
    };
    private static final String DEFAULT_STYLE_CLASS = "jfx-drawer";
    private static final String USER_AGENT_STYLESHEET = JFoenixResources.load("css/controls/jfx-drawer.css").toExternalForm();

    public JFXDrawer() {
        this(Duration.millis(420.0));
    }

    public JFXDrawer(Duration duration) {
        this.initialize();
        this.duration = duration;
        this.translateTimer = this.createDrawerAnimation(duration);
        this.contentHolder.setPickOnBounds(false);
        this.addEventHandler(JFXDrawerEvent.CLOSED, (? super T handler) -> Platform.runLater(() -> this.getCachePolicy().restore(this.contentHolder)));
        this.overlayPane.setBackground(new Background(new BackgroundFill(Color.rgb(0, 0, 0, 0.1), CornerRadii.EMPTY, Insets.EMPTY)));
        this.overlayPane.getStyleClass().add("jfx-drawer-overlay-pane");
        this.overlayPane.setOpacity(0.0);
        this.overlayPane.setMouseTransparent(true);
        this.sidePane.getStyleClass().add("jfx-drawer-side-pane");
        this.sidePane.setBackground(new Background(new BackgroundFill(Color.rgb(255, 255, 255, 1.0), CornerRadii.EMPTY, Insets.EMPTY)));
        this.sidePane.setPickOnBounds(false);
        this.translateTimer.setCacheNodes(this.sidePane);
        this.initListeners();
        this.setDefaultDrawerSize(100.0);
        this.getChildren().setAll((Node[])new Node[]{this.contentHolder, this.overlayPane, this.sidePane});
    }

    private void initialize() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
    }

    private void initListeners() {
        this.initTranslateBinding = Bindings.createDoubleBinding(() -> -1.0 * ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() * this.defaultSizeProperty.getValue() - this.initOffset * ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue(), this.defaultSizeProperty, this.directionProperty);
        this.updateDirection(this.getDirection());
        this.initTranslate.bind(this.initTranslateBinding);
        this.overLayVisibleProperty().addListener(observable -> {
            boolean overLayVisible = this.isOverLayVisible();
            this.overlayPane.setStyle(!overLayVisible ? "-fx-background-color : transparent;" : "");
            this.overlayPane.setPickOnBounds(overLayVisible);
        });
        this.directionProperty.addListener(observable -> this.updateDirection((DrawerDirection)((Object)((Object)this.directionProperty.get()))));
        this.initTranslate.addListener(observable -> this.updateDrawerAnimation(this.initTranslate.get()));
        this.translateProperty.addListener(this.translateChangeListener);
        this.overlayPane.addEventHandler(MouseEvent.MOUSE_CLICKED, (? super T event) -> this.close());
        this.sidePane.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseDragHandler);
        this.sidePane.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseReleasedHandler);
        this.sidePane.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressedHandler);
        this.content.addEventHandler(MouseEvent.MOUSE_PRESSED, (? super T e) -> {
            if (!e.isConsumed()) {
                double size = 0.0;
                long valid = 0L;
                for (int i = 0; i < this.callBacks.size(); ++i) {
                    if (this.callBacks.get(i).call(null).booleanValue()) continue;
                    ++valid;
                }
                DrawerDirection direction = this.getDirection();
                if (direction == DrawerDirection.RIGHT) {
                    size = this.content.getWidth();
                } else if (direction == DrawerDirection.BOTTOM) {
                    size = this.content.getHeight();
                }
                double eventPoint = 0.0;
                eventPoint = direction == DrawerDirection.RIGHT || direction == DrawerDirection.LEFT ? e.getX() : e.getY();
                if (size + direction.doubleValue() * eventPoint < this.activeOffset && (this.content.getCursor() == null || this.content.getCursor() == Cursor.DEFAULT) && valid == 0L && !this.isOpened()) {
                    this.holdTimer.play();
                    e.consume();
                }
            }
        });
        this.content.addEventHandler(MouseEvent.MOUSE_RELEASED, (? super T e) -> {
            this.holdTimer.stop();
            this.content.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDragHandler);
        });
        this.holdTimer.setOnFinished(e -> {
            this.translateTo = this.initTranslate.get() + this.initOffset * ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue() + this.activeOffset * ((DrawerDirection)((Object)((Object)this.directionProperty.get()))).doubleValue();
            this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
            this.translateTimer.setOnFinished(null);
            this.getCachePolicy().cache(this.contentHolder);
            this.translateTimer.start();
        });
    }

    private JFXAnimationTimer createDrawerAnimation(Duration duration) {
        return new JFXAnimationTimer(new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.overlayPane.opacityProperty()).setEndValueSupplier(() -> !this.hasMiniSize() ? 1.0 - this.translateTo / this.initTranslate.get() : (double)(this.resizeTo != this.getMiniDrawerSize() ? 1 : 0)).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.translateProperty).setEndValueSupplier(() -> !this.hasMiniSize() ? this.translateTo : 0.0).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> !this.hasMiniSize() && this.translateTo == this.initTranslate.get()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> !this.hasMiniSize() && this.translateTo == this.initTranslate.get()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.tempDrawerSize).setAnimateCondition(() -> this.translateTo == 0.0 && this.tempDrawerSize > this.getDefaultDrawerSize() && !this.hasMiniSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.tempDrawerSize).setAnimateCondition(() -> this.translateTo == 0.0 && this.tempDrawerSize > this.getDefaultDrawerSize() && !this.hasMiniSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.getMiniDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo <= this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.getMiniDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo <= this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.prefSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo > this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.maxSizeProperty).setEndValueSupplier(() -> this.getDefaultDrawerSize()).setAnimateCondition(() -> this.hasMiniSize() && this.resizeTo > this.getMiniDrawerSize()).setInterpolator(Interpolator.EASE_BOTH).build()), new JFXKeyFrame(duration, JFXKeyValue.builder().setTargetSupplier(() -> this.paddingSizeProperty).setEndValueSupplier(this::computePaddingSize).setAnimateCondition(() -> this.isResizeContent()).setInterpolator(Interpolator.EASE_BOTH).build()));
    }

    private void updateDirection(DrawerDirection dir) {
        this.maxSizeProperty.set(-1.0);
        this.prefSizeProperty.set(-1.0);
        this.translateProperty.set(0.0);
        if (dir == DrawerDirection.LEFT || dir == DrawerDirection.RIGHT) {
            this.translateProperty.removeListener(this.translateChangeListener);
            this.translateProperty = this.sidePane.translateXProperty();
            this.translateProperty.addListener(this.translateChangeListener);
            this.maxSizeProperty = this.sidePane.maxWidthProperty();
            this.prefSizeProperty = this.sidePane.prefWidthProperty();
            this.sizeProperty = this.sidePane.widthProperty();
            this.paddingSizeProperty = this.paddingPane.minWidthProperty();
        } else if (dir == DrawerDirection.TOP || dir == DrawerDirection.BOTTOM) {
            this.translateProperty.removeListener(this.translateChangeListener);
            this.translateProperty = this.sidePane.translateYProperty();
            this.translateProperty.addListener(this.translateChangeListener);
            this.maxSizeProperty = this.sidePane.maxHeightProperty();
            this.prefSizeProperty = this.sidePane.prefHeightProperty();
            this.sizeProperty = this.sidePane.heightProperty();
            this.paddingSizeProperty = this.paddingPane.minHeightProperty();
        }
        if (dir == DrawerDirection.LEFT) {
            StackPane.setAlignment(this.sidePane, Pos.CENTER_LEFT);
        } else if (dir == DrawerDirection.RIGHT) {
            StackPane.setAlignment(this.sidePane, Pos.CENTER_RIGHT);
        } else if (dir == DrawerDirection.TOP) {
            StackPane.setAlignment(this.sidePane, Pos.TOP_CENTER);
        } else if (dir == DrawerDirection.BOTTOM) {
            StackPane.setAlignment(this.sidePane, Pos.BOTTOM_CENTER);
        }
        this.setDefaultDrawerSize(this.getDefaultDrawerSize());
        this.updateDrawerAnimation(this.initTranslate.get());
        this.updateContent();
        this.setMiniDrawerSize(this.getMiniDrawerSize());
    }

    private void updateDrawerAnimation(double translation) {
        this.translateProperty.set(translation);
        this.translateTo = translation;
    }

    private double computePaddingSize() {
        if (!this.isResizeContent()) {
            return 0.0;
        }
        if (this.hasMiniSize()) {
            return this.resizeTo;
        }
        if (this.translateTo == 0.0 && this.tempDrawerSize > this.getDefaultDrawerSize()) {
            return this.tempDrawerSize;
        }
        if (this.translateTo == 0.0) {
            return this.getDefaultDrawerSize();
        }
        if (this.translateTo == this.initTranslate.get()) {
            return 0.0;
        }
        return this.getDefaultDrawerSize() + this.getDirection().doubleValue() * this.translateTo;
    }

    public double getMiniDrawerSize() {
        return this.miniDrawerSize.get();
    }

    public void setMiniDrawerSize(double size) {
        this.miniDrawerSize.set(size);
        if (size > 0.0) {
            this.updateSize(size);
            this.initTranslate.unbind();
            this.initTranslate.set(0.0);
            this.paddingSizeProperty.set(size);
        } else {
            this.updateSize(this.getDefaultDrawerSize());
            this.initTranslate.bind(this.initTranslateBinding);
            this.paddingSizeProperty.set(0.0);
        }
        this.resizeTo = size;
    }

    private boolean hasMiniSize() {
        return this.getMiniDrawerSize() > 0.0;
    }

    public void addInitDrawerCallback(Callback<Void, Boolean> callBack) {
        this.callBacks.add(callBack);
    }

    void bringToFront(Callback<Void, Void> callback) {
        EventHandler<MouseEvent> eventFilter = Event::consume;
        boolean fillSize = this.prefSizeProperty.get() == -1.0;
        this.addEventFilter(MouseEvent.ANY, eventFilter);
        Runnable onFinished = () -> {
            callback.call(null);
            this.translateTo = 0.0;
            this.translateTimer.setOnFinished(() -> {
                if (fillSize) {
                    this.prefSizeProperty.set(-1.0);
                    this.maxSizeProperty.set(-1.0);
                }
                this.removeEventFilter(MouseEvent.ANY, eventFilter);
            });
            this.getCachePolicy().cache(this.contentHolder);
            this.translateTimer.start();
        };
        this.tempDrawerSize = this.sizeProperty.get() > this.getDefaultDrawerSize() ? this.sizeProperty.get() : this.getDefaultDrawerSize();
        this.translateTo = this.initTranslate.get();
        this.translateTimer.setOnFinished(onFinished);
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.start();
    }

    public boolean isOpened() {
        if (this.hasMiniSize()) {
            return this.resizeTo == this.getDefaultDrawerSize() || this.prefSizeProperty.get() >= this.getDefaultDrawerSize();
        }
        return (this.translateTo == 0.0 || this.translateProperty.get() == 0.0) && !this.translateTimer.isRunning();
    }

    public boolean isOpening() {
        boolean condition = this.hasMiniSize() ? this.resizeTo == this.getDefaultDrawerSize() : this.translateTo == 0.0;
        return condition && this.translateTimer.isRunning();
    }

    public boolean isClosing() {
        boolean condition = this.hasMiniSize() ? this.resizeTo == this.getMiniDrawerSize() : this.translateTo == this.initTranslate.get();
        return condition && this.translateTimer.isRunning();
    }

    public boolean isClosed() {
        if (this.hasMiniSize()) {
            return this.resizeTo == this.getMiniDrawerSize();
        }
        return this.translateTo == this.initTranslate.get() && !this.translateTimer.isRunning();
    }

    public void toggle() {
        if (this.isOpened() || this.isOpening()) {
            this.close();
        } else {
            this.open();
        }
    }

    public void open() {
        for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
            this.currentValue.put(entry.getKey(), entry.getValue().getOpenValueSupplier());
        }
        this.translateTo = 0.0;
        this.resizeTo = this.getDefaultDrawerSize();
        this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
        this.translateTimer.setOnFinished(() -> this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.OPENED)));
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.reverseAndContinue();
    }

    public void close() {
        this.translateTimer.setOnFinished(() -> {
            this.overlayPane.setMouseTransparent(true);
            this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.CLOSED));
        });
        if (this.hasMiniSize()) {
            if (this.resizeTo != this.getMiniDrawerSize()) {
                this.resizeTo = this.getMiniDrawerSize();
                for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
                    this.currentValue.put(entry.getKey(), entry.getValue().getCloseValueSupplier());
                }
            }
        } else {
            this.updateTempDrawerSize();
            if (this.translateTo != this.initTranslate.get()) {
                this.translateTo = this.initTranslate.get();
                for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
                    this.currentValue.put(entry.getKey(), entry.getValue().getCloseValueSupplier());
                }
            }
        }
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.reverseAndContinue();
    }

    public ObservableList<Node> getSidePane() {
        return this.sidePane.getChildren();
    }

    public void setSidePane(Node ... sidePane) {
        this.sidePane.getChildren().setAll((Node[])sidePane);
    }

    public ObservableList<Node> getContent() {
        if (this.contentHolder.getChildren().isEmpty()) {
            this.updateContent();
        }
        return this.content.getChildren();
    }

    public void setContent(Node ... content) {
        this.content.getChildren().setAll((Node[])content);
        if (this.contentHolder.getChildren().isEmpty()) {
            this.updateContent();
        }
    }

    private void updateContent() {
        this.paddingPane.setPrefSize(0.0, 0.0);
        this.paddingPane.setMinSize(0.0, 0.0);
        Pane contentNode = this.content;
        switch (this.getDirection()) {
            case TOP: {
                contentNode = new VBox(this.paddingPane, this.content);
                VBox.setVgrow(this.content, Priority.ALWAYS);
                break;
            }
            case BOTTOM: {
                contentNode = new VBox(this.content, this.paddingPane);
                VBox.setVgrow(this.content, Priority.ALWAYS);
                break;
            }
            case LEFT: {
                contentNode = new HBox(this.paddingPane, this.content);
                HBox.setHgrow(this.content, Priority.ALWAYS);
                break;
            }
            case RIGHT: {
                contentNode = new HBox(this.content, this.paddingPane);
                HBox.setHgrow(this.content, Priority.ALWAYS);
            }
        }
        contentNode.setPickOnBounds(false);
        if (this.isOpened()) {
            this.paddingSizeProperty.set(this.computePaddingSize());
        }
        this.contentHolder.getChildren().setAll((Node[])new Node[]{contentNode});
    }

    public double getDefaultDrawerSize() {
        return this.defaultSizeProperty.get();
    }

    public void setDefaultDrawerSize(double size) {
        this.defaultSizeProperty.set(size);
        if (this.getMiniDrawerSize() < 0.0) {
            this.updateSize(size);
        }
    }

    private void updateSize(double size) {
        this.maxSizeProperty.set(size);
        this.prefSizeProperty.set(size);
    }

    public DrawerDirection getDirection() {
        return (DrawerDirection)((Object)this.directionProperty.get());
    }

    public SimpleObjectProperty<DrawerDirection> directionProperty() {
        return this.directionProperty;
    }

    public void setDirection(DrawerDirection direction) {
        this.directionProperty.set(direction);
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy.get() == null ? CachePolicy.NONE : (CachePolicy)this.cachePolicy.get();
    }

    public SimpleObjectProperty<CachePolicy> cachePolicyProperty() {
        return this.cachePolicy;
    }

    public void setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy.set(cachePolicy);
    }

    public final BooleanProperty overLayVisibleProperty() {
        return this.overLayVisible;
    }

    public final boolean isOverLayVisible() {
        return this.overLayVisibleProperty().get();
    }

    public final void setOverLayVisible(boolean overLayVisible) {
        this.overLayVisibleProperty().set(overLayVisible);
    }

    public boolean isResizableOnDrag() {
        return this.resizable;
    }

    public void setResizableOnDrag(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isResizeContent() {
        return this.resizeContent;
    }

    public void setResizeContent(boolean resizeContent) {
        this.resizeContent = resizeContent;
        this.translateTimer.reverseAndContinue();
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerClosed() {
        return (EventHandler)this.onDrawerClosedProperty().get();
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosedProperty() {
        return this.onDrawerClosed;
    }

    public void setOnDrawerClosed(EventHandler<JFXDrawerEvent> onDrawerClosed) {
        this.onDrawerClosedProperty().set(onDrawerClosed);
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerClosing() {
        return (EventHandler)this.onDrawerClosing.get();
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerClosingProperty() {
        return this.onDrawerClosing;
    }

    public void setOnDrawerClosing(EventHandler<JFXDrawerEvent> onDrawerClosing) {
        this.onDrawerClosing.set(onDrawerClosing);
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerOpened() {
        return (EventHandler)this.onDrawerOpened.get();
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpenedProperty() {
        return this.onDrawerOpened;
    }

    public void setOnDrawerOpened(EventHandler<JFXDrawerEvent> onDrawerOpened) {
        this.onDrawerOpened.set(onDrawerOpened);
    }

    public EventHandler<JFXDrawerEvent> getOnDrawerOpening() {
        return (EventHandler)this.onDrawerOpening.get();
    }

    public ObjectProperty<EventHandler<JFXDrawerEvent>> onDrawerOpeningProperty() {
        return this.onDrawerOpening;
    }

    public void setOnDrawerOpening(EventHandler<JFXDrawerEvent> onDrawerOpening) {
        this.onDrawerOpening.set(onDrawerOpening);
    }

    private void updateTempDrawerSize() {
        this.tempDrawerSize = this.sizeProperty.get() > this.getDefaultDrawerSize() ? this.prefSizeProperty.get() : this.getDefaultDrawerSize();
    }

    private void tryPartialAnimation(double direction) {
        if (this.hasMiniSize()) {
            if (this.prefSizeProperty.get() > (this.getMiniDrawerSize() + this.getDefaultDrawerSize()) / 2.0 && this.prefSizeProperty.get() < this.getDefaultDrawerSize()) {
                this.partialOpen();
            } else if (this.prefSizeProperty.get() <= (this.getMiniDrawerSize() + this.getDefaultDrawerSize()) / 2.0) {
                this.partialClose();
            } else if (this.prefSizeProperty.get() >= this.getDefaultDrawerSize()) {
                this.resizeTo = this.getDefaultDrawerSize();
                this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
            }
        } else if (direction * this.translateProperty.get() > direction * this.initTranslate.get() / 2.0) {
            if (this.translateProperty.get() != 0.0) {
                this.partialOpen();
            }
        } else if (this.translateProperty.get() != this.initTranslate.get()) {
            this.partialClose();
        }
    }

    private void partialClose() {
        for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
            this.currentValue.put(entry.getKey(), entry.getValue().getCloseValueSupplier());
        }
        this.translateTo = this.initTranslate.get();
        this.resizeTo = this.getMiniDrawerSize();
        this.translateTimer.setOnFinished(() -> {
            this.overlayPane.setMouseTransparent(true);
            this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.CLOSED));
        });
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.start();
    }

    private void partialOpen() {
        for (Map.Entry<WritableValue<?>, JFXDrawerKeyValue<?>> entry : this.initValues.entrySet()) {
            this.currentValue.put(entry.getKey(), entry.getValue().getOpenValueSupplier());
        }
        this.translateTo = 0.0;
        this.resizeTo = this.tempDrawerSize = this.getDefaultDrawerSize();
        this.overlayPane.setMouseTransparent(!this.isOverLayVisible());
        this.translateTimer.setOnFinished(() -> this.fireEvent(new JFXDrawerEvent(JFXDrawerEvent.OPENED)));
        this.getCachePolicy().cache(this.contentHolder);
        this.translateTimer.start();
    }

    public <T> void addAnimatedKeyValue(Node node, JFXDrawerKeyValue ... values) {
        this.addAnimatedKeyValue(node, Arrays.asList(values));
    }

    public void addAnimatedKeyValue(Node node, List<JFXDrawerKeyValue<?>> values) {
        ArrayList<JFXKeyValue<Object>> modifiedValues = new ArrayList<JFXKeyValue<Object>>();
        for (JFXDrawerKeyValue<?> value : values) {
            JFXKeyValue<Object> modifiedValue = JFXKeyValue.builder().setEndValueSupplier(() -> this.currentValue.get(value.getTarget()).get()).setAnimateCondition(() -> node.getScene() != null && value.isValid()).setTargetSupplier(() -> value.getTarget()).setInterpolator(value.getInterpolator()).build();
            modifiedValues.add(modifiedValue);
            this.currentValue.put(value.getTarget(), this.isClosed() ? value.getCloseValueSupplier() : value.getOpenValueSupplier());
            this.initValues.put(value.getTarget(), value);
        }
        this.animatedValues.addAll(modifiedValues);
        JFXKeyFrame keyFrame = new JFXKeyFrame(this.duration, modifiedValues.toArray(new JFXKeyValue[0]));
        try {
            this.translateTimer.addKeyFrame(keyFrame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    public static enum DrawerDirection {
        LEFT(1.0),
        RIGHT(-1.0),
        TOP(1.0),
        BOTTOM(-1.0);

        private double numVal;

        private DrawerDirection(double numVal) {
            this.numVal = numVal;
        }

        public double doubleValue() {
            return this.numVal;
        }
    }
}

