/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class JFXDialogLayout
extends VBox {
    private StackPane heading = new StackPane();
    private StackPane body = new StackPane();
    private FlowPane actions = new FlowPane();
    private static final String DEFAULT_STYLE_CLASS = "jfx-dialog-layout";

    public JFXDialogLayout() {
        this.initialize();
        this.heading.getStyleClass().addAll((String[])new String[]{"jfx-layout-heading", "title"});
        this.body.getStyleClass().add("jfx-layout-body");
        VBox.setVgrow(this.body, Priority.ALWAYS);
        this.actions.getStyleClass().add("jfx-layout-actions");
        this.getChildren().setAll((Node[])new Node[]{this.heading, this.body, this.actions});
    }

    public ObservableList<Node> getHeading() {
        return this.heading.getChildren();
    }

    public void setHeading(Node ... titleContent) {
        this.heading.getChildren().setAll((Node[])titleContent);
    }

    public ObservableList<Node> getBody() {
        return this.body.getChildren();
    }

    public void setBody(Node ... body) {
        this.body.getChildren().setAll((Node[])body);
    }

    public ObservableList<Node> getActions() {
        return this.actions.getChildren();
    }

    public void setActions(Node ... actions) {
        this.actions.getChildren().setAll((Node[])actions);
    }

    public void setActions(List<? extends Node> actions) {
        this.actions.getChildren().setAll((Collection<Node>)actions);
    }

    @Override
    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-dialog-layout.css").toExternalForm();
    }

    private void initialize() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
    }
}

