/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXAutoCompletePopup;
import com.jfoenix.controls.JFXChip;
import com.jfoenix.skins.JFXChipViewSkin;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class JFXChipView<T>
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "jfx-chip-view";
    private ObjectProperty<BiFunction<JFXChipView<T>, T, JFXChip<T>>> chipFactory;
    private ObjectProperty<Function<T, T>> selectionHandler;
    private StringProperty promptText = new SimpleStringProperty(this, "promptText", "");
    private JFXAutoCompletePopup<T> autoCompletePopup = new JFXChipViewSkin.ChipsAutoComplete();
    private ObjectProperty<BiPredicate<T, String>> predicate = new SimpleObjectProperty<BiPredicate<Object, String>>((item, text) -> {
        StringConverter<Object> converter = this.getConverter();
        String itemString = converter != null ? converter.toString(item) : item.toString();
        return itemString.toLowerCase().contains(text.toLowerCase());
    });
    private ObservableList<T> chips = FXCollections.observableArrayList();
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<StringConverter<T>>>(this, "converter", JFXChipView.defaultStringConverter());

    private static <T> StringConverter<T> defaultStringConverter() {
        return new StringConverter<T>(){

            @Override
            public String toString(T t) {
                return t == null ? null : t.toString();
            }

            @Override
            public T fromString(String string) {
                return string;
            }
        };
    }

    public JFXChipView() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
    }

    @Override
    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-chip-view.css").toExternalForm();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new JFXChipViewSkin(this);
    }

    public BiFunction<JFXChipView<T>, T, JFXChip<T>> getChipFactory() {
        return this.chipFactory == null ? null : (BiFunction)this.chipFactory.get();
    }

    public ObjectProperty<BiFunction<JFXChipView<T>, T, JFXChip<T>>> chipFactoryProperty() {
        if (this.chipFactory == null) {
            this.chipFactory = new SimpleObjectProperty<BiFunction<JFXChipView<T>, T, JFXChip<T>>>(this, "chipFactory");
        }
        return this.chipFactory;
    }

    public void setChipFactory(BiFunction<JFXChipView<T>, T, JFXChip<T>> chipFactory) {
        this.chipFactoryProperty().set(chipFactory);
    }

    public Function<T, T> getSelectionHandler() {
        return this.selectionHandler == null ? null : (Function)this.selectionHandler.get();
    }

    public ObjectProperty<Function<T, T>> selectionHandlerProperty() {
        if (this.selectionHandler == null) {
            this.selectionHandler = new SimpleObjectProperty<Function<T, T>>(this, "selectionHandler");
        }
        return this.selectionHandler;
    }

    public void setSelectionHandler(Function<T, T> selectionHandler) {
        this.selectionHandlerProperty().set(selectionHandler);
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final void setPromptText(String value) {
        this.promptText.set(value);
    }

    public JFXAutoCompletePopup<T> getAutoCompletePopup() {
        return this.autoCompletePopup;
    }

    public ObservableList<T> getSuggestions() {
        return this.autoCompletePopup.getSuggestions();
    }

    public void setSuggestionsCellFactory(Callback<ListView<T>, ListCell<T>> factory) {
        this.autoCompletePopup.setSuggestionsCellFactory(factory);
    }

    public BiPredicate<T, String> getPredicate() {
        return (BiPredicate)this.predicate.get();
    }

    public ObjectProperty<BiPredicate<T, String>> predicateProperty() {
        return this.predicate;
    }

    public void setPredicate(BiPredicate<T, String> predicate) {
        this.predicate.set(predicate);
    }

    public ObservableList<T> getChips() {
        return this.chips;
    }

    public ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }
}

