/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.skins.JFXCheckBoxSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JFXCheckBox
extends CheckBox {
    private static final String DEFAULT_STYLE_CLASS = "jfx-check-box";
    private static final String USER_AGENT_STYLESHEET = JFoenixResources.load("css/controls/jfx-check-box.css").toExternalForm();
    private StyleableObjectProperty<Paint> checkedColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$000(), this, "checkedColor", Color.valueOf("#0F9D58"));
    private StyleableObjectProperty<Paint> unCheckedColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.access$100(), this, "unCheckedColor", Color.valueOf("#5A5A5A"));
    private StyleableBooleanProperty disableVisualFocus = new SimpleStyleableBooleanProperty(StyleableProperties.access$200(), this, "disableVisualFocus", false);

    public JFXCheckBox(String text) {
        super(text);
        this.initialize();
    }

    public JFXCheckBox() {
        this.initialize();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElements.length && i < 15; ++i) {
            if (!stackTraceElements[i].getClassName().toLowerCase().contains(".scenebuilder.kit.fxom.")) continue;
            this.setText("CheckBox");
            break;
        }
    }

    private void initialize() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new JFXCheckBoxSkin(this);
    }

    @Override
    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    public Paint getCheckedColor() {
        return this.checkedColor == null ? Color.valueOf("#0F9D58") : (Paint)this.checkedColor.get();
    }

    public StyleableObjectProperty<Paint> checkedColorProperty() {
        return this.checkedColor;
    }

    public void setCheckedColor(Paint color) {
        this.checkedColor.set(color);
    }

    public Paint getUnCheckedColor() {
        return this.unCheckedColor == null ? Color.valueOf("#5A5A5A") : (Paint)this.unCheckedColor.get();
    }

    public StyleableObjectProperty<Paint> unCheckedColorProperty() {
        return this.unCheckedColor;
    }

    public void setUnCheckedColor(Paint color) {
        this.unCheckedColor.set(color);
    }

    public final StyleableBooleanProperty disableVisualFocusProperty() {
        return this.disableVisualFocus;
    }

    public final Boolean isDisableVisualFocus() {
        return this.disableVisualFocus != null && this.disableVisualFocusProperty().get();
    }

    public final void setDisableVisualFocus(Boolean disabled) {
        this.disableVisualFocusProperty().set(disabled);
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXCheckBox.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXCheckBox, Paint> CHECKED_COLOR = new CssMetaData<JFXCheckBox, Paint>("-jfx-checked-color", PaintConverter.getInstance(), (Paint)Color.valueOf("#0F9D58")){

            @Override
            public boolean isSettable(JFXCheckBox control) {
                return control.checkedColor == null || !control.checkedColor.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(JFXCheckBox control) {
                return control.checkedColorProperty();
            }
        };
        private static final CssMetaData<JFXCheckBox, Paint> UNCHECKED_COLOR = new CssMetaData<JFXCheckBox, Paint>("-jfx-unchecked-color", PaintConverter.getInstance(), (Paint)Color.valueOf("#5A5A5A")){

            @Override
            public boolean isSettable(JFXCheckBox control) {
                return control.unCheckedColor == null || !control.unCheckedColor.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(JFXCheckBox control) {
                return control.unCheckedColorProperty();
            }
        };
        private static final CssMetaData<JFXCheckBox, Boolean> DISABLE_VISUAL_FOCUS = new CssMetaData<JFXCheckBox, Boolean>("-jfx-disable-visual-focus", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(JFXCheckBox control) {
                return control.disableVisualFocus == null || !control.disableVisualFocus.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXCheckBox control) {
                return control.disableVisualFocusProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return CHECKED_COLOR;
        }

        static /* synthetic */ CssMetaData access$100() {
            return UNCHECKED_COLOR;
        }

        static /* synthetic */ CssMetaData access$200() {
            return DISABLE_VISUAL_FOCUS;
        }

        static {
            ArrayList styleables = new ArrayList(CheckBox.getClassCssMetaData());
            Collections.addAll(styleables, CHECKED_COLOR, UNCHECKED_COLOR, DISABLE_VISUAL_FOCUS);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

