/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import javafx.animation.FadeTransition;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

@DefaultProperty(value="control")
public class JFXBadge
extends StackPane {
    private Group badge;
    protected Node control;
    private boolean enabled = true;
    private static final String DEFAULT_STYLE_CLASS = "jfx-badge";
    protected ObjectProperty<Pos> position = new SimpleObjectProperty<Pos>();
    private SimpleStringProperty text = new SimpleStringProperty();

    public JFXBadge() {
        this((Node)null);
    }

    public JFXBadge(Node control) {
        this(control, Pos.TOP_RIGHT);
    }

    public JFXBadge(Node control, Pos pos) {
        this.initialize();
        this.setPosition(pos);
        this.setControl(control);
        this.position.addListener((o, oldVal, newVal) -> StackPane.setAlignment(this.badge, newVal));
    }

    public void setControl(Node control) {
        if (control != null) {
            this.control = control;
            this.badge = new Group();
            this.getChildren().add(control);
            this.getChildren().add(this.badge);
            if (control instanceof Region) {
                ((Region)control).widthProperty().addListener((o, oldVal, newVal) -> this.refreshBadge());
                ((Region)control).heightProperty().addListener((o, oldVal, newVal) -> this.refreshBadge());
            }
            this.text.addListener((ChangeListener<? super String>)((ChangeListener<String>)(o, oldVal, newVal) -> this.refreshBadge()));
        }
    }

    public Node getControl() {
        return this.control;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void refreshBadge() {
        this.badge.getChildren().clear();
        if (this.enabled) {
            Label labelControl = new Label(this.text.getValue());
            StackPane badgePane = new StackPane();
            badgePane.getStyleClass().add("badge-pane");
            badgePane.getChildren().add(labelControl);
            this.badge.getChildren().add(badgePane);
            StackPane.setAlignment(this.badge, this.getPosition());
            FadeTransition ft = new FadeTransition(Duration.millis(666.0), this.badge);
            ft.setFromValue(0.0);
            ft.setToValue(1.0);
            ft.setCycleCount(1);
            ft.setAutoReverse(true);
            ft.play();
        }
    }

    private void initialize() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
    }

    public Pos getPosition() {
        return this.position == null ? Pos.TOP_RIGHT : (Pos)((Object)this.position.get());
    }

    public ObjectProperty<Pos> positionProperty() {
        return this.position;
    }

    public void setPosition(Pos position) {
        this.position.set(position);
    }

    public final String getText() {
        return this.text.get();
    }

    public final void setText(String value) {
        this.text.set(value);
    }

    public final StringProperty textProperty() {
        return this.text;
    }
}

