/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.events.JFXAutoCompleteEvent;
import com.jfoenix.skins.JFXAutoCompletePopupSkin;
import com.sun.javafx.stage.PopupWindowHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.stage.Window;
import javafx.util.Callback;

public class JFXAutoCompletePopup<T>
extends PopupControl {
    private final ObservableList<T> suggestions = FXCollections.observableArrayList();
    private final ObjectProperty<EventHandler<JFXAutoCompleteEvent<T>>> selectionHandler = new SimpleObjectProperty<EventHandler<JFXAutoCompleteEvent<T>>>();
    private final FilteredList<T> filteredData = new FilteredList<Object>(this.suggestions, s -> true);
    private final ObjectProperty<Callback<ListView<T>, ListCell<T>>> suggestionsCellFactory = new SimpleObjectProperty<Callback<ListView<T>, ListCell<T>>>();
    private static final String DEFAULT_STYLE_CLASS = "jfx-autocomplete-popup";
    private IntegerProperty cellLimit = new SimpleStyleableIntegerProperty(StyleableProperties.access$000(), this, "cellLimit", 10);
    private DoubleProperty fixedCellSize = new SimpleStyleableDoubleProperty(StyleableProperties.access$100(), this, "fixedCellSize", 24.0);

    public JFXAutoCompletePopup() {
        this.bridge = new CSSBridge();
        PopupWindowHelper.getContent(this).setAll((Node[])new Node[]{this.bridge});
        this.setAutoFix(true);
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new JFXAutoCompletePopupSkin(this);
    }

    public void show(Node node) {
        if (!this.isShowing()) {
            if (node.getScene() == null || node.getScene().getWindow() == null) {
                throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
            }
            Window parent = node.getScene().getWindow();
            this.show(parent, parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + ((Region)node).getHeight());
            ((JFXAutoCompletePopupSkin)this.getSkin()).animate();
        }
    }

    public ObservableList<T> getSuggestions() {
        return this.suggestions;
    }

    public void filter(Predicate<T> predicate) {
        this.filteredData.setPredicate(predicate);
    }

    public ObservableList<T> getFilteredSuggestions() {
        return this.filteredData;
    }

    public EventHandler<JFXAutoCompleteEvent<T>> getSelectionHandler() {
        return (EventHandler)this.selectionHandler.get();
    }

    public void setSelectionHandler(EventHandler<JFXAutoCompleteEvent<T>> selectionHandler) {
        this.selectionHandler.set(selectionHandler);
    }

    public final ObjectProperty<Callback<ListView<T>, ListCell<T>>> suggestionsCellFactoryProperty() {
        return this.suggestionsCellFactory;
    }

    public final Callback<ListView<T>, ListCell<T>> getSuggestionsCellFactory() {
        return (Callback)this.suggestionsCellFactoryProperty().get();
    }

    public final void setSuggestionsCellFactory(Callback<ListView<T>, ListCell<T>> suggestionsCellFactory) {
        this.suggestionsCellFactoryProperty().set(suggestionsCellFactory);
    }

    public final void setCellLimit(int value) {
        this.cellLimitProperty().set(value);
    }

    public final int getCellLimit() {
        return this.cellLimitProperty().get();
    }

    public final IntegerProperty cellLimitProperty() {
        return this.cellLimit;
    }

    public final void setFixedCellSize(double value) {
        this.fixedCellSizeProperty().set(value);
    }

    public final double getFixedCellSize() {
        return this.fixedCellSizeProperty().get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        return this.fixedCellSize;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXAutoCompletePopup.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<CSSBridge, Number> FIXED_CELL_SIZE = new CssMetaData<CSSBridge, Number>("-fx-fixed-cell-size", SizeConverter.getInstance(), (Number)24){

            @Override
            public Double getInitialValue(CSSBridge bridge) {
                return bridge.popup.getFixedCellSize();
            }

            @Override
            public boolean isSettable(CSSBridge bridge) {
                return bridge.popup.fixedCellSize == null || !bridge.popup.fixedCellSize.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(CSSBridge bridge) {
                return (StyleableProperty)((Object)bridge.popup.fixedCellSizeProperty());
            }
        };
        private static final CssMetaData<CSSBridge, Number> CELL_LIMIT = new CssMetaData<CSSBridge, Number>("-jfx-cell-limit", SizeConverter.getInstance(), (Number)10){

            @Override
            public Number getInitialValue(CSSBridge bridge) {
                return bridge.popup.getCellLimit();
            }

            @Override
            public boolean isSettable(CSSBridge bridge) {
                return bridge.popup.cellLimit == null || !bridge.popup.cellLimit.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(CSSBridge bridge) {
                return (StyleableProperty)((Object)bridge.popup.cellLimitProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return CELL_LIMIT;
        }

        static /* synthetic */ CssMetaData access$100() {
            return FIXED_CELL_SIZE;
        }

        static {
            ArrayList styleables = new ArrayList(PopupControl.getClassCssMetaData());
            styleables.add(FIXED_CELL_SIZE);
            styleables.add(CELL_LIMIT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private final class CSSBridge
    extends PopupControl.CSSBridge {
        private JFXAutoCompletePopup popup;

        CSSBridge() {
            super(JFXAutoCompletePopup.this);
            this.popup = JFXAutoCompletePopup.this;
        }
    }
}

