/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.animation.alert.JFXAlertAnimation;
import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.effects.JFXDepthManager;
import com.sun.javafx.event.EventHandlerManager;
import java.util.List;
import javafx.animation.Animation;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.DialogPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class JFXAlert<R>
extends Dialog<R> {
    private final StackPane contentContainer;
    private InvalidationListener widthListener;
    private InvalidationListener heightListener;
    private InvalidationListener xListener;
    private InvalidationListener yListener;
    private boolean animateClosing = true;
    private Animation transition = null;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private BooleanProperty overlayClose = new SimpleBooleanProperty(true);
    private ObjectProperty<JFXAlertAnimation> animation = new SimpleObjectProperty<JFXAlertAnimation>(JFXAlertAnimation.CENTER_ANIMATION);
    private BooleanProperty hideOnEscape = new SimpleBooleanProperty(this, "hideOnEscape", true);

    public JFXAlert() {
        this(null);
    }

    public JFXAlert(Window window) {
        this.contentContainer = new StackPane();
        this.contentContainer.getStyleClass().add("jfx-alert-content-container");
        Node materialNode = JFXDepthManager.createMaterialNode(this.contentContainer, 2);
        materialNode.setPickOnBounds(false);
        materialNode.addEventHandler(MouseEvent.MOUSE_CLICKED, Event::consume);
        DialogPane dialogPane = new DialogPane(){
            private boolean performingLayout = false;
            {
                this.getButtonTypes().add(ButtonType.CLOSE);
                Node closeButton = this.lookupButton(ButtonType.CLOSE);
                closeButton.managedProperty().bind(closeButton.visibleProperty());
                closeButton.setVisible(false);
            }

            @Override
            protected double computePrefHeight(double width) {
                Window owner = JFXAlert.this.getOwner();
                if (owner != null) {
                    return owner.getHeight();
                }
                return super.computePrefHeight(width);
            }

            @Override
            protected double computePrefWidth(double height) {
                Window owner = JFXAlert.this.getOwner();
                if (owner != null) {
                    return owner.getWidth();
                }
                return super.computePrefWidth(height);
            }

            @Override
            public void requestLayout() {
                if (this.performingLayout) {
                    return;
                }
                super.requestLayout();
            }

            @Override
            protected void layoutChildren() {
                this.performingLayout = true;
                List managed = this.getManagedChildren();
                double width = this.getWidth();
                double height = this.getHeight();
                double top = this.getInsets().getTop();
                double right = this.getInsets().getRight();
                double left = this.getInsets().getLeft();
                double bottom = this.getInsets().getBottom();
                double contentWidth = width - left - right;
                double contentHeight = height - top - bottom;
                for (Node child : managed) {
                    this.layoutInArea(child, left, top, contentWidth, contentHeight, 0.0, Insets.EMPTY, HPos.CENTER, VPos.CENTER);
                }
                this.performingLayout = false;
            }

            @Override
            public String getUserAgentStylesheet() {
                return JFoenixResources.load("css/controls/jfx-alert.css").toExternalForm();
            }

            @Override
            protected Node createButtonBar() {
                return null;
            }
        };
        dialogPane.getStyleClass().add("jfx-alert-overlay");
        dialogPane.setContent(materialNode);
        this.setDialogPane(dialogPane);
        dialogPane.getScene().setFill(Color.TRANSPARENT);
        if (window != null) {
            this.initStyle(StageStyle.TRANSPARENT);
            this.initOwner(window);
            dialogPane.addEventHandler(MouseEvent.MOUSE_CLICKED, (? super T event) -> {
                if (this.isOverlayClose()) {
                    this.hide();
                }
            });
            this.widthListener = observable -> this.updateWidth();
            this.heightListener = observable -> this.updateHeight();
            this.xListener = observable -> this.updateX();
            this.yListener = observable -> this.updateY();
        }
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_SHOWING, (? super T event) -> {
            this.addLayoutListeners();
            JFXAlertAnimation currentAnimation = this.getCurrentAnimation();
            currentAnimation.initAnimation(this.contentContainer.getParent(), dialogPane);
        });
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_SHOWN, (? super T event) -> {
            if (this.getOwner() != null) {
                this.updateLayout();
            }
            this.animateClosing = true;
            JFXAlertAnimation currentAnimation = this.getCurrentAnimation();
            Animation animation = currentAnimation.createShowingAnimation(dialogPane.getContent(), dialogPane);
            if (animation != null) {
                animation.play();
            }
        });
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_CLOSE_REQUEST, (? super T event) -> {
            if (this.animateClosing) {
                event.consume();
                this.hideWithAnimation();
            }
        });
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_HIDDEN, (? super T event) -> this.removeLayoutListeners());
        this.getDialogPane().getScene().getWindow().addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE && !this.isHideOnEscape()) {
                keyEvent.consume();
            }
        });
    }

    private JFXAlertAnimation getCurrentAnimation() {
        JFXAlertAnimation usedAnimation = this.getAnimation();
        usedAnimation = usedAnimation == null ? JFXAlertAnimation.NO_ANIMATION : usedAnimation;
        return usedAnimation;
    }

    private void removeLayoutListeners() {
        Window stage = this.getOwner();
        if (stage != null) {
            stage.getScene().widthProperty().removeListener(this.widthListener);
            stage.getScene().heightProperty().removeListener(this.heightListener);
            stage.xProperty().removeListener(this.xListener);
            stage.yProperty().removeListener(this.yListener);
        }
    }

    private void addLayoutListeners() {
        Window stage = this.getOwner();
        if (stage != null) {
            if (this.widthListener == null) {
                throw new RuntimeException("Owner can only be set using the constructor");
            }
            stage.getScene().widthProperty().addListener(this.widthListener);
            stage.getScene().heightProperty().addListener(this.heightListener);
            stage.xProperty().addListener(this.xListener);
            stage.yProperty().addListener(this.yListener);
        }
    }

    private void updateLayout() {
        this.updateX();
        this.updateY();
        this.updateWidth();
        this.updateHeight();
    }

    private void updateHeight() {
        Window stage = this.getOwner();
        this.setHeight(stage.getScene().getHeight());
    }

    private void updateWidth() {
        Window stage = this.getOwner();
        this.setWidth(stage.getScene().getWidth());
    }

    private void updateY() {
        Window stage = this.getOwner();
        this.setY(stage.getY() + stage.getScene().getY());
    }

    private void updateX() {
        Window stage = this.getOwner();
        this.setX(stage.getX() + stage.getScene().getX());
    }

    public void hideWithAnimation() {
        if (this.transition == null || this.transition.getStatus().equals((Object)Animation.Status.STOPPED)) {
            JFXAlertAnimation currentAnimation = this.getCurrentAnimation();
            Animation animation = currentAnimation.createHidingAnimation(this.getDialogPane().getContent(), this.getDialogPane());
            if (animation != null) {
                this.transition = animation;
                animation.setOnFinished(finish -> {
                    this.animateClosing = false;
                    this.hide();
                    this.transition = null;
                });
                animation.play();
            } else {
                this.animateClosing = false;
                this.transition = null;
                Platform.runLater(this::hide);
            }
        }
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return super.buildEventDispatchChain(tail).prepend(this.eventHandlerManager);
    }

    public void setContent(Node ... content) {
        this.contentContainer.getChildren().setAll((Node[])content);
    }

    public boolean isOverlayClose() {
        return this.overlayClose.get();
    }

    public BooleanProperty overlayCloseProperty() {
        return this.overlayClose;
    }

    public void setOverlayClose(boolean overlayClose) {
        this.overlayClose.set(overlayClose);
    }

    public JFXAlertAnimation getAnimation() {
        return (JFXAlertAnimation)this.animation.get();
    }

    public ObjectProperty<JFXAlertAnimation> animationProperty() {
        return this.animation;
    }

    public void setAnimation(JFXAlertAnimation animation) {
        this.animation.set(animation);
    }

    public void setSize(double prefWidth, double prefHeight) {
        this.contentContainer.setPrefSize(prefWidth, prefHeight);
    }

    public final void setHideOnEscape(boolean value) {
        this.hideOnEscape.set(value);
    }

    public final boolean isHideOnEscape() {
        return this.hideOnEscape.get();
    }

    public final BooleanProperty hideOnEscapeProperty() {
        return this.hideOnEscape;
    }
}

