/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.freetts.mbrola;

import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.audio.AudioPlayer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public class MbrolaAudioOutput
implements UtteranceProcessor {
    private static final Logger LOGGER = Logger.getLogger(MbrolaAudioOutput.class.getName());
    private static final AudioFormat MBROLA_AUDIO = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN);

    public void processUtterance(Utterance utterance) throws ProcessException {
        int totalSize;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("=== " + utterance.getString("input_text"));
        }
        AudioPlayer audioPlayer = utterance.getVoice().getAudioPlayer();
        audioPlayer.setAudioFormat(MBROLA_AUDIO);
        audioPlayer.setVolume(utterance.getVoice().getVolume());
        List audioData = (List)utterance.getObject("mbrolaAudio");
        if (audioData == null) {
            throw new ProcessException("No \"mbrolaAudio\" object is associated with utterance");
        }
        try {
            totalSize = utterance.getInt("mbrolaAudioLength");
        }
        catch (NullPointerException npe) {
            totalSize = 0;
        }
        audioPlayer.begin(totalSize);
        Iterator it = audioData.iterator();
        while (it.hasNext()) {
            byte[] bytes = (byte[])it.next();
            if (audioPlayer.write(bytes)) continue;
            throw new ProcessException("Cannot write audio data to audio player");
        }
        if (!audioPlayer.end()) {
            throw new ProcessException("audio player reports problem");
        }
    }

    public String toString() {
        return "MbrolaAudioOutput";
    }
}

