/*
 * Decompiled with CFR 0.152.
 */
package panda;

import javax.swing.SwingUtilities;
import panda.Formula;
import panda.PandaVoice;
import panda.ProofFormulaNode;
import panda.ProofFormulaNodeNatDet;
import panda.ProofPanel;

public class VoiceTopDown
extends Thread {
    private final ProofPanel panel;

    VoiceTopDown(ProofPanel panel) {
        this.panel = panel;
    }

    public void run() {
        this.speak(this.panel.getSelectedNode());
    }

    private void selectNode(final ProofFormulaNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VoiceTopDown.this.panel.setNodeSelected(node);
                VoiceTopDown.this.panel.repaint();
            }
        });
    }

    private void speakToProveAWehaveToProve(Formula formula) {
        int i = (int)Math.floor(Math.random() * 4.0 % 4.0);
        switch (i) {
            case 0: {
                PandaVoice.speak("In order to prove " + formula + ", we are going to prove ");
                break;
            }
            case 1: {
                PandaVoice.speak("Our aim is " + formula + ". For that we prove ");
                break;
            }
            case 2: {
                PandaVoice.speak("I want to prove " + formula + ". So I have constructed a proof for ");
                break;
            }
            default: {
                PandaVoice.speak("This is a proof tree of " + formula + " because we give proof of ");
            }
        }
    }

    private void speak(ProofFormulaNodeNatDet node) {
        this.selectNode(node);
        if (node.isHypothesePrincipale()) {
            PandaVoice.speak(node.getFormula() + " is an global hypothesis.");
        } else if (node.isHypotheseTemporaire()) {
            PandaVoice.speak(node.getFormula() + " is an temporary hypothesis.");
        } else if (node.isRuleEliminationOr()) {
            this.speakToProveAWehaveToProve(node.getFormula());
            this.selectNode(node.getChild(0));
            PandaVoice.speak(node.getChild(0).getFormula().toString());
            this.selectNode(node.getChild(1));
            PandaVoice.speak(" and " + node.getChild(1).getFormula().toString());
            PandaVoice.speak(" with the temporary hypothesis " + node.getChild(0).getFormula().getSubFormulaLeft());
            this.selectNode(node.getChild(2));
            PandaVoice.speak(" and " + node.getChild(2).getFormula().toString());
            PandaVoice.speak(" with the temporary hypothesis " + node.getChild(0).getFormula().getSubFormulaRight());
        } else if (node.isRuleIntroImply()) {
            this.speakToProveAWehaveToProve(node.getFormula());
            this.selectNode(node.getChild(0));
            PandaVoice.speak(node.getChild(0).getFormula().toString());
            PandaVoice.speak(" with the temporary hypothesis " + node.getFormula().getSubFormulaLeft());
        } else {
            this.speakToProveAWehaveToProve(node.getFormula());
            for (ProofFormulaNode child : node.getChildren()) {
                this.selectNode(child);
                PandaVoice.speak(child.getFormula().toString());
            }
        }
        for (ProofFormulaNode child : node.getChildren()) {
            this.speak((ProofFormulaNodeNatDet)child);
        }
    }
}

