/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class SurprisedRectangle {
    private final Rectangle rectangle;
    private int anim = 0;
    private int animMax = 6;

    public SurprisedRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public boolean isDead() {
        return this.anim > this.animMax;
    }

    public void draw(Graphics g) {
        this.rectangle.grow(4, 4);
        int x1 = this.rectangle.x;
        int x2 = this.rectangle.x + this.rectangle.width;
        int y1 = this.rectangle.y;
        int y2 = this.rectangle.y + this.rectangle.height;
        double xc = this.rectangle.getCenterX();
        double yc = this.rectangle.getCenterY();
        float f = (float)this.anim / (float)this.animMax;
        g.setColor(new Color(f, f, f));
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
        int l = 8;
        for (int x = x1; x < x2; x += 8) {
            double angle = Math.atan2((double)y1 - yc, (double)x - xc);
            g.drawLine(x, y1, x + (int)(8.0 * Math.cos(angle)), y1 + (int)(8.0 * Math.sin(angle)));
            angle = Math.atan2((double)y2 - yc, (double)x - xc);
            g.drawLine(x, y2, x + (int)(8.0 * Math.cos(angle)), y2 + (int)(8.0 * Math.sin(angle)));
        }
        for (int y = y1; y < y2; y += 8) {
            double angle = Math.atan2((double)y - yc, (double)x1 - xc);
            g.drawLine(x1, y, x1 + (int)(8.0 * Math.cos(angle)), y + (int)(8.0 * Math.sin(angle)));
            angle = Math.atan2((double)y - yc, (double)x2 - xc);
            g.drawLine(x2, y, x2 + (int)(8.0 * Math.cos(angle)), y + (int)(8.0 * Math.sin(angle)));
        }
        ++this.anim;
    }
}

