/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import panda.CommandAddNode;
import panda.CommandCreateFatherForNode;
import panda.CommandNodeAddNewChild;
import panda.Formula;
import panda.ProofFormulaNode;
import panda.ProofFormulaNodeNatDet;
import panda.ProofPanel;

public class ProofPanelWithHint
extends ProofPanel {
    private ArrayList<ProofFormulaNode> hintsHypothesesDechargees = new ArrayList();
    private ArrayList<ProofFormulaNode> hintsTD = new ArrayList();
    private ArrayList<ProofFormulaNode> hintsBU = new ArrayList();

    public ProofPanelWithHint() {
        ArrayList<MouseListener> A = new ArrayList<MouseListener>();
        for (int i = 0; i < this.getMouseListeners().length; ++i) {
            A.add(this.getMouseListeners()[i]);
        }
        for (MouseListener m : A) {
            this.removeMouseListener(m);
        }
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                ProofFormulaNodeNatDet selectedNode = ProofPanelWithHint.this.getSelectedNode();
                for (ProofFormulaNode node : ProofPanelWithHint.this.hintsBU) {
                    if (!node.isOverFormula(e.getPoint())) continue;
                    ProofPanelWithHint.this.commandExecute(new CommandCreateFatherForNode(node, ProofPanelWithHint.this.getSelectedNode()));
                    ProofPanelWithHint.this.setNodeSelected(node);
                }
                for (ProofFormulaNode node : ProofPanelWithHint.this.hintsTD) {
                    if (!node.isOverFormula(e.getPoint())) continue;
                    ProofPanelWithHint.this.commandExecute(new CommandNodeAddNewChild(ProofPanelWithHint.this.getSelectedNode(), node));
                }
                for (ProofFormulaNode node : ProofPanelWithHint.this.hintsHypothesesDechargees) {
                    if (!node.isOverFormula(e.getPoint())) continue;
                    ProofPanelWithHint.this.commandExecute(new CommandAddNode(node));
                    ProofPanelWithHint.this.setNodeSelected(selectedNode);
                }
                ProofPanelWithHint.this.selectionChange();
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                ProofPanelWithHint.this.calculerHints();
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
        for (MouseListener m : A) {
            this.addMouseListener(m);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawTransparent((Graphics2D)g);
        for (ProofFormulaNode node : this.hintsBU) {
            node.drawNode(g);
        }
        for (ProofFormulaNode node : this.hintsTD) {
            node.drawNode(g);
        }
        for (ProofFormulaNode node : this.hintsHypothesesDechargees) {
            node.drawNode(g);
            ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
            for (int y = node.getYBottom(); y < node.getYBottom() + 32; y += 8) {
                g.drawLine(node.getXMilieu(), y, node.getXMilieu(), y + 4);
            }
        }
    }

    private void calculerHints() {
        this.hintsBU.clear();
        this.hintsTD.clear();
        this.hintsHypothesesDechargees.clear();
        ProofFormulaNodeNatDet node = this.getSelectedNode();
        if (node != null) {
            if (node.getFormula().isImply() & node.noChildren()) {
                this.hintsTD.add(new ProofFormulaNodeNatDet(new Point(node.getXMilieu(), node.getYFormulaTop() - node.getFormulaRectangleHeight() - 10), node.getFormula().getSubFormulaRight()));
            }
            if (node.getFormula().isNot() & node.noChildren()) {
                this.hintsTD.add(new ProofFormulaNodeNatDet(new Point(node.getXMilieu(), node.getYFormulaTop() - node.getFormulaRectangleHeight() - 10), new Formula("bottom")));
            }
            if (node.getFormula().isAnd() & node.noFather()) {
                this.hintsBU.add(new ProofFormulaNodeNatDet(new Point(node.getXMilieu() - 50, node.getYBottom() + 20), node.getFormula().getSubFormulaLeft()));
                this.hintsBU.add(new ProofFormulaNodeNatDet(new Point(node.getXMilieu() + 50, node.getYBottom() + 40), node.getFormula().getSubFormulaRight()));
            }
            if (node.getFormula().isNotNot() & node.noFather()) {
                this.hintsBU.add(new ProofFormulaNodeNatDet(new Point(node.getXMilieu(), node.getYBottom() + 20), node.getFormula().getSubFormulaForNot().getSubFormulaForNot()));
            }
            if (node.isHypothesePrincipale()) {
                int x = node.getXMilieu() - 100;
                for (Formula f : node.getHypothesesDechargeables()) {
                    ProofFormulaNodeNatDet n = new ProofFormulaNodeNatDet(new Point(x, 0), f);
                    n.setPointMilieuHautImmediat(new Point(x + n.getWidth() / 2, 0));
                    this.hintsHypothesesDechargees.add(n);
                    x += n.getWidth() + 15;
                }
            }
            if (node.getFormula().isOr() & node.noFather()) {
                this.hintsHypothesesDechargees.add(new ProofFormulaNodeNatDet(new Point(node.getXMilieu() + 100, node.getYBottom() - 100), node.getFormula().getSubFormulaLeft()));
                this.hintsHypothesesDechargees.add(new ProofFormulaNodeNatDet(new Point(node.getXMilieu() + 200, node.getYBottom() - 100), node.getFormula().getSubFormulaRight()));
            }
        }
    }

    protected void selectionChange() {
        super.selectionChange();
        this.calculerHints();
    }
}

