/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import panda.Command;
import panda.CommandAddNode;
import panda.CommandComposees;
import panda.CommandCreateCommonFather;
import panda.CommandNodeAddChild;
import panda.CommandNodeChangeFormula;
import panda.CommandNodeDeconnectFromFather;
import panda.CommandRemoveNode;
import panda.CommandsManager;
import panda.ComparatorProofFormulaNodeX;
import panda.Formula;
import panda.FormulaDialog;
import panda.HypotheseTemporaireDechargee;
import panda.MrnatureApp;
import panda.ProofFormulaNode;
import panda.ProofFormulaNodeNatDet;
import panda.SurprisedRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProofPanel
extends JPanel {
    private final CommandsManager commandsManager = new CommandsManager(this);
    private final ArrayList<ProofFormulaNode> nodes = new ArrayList();
    private ProofFormulaNode currentNode = null;
    private final Set<ProofFormulaNode> nodesSelected = new HashSet<ProofFormulaNode>();
    private ProofFormulaNode currentNodeMoved = null;
    private ActionListener actionListenerSelectionChange = null;
    private ActionListener actionListenerModification = null;
    private Point dessinTraitPoint1 = null;
    private Point dessinTraitPoint2 = null;
    private final Timer timerAnimation = new Timer(50, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            for (ProofFormulaNode node : ProofPanel.this.nodes) {
                node.animate();
            }
            ProofPanel.this.repaint();
        }
    });
    private final ArrayList<SurprisedRectangle> surprisedRectangles = new ArrayList();
    private Point mouseDragLastPoint;
    private Point currentNodePointMilieuHautBeginMouseDrag;
    private JMenuItem mnuCacherAfficher;
    private JPopupMenu popupMenuNode;

    public void setActionListenerSelectionChange(ActionListener actionListenerSelectionChange) {
        this.actionListenerSelectionChange = actionListenerSelectionChange;
    }

    public void setActionListenerModification(ActionListener actionListenerModification) {
        this.actionListenerModification = actionListenerModification;
    }

    public void commandExecute(Command command) {
        this.commandsManager.execute(command);
    }

    public void commandUnDo() {
        this.commandsManager.undoLastCommand();
        this.calculer();
        this.repaint();
    }

    public void commandReDo() {
        this.commandsManager.redoNextCommand();
        this.calculer();
        this.repaint();
    }

    public ProofPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.popupMenuNode = new JPopupMenu();
        this.mnuCacherAfficher = new JMenuItem();
        this.popupMenuNode.setName("popupMenuNode");
        ResourceMap resourceMap = Application.getInstance(MrnatureApp.class).getContext().getResourceMap(ProofPanel.class);
        this.mnuCacherAfficher.setText(resourceMap.getString("mnuCacherAfficher.text", new Object[0]));
        this.mnuCacherAfficher.setName("mnuCacherAfficher");
        this.mnuCacherAfficher.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProofPanel.this.mnuCacherAfficherActionPerformed(evt);
            }
        });
        this.popupMenuNode.add(this.mnuCacherAfficher);
        this.setBackground(resourceMap.getColor("Form.background"));
        this.setName("Form");
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ProofPanel.this.formMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                ProofPanel.this.formMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                ProofPanel.this.formMouseReleased(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                ProofPanel.this.formMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                ProofPanel.this.formMouseMoved(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ProofPanel.this.formKeyPressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 528, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 370, Short.MAX_VALUE));
    }

    private void formMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            FormulaDialog f = this.currentNode != null ? new FormulaDialog(null, true, this.currentNode.getFormula(), this.getFormulasHypotheses()) : new FormulaDialog(null, true, this.getFormulasHypotheses());
            f.setVisible(true);
            if (f.isOK()) {
                if (this.currentNode != null) {
                    this.commandExecute(new CommandNodeChangeFormula(this.currentNode, f.getFormula()));
                } else {
                    this.commandExecute(new CommandAddNode(new ProofFormulaNodeNatDet(evt.getPoint(), f.getFormula())));
                }
                this.repaint();
            }
        } else if (evt.getButton() == 3) {
            this.popupMenuNode.show(this, evt.getX(), evt.getY());
        }
    }

    public Set<Formula> getFormulasHypotheses() {
        HashSet<Formula> F = new HashSet<Formula>();
        for (ProofFormulaNode node : this.nodes) {
            F.addAll(((ProofFormulaNodeNatDet)node).getHypothesesGeneres());
        }
        return F;
    }

    private void graphics2Dconfigure(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
    }

    protected void drawTransparent(Graphics2D g2) {
        g2.setComposite(AlphaComposite.getInstance(3, Math.min(0.2f, 1.0f)));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.graphics2Dconfigure((Graphics2D)g);
        this.surprisedRectanglesClean();
        this.animationTimerVerifier();
        for (ProofFormulaNode nodeSelected : this.nodesSelected) {
            nodeSelected.drawAsSelected(g);
        }
        if (this.isTraitSouris()) {
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            g.drawLine(this.getTraitSourisXLeft(), this.getTraitSourisY(), this.getTraitSourisXRight(), this.getTraitSourisY());
            for (ProofFormulaNode node : this.getChildrenTraitSouris()) {
                node.drawAsSelected(g);
            }
        }
        for (ProofFormulaNode node : this.getShownNodes()) {
            if (!node.noFather()) continue;
            node.drawNodeAndTree(g);
        }
        if (this.currentNode != null) {
            this.currentNode.drawAsCurrent(g);
        }
        if (this.currentNodeMoved != null) {
            for (ProofFormulaNode node : this.getShownNodes()) {
                if (node.askToBeFatherOf(this.currentNodeMoved)) {
                    node.drawTraitGros(g);
                }
                if (!(this.currentNodeMoved.askToBeFatherOf(node) & node.getFather() == null)) continue;
                this.currentNodeMoved.drawTraitGros(g);
            }
        }
        for (int i = 0; i < this.surprisedRectangles.size(); ++i) {
            this.surprisedRectangles.get(i).draw(g);
        }
        if (this.isSelectionRectangle()) {
            Rectangle r = this.getSelectionRectangle();
            this.drawTransparent((Graphics2D)g);
            g.setColor(new Color(0.5f, 0.5f, 1.0f));
            g.fillRect(r.x, r.y, r.width, r.height);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    private ProofFormulaNode getNode(Point p) {
        for (ProofFormulaNode node : this.getShownNodes()) {
            if (!node.isOverFormula(p)) continue;
            return node;
        }
        return null;
    }

    private void formMouseMoved(MouseEvent evt) {
        this.currentNode = this.getNode(evt.getPoint());
        this.currentNodeMoved = null;
        this.repaint();
    }

    private void formMouseDragged(MouseEvent evt) {
        if (this.currentNode != null) {
            for (ProofFormulaNode node : this.getSelectedNodes()) {
                if (!this.noAncestorSelected(node)) continue;
                node.translate(evt.getPoint().x - this.mouseDragLastPoint.x, evt.getPoint().y - this.mouseDragLastPoint.y);
            }
            this.mouseDragLastPoint = evt.getPoint();
            this.currentNodeMoved = this.currentNode;
            this.layoutDo();
            this.repaint();
        } else {
            this.dessinTraitPoint2 = evt.getPoint();
            this.repaint();
        }
    }

    private void formMousePressed(MouseEvent evt) {
        if (this.currentNode != null) {
            this.mouseDragLastPoint = evt.getPoint();
            this.currentNodePointMilieuHautBeginMouseDrag = (Point)this.currentNode.getPointMilieuHaut().clone();
            if (!evt.isControlDown() & !this.isNodeSelected(this.currentNode)) {
                this.noSelection();
            }
            this.addNodeSelected(this.currentNode);
        } else {
            this.setNodeSelected(null);
            this.dessinTraitPoint1 = evt.getPoint();
            this.dessinTraitPoint2 = evt.getPoint();
        }
        this.repaint();
    }

    private void calculer() {
        this.positionsCompute();
        this.actionListenerModification.actionPerformed(null);
        this.selectionChange();
    }

    private void formMouseReleased(MouseEvent evt) {
        if (this.currentNode != null) {
            Point lastPositioncurrentNode = this.currentNodePointMilieuHautBeginMouseDrag;
            for (ProofFormulaNode node : this.getShownNodes()) {
                if (!node.askToBeFatherOf(this.currentNode)) continue;
                CommandComposees c = new CommandComposees();
                if (node.noChildren() & node.getFormula().equals(this.currentNode.getFormula())) {
                    ProofFormulaNode fatherOfNode = node.getFather();
                    if (fatherOfNode == null) {
                        this.addSurprisedRectangle(node.getRectangleTrait());
                        c.commandAdd(new CommandRemoveNode(node));
                    } else {
                        c.commandAdd(new CommandRemoveNode(node));
                        c.commandAdd(new CommandNodeAddChild(fatherOfNode, this.currentNode, lastPositioncurrentNode));
                        this.addSurprisedRectangle(fatherOfNode.getRectangleTrait());
                    }
                } else if (this.currentNode.getFather() != node) {
                    c.commandAdd(new CommandNodeAddChild(node, this.currentNode, lastPositioncurrentNode));
                    this.addSurprisedRectangle(node.getRectangleTrait());
                }
                this.commandExecute(c);
                this.calculerHypothesesTemporaires();
                this.calculer();
                this.repaint();
                return;
            }
            CommandComposees c = new CommandComposees();
            c.commandAdd(new CommandNodeDeconnectFromFather(this.currentNode, lastPositioncurrentNode, this.currentNode.getPointMilieuHaut()));
            for (ProofFormulaNode node : this.getShownNodes()) {
                if (!(this.currentNode.askToBeFatherOf(node) & node.getFather() == null)) continue;
                c.commandAdd(new CommandNodeAddChild(this.currentNode, node, lastPositioncurrentNode));
                this.commandExecute(c);
                this.calculerHypothesesTemporaires();
                this.calculer();
                this.repaint();
                return;
            }
            this.commandExecute(c);
        } else if (this.isTraitSouris()) {
            this.applyRuleByTraitSouris();
            this.TraitSourisAucun();
        } else if (this.isSelectionRectangle()) {
            this.selectionnerRectangle(this.getSelectionRectangle());
            this.TraitSourisAucun();
        }
        this.selectionChange();
        this.actionListenerModification.actionPerformed(null);
        this.calculer();
        this.repaint();
    }

    private void formKeyPressed(KeyEvent evt) {
    }

    private void mnuCacherAfficherActionPerformed(ActionEvent evt) {
        for (ProofFormulaNode node : this.getSelectedNodes()) {
            if (node.isTreeHidden()) {
                node.treeShowAll();
                continue;
            }
            this.nodeTreeHide(node);
        }
        this.calculer();
        this.repaint();
    }

    public void nodeAdd(ProofFormulaNode node) {
        this.nodes.add(node);
        this.calculerHypothesesTemporaires();
        this.actionListenerModification.actionPerformed(null);
        this.addSurprisedRectangle(node.getRectangleFormula());
    }

    public void nodeRemove(ProofFormulaNode node) {
        if (node == null) {
            System.out.println("nodeRemove re\u00e7oit un node null");
        }
        node.deconnectFromAll();
        this.addSurprisedRectangle(node.getRectangleFormula());
        this.nodes.remove(node);
        this.nodesSelected.remove(node);
        this.selectionChange();
        if (node == this.currentNode) {
            this.currentNode = null;
        }
        this.actionListenerModification.actionPerformed(null);
    }

    public void nodeTreeHide(ProofFormulaNode node) {
        node.treeHide();
        this.nodesSelected.removeAll(node.getChildrenAndGrandChildrenEtc());
    }

    public ProofFormulaNodeNatDet getSelectedNode() {
        if (this.nodesSelected.size() > 1) {
            return null;
        }
        Iterator<ProofFormulaNode> i$ = this.nodesSelected.iterator();
        if (i$.hasNext()) {
            ProofFormulaNode node = i$.next();
            return (ProofFormulaNodeNatDet)node;
        }
        return null;
    }

    public ArrayList<ProofFormulaNode> getSelectedNodes() {
        ArrayList<ProofFormulaNode> A = new ArrayList<ProofFormulaNode>(this.nodesSelected);
        Collections.sort(A, new ComparatorProofFormulaNodeX());
        return A;
    }

    public void clear() {
        this.nodes.clear();
        this.noSelection();
        this.currentNode = null;
        this.commandsManager.clear();
        this.repaint();
    }

    private void calculerHypothesesTemporaires() {
        ProofFormulaNodeNatDet.numerotationHypotheseTemporaireInitialiser();
        if (this.nodes == null) {
            return;
        }
        for (ProofFormulaNode node : this.nodes) {
            ((ProofFormulaNodeNatDet)node).hypothesesTemporairesInitialiser();
        }
        for (ProofFormulaNode node : this.nodes) {
            if (node.getFather() != null) continue;
            ((ProofFormulaNodeNatDet)node).calculerHypothesesTemporaires();
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        this.calculerHypothesesTemporaires();
    }

    public void setNodeSelected(ProofFormulaNode nodeSelected) {
        this.noSelection();
        if (nodeSelected != null) {
            this.nodesSelected.add(nodeSelected);
        }
        this.selectionChange();
    }

    @Override
    public Dimension getPreferredSize() {
        int xmin = 0;
        int ymin = 0;
        int xmax = 0;
        int ymax = 0;
        for (ProofFormulaNode node : this.getShownNodes()) {
            if (node.getXLeft() < xmin) {
                xmin = node.getXLeft();
            }
            if (node.getXRight() > xmax) {
                xmax = node.getXRight();
            }
            if (node.getYFormulaTop() < ymin) {
                ymin = node.getXLeft();
            }
            if (node.getYBottom() <= ymax) continue;
            ymax = node.getYBottom();
        }
        return new Dimension(xmax + 100, ymax + 100);
    }

    private void layoutDo() {
        this.doLayout();
        this.getParent().doLayout();
    }

    public Set<HypotheseTemporaireDechargee> getHypothesesADecharger() {
        HashSet<HypotheseTemporaireDechargee> S = new HashSet<HypotheseTemporaireDechargee>();
        for (ProofFormulaNode n : this.nodes) {
            S.addAll(((ProofFormulaNodeNatDet)n).getHypothesesDechargeesIciDansCeNoeud());
        }
        return S;
    }

    private void TraitSourisAucun() {
        this.dessinTraitPoint1 = null;
        this.dessinTraitPoint2 = null;
    }

    private boolean isTraitSouris() {
        if (this.dessinTraitPoint1 == null) {
            return false;
        }
        return Math.abs(this.dessinTraitPoint1.y - this.dessinTraitPoint2.y) < 30;
    }

    private boolean isSelectionRectangle() {
        if (this.dessinTraitPoint1 == null) {
            return false;
        }
        return !this.isTraitSouris();
    }

    private Rectangle getSelectionRectangle() {
        int x1 = Math.min(this.dessinTraitPoint1.x, this.dessinTraitPoint2.x);
        int x2 = Math.max(this.dessinTraitPoint1.x, this.dessinTraitPoint2.x);
        int y1 = Math.min(this.dessinTraitPoint1.y, this.dessinTraitPoint2.y);
        int y2 = Math.max(this.dessinTraitPoint1.y, this.dessinTraitPoint2.y);
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    private void applyRuleByTraitSouris() {
        ArrayList<ProofFormulaNode> futureChildren = this.getChildrenTraitSouris();
        if (futureChildren.size() == 2) {
            Formula f0 = futureChildren.get(0).getFormula();
            Formula f1 = futureChildren.get(1).getFormula();
            if (f0.isNot() && f1.equals(f0.getSubFormulaForNot())) {
                this.createRuleIntroBottom(futureChildren);
                return;
            }
            if (f1.isNot() && f0.equals(f1.getSubFormulaForNot())) {
                this.createRuleIntroBottom(futureChildren);
                return;
            }
            if (f0.isImply() && f1.equals(f0.getSubFormulaLeft())) {
                this.createCommonFatherMouseLine(futureChildren, f0.getSubFormulaRight());
                return;
            }
            if (f1.isImply() && f0.equals(f1.getSubFormulaLeft())) {
                this.createCommonFatherMouseLine(futureChildren, f1.getSubFormulaRight());
                return;
            }
            this.createCommonFatherMouseLine(futureChildren, new Formula("(" + f0 + " and " + f1 + ")"));
        } else if (futureChildren.size() == 3) {
            Formula f0 = futureChildren.get(0).getFormula();
            Formula f1 = futureChildren.get(1).getFormula();
            Formula f2 = futureChildren.get(2).getFormula();
            if (f0.equals(f1)) {
                Formula t = f2;
                f2 = f1;
                f1 = f0;
                f0 = t;
            }
            if (f0.equals(f2)) {
                f0 = f1;
                f1 = f2;
            }
            if (f0.isOr()) {
                this.createCommonFatherMouseLine(futureChildren, f2);
            }
        }
    }

    private int getTraitSourisY() {
        return this.dessinTraitPoint1.y;
    }

    private int getTraitSourisXLeft() {
        return Math.min(this.dessinTraitPoint1.x, this.dessinTraitPoint2.x);
    }

    private int getTraitSourisXRight() {
        return Math.max(this.dessinTraitPoint1.x, this.dessinTraitPoint2.x);
    }

    private ArrayList<ProofFormulaNode> getChildrenTraitSouris() {
        ArrayList<ProofFormulaNode> futureChildren = new ArrayList<ProofFormulaNode>();
        for (ProofFormulaNode node : this.nodes) {
            if (!(node.getYBottom() < this.getTraitSourisY() & node.getYBottom() > this.getTraitSourisY() - 150 & node.noFather() & node.getXMilieu() > this.getTraitSourisXLeft() & node.getXMilieu() < this.getTraitSourisXRight())) continue;
            futureChildren.add(node);
        }
        Collections.sort(futureChildren, new ComparatorProofFormulaNodeX());
        return futureChildren;
    }

    private Point getBarycentre(ArrayList<ProofFormulaNode> children) {
        int x = 0;
        int y = 0;
        for (ProofFormulaNode child : children) {
            x += child.getXMilieu();
            y += child.getYBottom();
        }
        return new Point(x /= children.size(), y /= children.size());
    }

    private Point getTraitSourisFatherPointMilieu() {
        int x = 0;
        for (ProofFormulaNode child : this.getChildrenTraitSouris()) {
            x += child.getXMilieu();
        }
        return new Point(x /= this.getChildrenTraitSouris().size(), this.getTraitSourisY());
    }

    private void createRuleIntroBottom(ArrayList<ProofFormulaNode> futureChildren) {
        this.createCommonFatherMouseLine(futureChildren, new Formula("bottom"));
    }

    private void createCommonFatherMouseLine(ArrayList<ProofFormulaNode> futureChildren, Formula formulaFather) {
        ProofFormulaNodeNatDet father = new ProofFormulaNodeNatDet(this.getTraitSourisFatherPointMilieu(), formulaFather);
        this.commandExecute(new CommandCreateCommonFather(father, futureChildren));
        this.setNodeSelected(father);
    }

    public void createCommonFatherBarycentre(ArrayList<ProofFormulaNode> futureChildren, Formula formulaFather) {
        ProofFormulaNodeNatDet father = new ProofFormulaNodeNatDet(this.getBarycentre(futureChildren), formulaFather);
        this.commandExecute(new CommandCreateCommonFather(father, futureChildren));
        this.setNodeSelected(father);
    }

    private void noSelection() {
        this.nodesSelected.clear();
    }

    private void addNodeSelected(ProofFormulaNode node) {
        this.nodesSelected.add(node);
    }

    protected void selectionChange() {
        if (this.actionListenerSelectionChange != null) {
            this.actionListenerSelectionChange.actionPerformed(null);
        }
    }

    private boolean isSuperpose(ProofFormulaNode nodeTest) {
        for (ProofFormulaNode node : this.getShownNodes()) {
            if (node == nodeTest || !node.getRectangleFormula().intersects(nodeTest.getRectangleFormula())) continue;
            return true;
        }
        return false;
    }

    public void moveNodeToEnsureNoOverlaping(ProofFormulaNode node) {
        int ydepart;
        int xdepart = node.getXMilieu();
        for (int y = ydepart = node.getYFormulaTop(); y < this.getHeight(); y += 20) {
            for (int x = xdepart; x < this.getWidth(); x += 20) {
                node.setPointMilieuHautImmediat(new Point(x, y));
                if (this.isSuperpose(node)) continue;
                return;
            }
        }
    }

    private void addSurprisedRectangle(Rectangle rectangleTrait) {
        this.surprisedRectangles.add(new SurprisedRectangle(rectangleTrait));
        this.timerAnimation.start();
    }

    private void surprisedRectanglesClean() {
        int i = 0;
        while (i < this.surprisedRectangles.size()) {
            if (this.surprisedRectangles.get(i).isDead()) {
                this.surprisedRectangles.remove(i);
                continue;
            }
            ++i;
        }
    }

    public String getLaTEXCode() {
        String s = "";
        for (ProofFormulaNode node : this.nodes) {
            if (!node.noFather()) continue;
            s = s + "$$" + node.getLaTEXCodeArbre() + "$$" + "\n" + "\n";
        }
        return s;
    }

    private void selectionnerRectangle(Rectangle selectionRectangle) {
        this.nodesSelected.clear();
        for (ProofFormulaNode node : this.getShownNodes()) {
            if (!node.getRectangleFormula().intersects(selectionRectangle)) continue;
            this.nodesSelected.add(node);
        }
        this.selectionChange();
    }

    private boolean isNodeSelected(ProofFormulaNode node) {
        return this.nodesSelected.contains(node);
    }

    private void positionsCompute() {
        for (ProofFormulaNode node : this.nodes) {
            if (!node.noFather()) continue;
            node.positionsCompute();
        }
    }

    private void animationTimerVerifier() {
        for (ProofFormulaNode node : this.nodes) {
            if (!node.isAnimated()) continue;
            if (!this.timerAnimation.isRunning()) {
                this.timerAnimation.start();
            }
            return;
        }
        if (this.surprisedRectangles.isEmpty()) {
            this.timerAnimation.stop();
        } else if (!this.timerAnimation.isRunning()) {
            this.timerAnimation.start();
        }
    }

    private Iterable<ProofFormulaNode> getShownNodes() {
        HashSet<ProofFormulaNode> shownNode = new HashSet<ProofFormulaNode>();
        for (ProofFormulaNode n : this.nodes) {
            if (n.noFather()) {
                shownNode.add(n);
                continue;
            }
            if (n.getFather().isTreeHidden()) continue;
            shownNode.add(n);
        }
        return shownNode;
    }

    public ProofFormulaNode getProofNode(Set<Formula> hypothesisFormulas, Formula goalFormula) {
        for (ProofFormulaNode node : this.nodes) {
            ProofFormulaNodeNatDet n = (ProofFormulaNodeNatDet)node;
            if (!(n.noFather() & n.isTreeOK()) || !(n.getFormula().equals(goalFormula) & hypothesisFormulas.containsAll(n.getHypothesesPrincipalesArbre()))) continue;
            return n;
        }
        return null;
    }

    private boolean noAncestorSelected(ProofFormulaNode node) {
        for (ProofFormulaNode father = node.getFather(); father != null; father = father.getFather()) {
            if (!this.nodesSelected.contains(father)) continue;
            return false;
        }
        return true;
    }

    void saveInFile(String fileName) throws IOException {
        XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
        Document document = this.getDocument();
        sortie.output(document, (OutputStream)new FileOutputStream(fileName));
    }

    private static Document getDocumentDuFichier(String nomFichier) throws JDOMException, IOException {
        SAXBuilder sxb = new SAXBuilder(false);
        EntityResolver entityResolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.startsWith("http://")) {
                    return new InputSource(new InputStream(){

                        public int read() throws IOException {
                            return -1;
                        }
                    });
                }
                return null;
            }
        };
        sxb.setEntityResolver(entityResolver);
        sxb.setValidation(false);
        return sxb.build(new File(nomFichier));
    }

    public void openFromFile(String fileName) throws JDOMException, IOException {
        this.clear();
        this.openFromDocument(ProofPanel.getDocumentDuFichier(fileName));
    }

    private Document getDocument() {
        Element racine = new Element("proofs");
        Document document = new Document(racine);
        for (ProofFormulaNode node : this.nodes) {
            if (!node.noFather()) continue;
            racine.addContent((Content)node.saveRecursive());
        }
        return document;
    }

    private void openFromDocument(Document document) {
        Element racine = document.getRootElement();
        for (Object elementPartieO : racine.getChildren("proofnode")) {
            this.traiterProofNodeFromXML((Element)elementPartieO);
        }
    }

    private ProofFormulaNode traiterProofNodeFromXML(Element element) {
        Formula formula = new Formula(element.getChild("formula").getText());
        int x = Integer.parseInt(element.getChild("graphicalposition").getChild("x").getText());
        int y = Integer.parseInt(element.getChild("graphicalposition").getChild("y").getText());
        Point pointMilieu = new Point(x, y);
        ProofFormulaNodeNatDet node = new ProofFormulaNodeNatDet(pointMilieu, formula);
        for (Object elementChild : element.getChild("children").getChildren()) {
            ProofFormulaNode nodeChild = this.traiterProofNodeFromXML((Element)elementChild);
            ((ProofFormulaNode)node).addChild(nodeChild);
        }
        this.nodeAdd(node);
        return node;
    }
}

