/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import panda.Formula;
import panda.HypotheseTemporaireDechargee;
import panda.LaTEX;
import panda.ProofFormulaNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProofFormulaNodeNatDet
extends ProofFormulaNode {
    private static Icon imgRuleEliminationAnd = LaTEX.latexCodeToMiniImageIcon("(E \\wedge)");
    private static Icon imgRuleEliminationImply = LaTEX.latexCodeToMiniImageIcon("(E \\rightarrow)");
    private static Icon imgRuleEliminationNotNot = LaTEX.latexCodeToMiniImageIcon("(E \\neg \\neg)");
    private static Icon imgRuleEliminationBottom = LaTEX.latexCodeToMiniImageIcon("(E \\bot)");
    private static Icon imgRuleEliminationOr = LaTEX.latexCodeToMiniImageIcon("(E \\vee)");
    private static Icon imgRuleIntroAnd = LaTEX.latexCodeToMiniImageIcon("(I \\wedge)");
    private static Icon imgRuleIntroOr = LaTEX.latexCodeToMiniImageIcon("(I \\vee)");
    private static Icon imgRuleIntroBottom = LaTEX.latexCodeToMiniImageIcon("(I \\bot)");
    private static Icon imgRuleIntroImply = LaTEX.latexCodeToMiniImageIcon("(I \\rightarrow)");
    private static Icon imgRuleIntroNot = LaTEX.latexCodeToMiniImageIcon("(I \\neg)");
    private static Icon imgRuleEliminationForall = LaTEX.latexCodeToMiniImageIcon("(E \\forall)");
    private static Icon imgRuleEliminationExists = LaTEX.latexCodeToMiniImageIcon("(E \\exists)");
    private static Icon imgRuleIntroForall = LaTEX.latexCodeToMiniImageIcon("(I \\forall)");
    private static Icon imgRuleIntroExists = LaTEX.latexCodeToMiniImageIcon("(I \\exists)");
    private int numHypotheseTemporaire = -1;
    private static int numHypotheseTemporaireGenerateur = 0;
    private static Color colorHypotheseTemporaire = new Color(0.0f, 0.0f, 0.7f);
    private static Color colorError = new Color(1.0f, 0.0f, 0.0f);
    private static Font fontHypotheseTemporaire = new Font("Verdana", 0, 12);
    private ArrayList<Integer> hypothesesDechargeesIciNumeros = new ArrayList();

    public static void numerotationHypotheseTemporaireInitialiser() {
        numHypotheseTemporaireGenerateur = 0;
    }

    private static int getNumHypotheseTemporaireNouvelle() {
        return ++numHypotheseTemporaireGenerateur;
    }

    public int getNumHypotheseTemporaire() {
        return this.numHypotheseTemporaire;
    }

    public ProofFormulaNodeNatDet(Point pointMilieuHaut, Formula formula) {
        super(pointMilieuHaut, formula);
    }

    private Icon getImageRule() {
        if (this.isRuleEliminationAnd()) {
            return imgRuleEliminationAnd;
        }
        if (this.isRuleEliminationImply()) {
            return imgRuleEliminationImply;
        }
        if (this.isRuleEliminationNotNot()) {
            return imgRuleEliminationNotNot;
        }
        if (this.isRuleEliminationBottom()) {
            return imgRuleEliminationBottom;
        }
        if (this.isRuleEliminationOr()) {
            return imgRuleEliminationOr;
        }
        if (this.isRuleIntroAnd()) {
            return imgRuleIntroAnd;
        }
        if (this.isRuleIntroOr()) {
            return imgRuleIntroOr;
        }
        if (this.isRuleIntroBottom()) {
            return imgRuleIntroBottom;
        }
        if (this.isRuleIntroImply()) {
            return imgRuleIntroImply;
        }
        if (this.isRuleIntroNot()) {
            return imgRuleIntroNot;
        }
        if (this.isRuleEliminationForall()) {
            return imgRuleEliminationForall;
        }
        if (this.isRuleEliminationExists()) {
            return imgRuleEliminationExists;
        }
        if (this.isRuleIntroForall()) {
            return imgRuleIntroForall;
        }
        if (this.isRuleIntroExists()) {
            return imgRuleIntroExists;
        }
        return null;
    }

    public boolean isHypothese() {
        return this.getNbChildren() == 0;
    }

    public boolean isHypotheseTemporaire() {
        return this.getNbChildren() == 0 & this.numHypotheseTemporaire > -1;
    }

    @Override
    public void addChild(ProofFormulaNode node) {
        super.addChild(node);
        if (this.getNbChildren() == 2) {
            if (this.getFormula().isBottom() & this.getChild(0).getFormula().isNot() && this.getChild(0).getFormula().getSubFormulaForNot().equals(this.getChild(1).getFormula())) {
                this.echangerChildren2();
            }
            if (this.getChild(1).getFormula().isImply() && this.getChild(1).getFormula().getSubFormulaLeft().equals(this.getChild(0).getFormula()) & this.getChild(1).getFormula().getSubFormulaRight().equals(this.getFormula())) {
                this.echangerChildren2();
            }
            if (this.getChild(1).getFormula().isExists() & !this.getChild(0).getFormula().isExists()) {
                this.echangerChildren2();
            }
        }
        if (this.getNbChildren() == 3) {
            ProofFormulaNode C0 = this.getChild(0);
            ProofFormulaNode C1 = this.getChild(1);
            ProofFormulaNode C2 = this.getChild(2);
            if (C0.getFormula().equals(C1.getFormula())) {
                this.children.clear();
                this.addChild(C2);
                this.addChild(C0);
                this.addChild(C1);
            }
            if (C0.getFormula().equals(C2.getFormula())) {
                this.children.clear();
                this.addChild(C1);
                this.addChild(C0);
                this.addChild(C2);
            }
        }
        this.positionsCompute();
    }

    public void hypothesesTemporairesInitialiser() {
        this.numHypotheseTemporaire = -1;
    }

    public void marquerHypothesesTemporairesSousArbres(Formula formula, int numeroHypothese) {
        if (this.isHypothese()) {
            if (this.getFormula().equals(formula)) {
                this.numHypotheseTemporaire = numeroHypothese;
            }
        } else {
            for (ProofFormulaNode child : this.getChildren()) {
                ((ProofFormulaNodeNatDet)child).marquerHypothesesTemporairesSousArbres(formula, numeroHypothese);
            }
        }
    }

    @Override
    public void drawNode(Graphics g) {
        if (this.isHypothese() & !this.isHypotheseTemporaire()) {
            g.setColor(new Color(0.5f, 1.0f, 0.5f));
            g.fillRect(this.getRectangleFormula().x, this.getRectangleFormula().y, this.getRectangleFormula().width, this.getRectangleFormula().height);
            g.setColor(Color.BLACK);
        }
        super.drawNode(g);
        if (this.isHypotheseTemporaire()) {
            g.setFont(fontHypotheseTemporaire);
            g.setColor(colorHypotheseTemporaire);
            g.drawLine(this.getXRight(), this.getYFormulaTop(), this.getXLeft(), this.getYBottom());
            g.drawString("(" + this.numHypotheseTemporaire + ")", this.getXRight(), this.getYFormulaTop());
        }
        g.setColor(Color.BLACK);
        if (this.getImageRule() != null) {
            this.getImageRule().paintIcon(null, g, this.getXRight(), this.getYFormulaTop() - this.getImageRule().getIconHeight());
            String s = "";
            for (int i : this.hypothesesDechargeesIciNumeros) {
                s = s + "(" + i + ")";
            }
            g.setFont(fontHypotheseTemporaire);
            g.setColor(colorHypotheseTemporaire);
            g.drawString(s, this.getXRight() + this.getImageRule().getIconWidth(), this.getYFormulaTop());
            g.drawString(this.getMessageCheck(), this.getXRight() + this.getImageRule().getIconWidth(), this.getYFormulaTop());
            g.setColor(Color.BLACK);
        } else if (!this.isHypothese()) {
            g.setColor(colorError);
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            this.drawTrait(g);
            g.setFont(fontHypotheseTemporaire);
            g.drawString("???", this.getXRight(), this.getYFormulaTop());
            g.setColor(Color.BLACK);
        }
    }

    public boolean isRuleEliminationAnd() {
        if (this.getNbChildren() != 1) {
            return false;
        }
        Formula AandB = this.getChild(0).getFormula();
        if (!AandB.isAnd()) {
            return false;
        }
        if (AandB.getSubFormulaLeft().equals(this.getFormula())) {
            return true;
        }
        return AandB.getSubFormulaRight().equals(this.getFormula());
    }

    public boolean isRuleEliminationImply() {
        if (this.getNbChildren() != 2) {
            return false;
        }
        Formula AimplyB = this.getChild(0).getFormula();
        Formula A = this.getChild(1).getFormula();
        Formula B = this.getFormula();
        if (!AimplyB.isImply()) {
            return false;
        }
        if (!B.equals(AimplyB.getSubFormulaRight())) {
            return false;
        }
        return A.equals(AimplyB.getSubFormulaLeft());
    }

    public boolean isRuleEliminationNotNot() {
        if (this.getNbChildren() != 1) {
            return false;
        }
        Formula notnotA = this.getChild(0).getFormula();
        Formula A = this.getFormula();
        if (!notnotA.isNot()) {
            return false;
        }
        if (!notnotA.getSubFormulaForNot().isNot()) {
            return false;
        }
        return A.equals(notnotA.getSubFormulaForNot().getSubFormulaForNot());
    }

    public boolean isRuleEliminationBottom() {
        if (this.getNbChildren() != 1) {
            return false;
        }
        if (!this.getChild(0).getFormula().isBottom()) {
            return false;
        }
        return !this.getFormula().isNot();
    }

    public boolean isRuleEliminationOr() {
        if (this.getNbChildren() != 3) {
            return false;
        }
        Formula AorB = this.getChild(0).getFormula();
        if (!AorB.isOr()) {
            return false;
        }
        if (!this.getFormula().equals(this.getChild(1).getFormula())) {
            return false;
        }
        return this.getFormula().equals(this.getChild(2).getFormula());
    }

    public boolean isRuleIntroAnd() {
        if (!this.getFormula().isAnd()) {
            return false;
        }
        if (this.getNbChildren() != 2) {
            return false;
        }
        if (this.getChild(0).getFormula().equals(this.getFormula().getSubFormulaLeft()) & this.getChild(1).getFormula().equals(this.getFormula().getSubFormulaRight())) {
            return true;
        }
        return this.getChild(1).getFormula().equals(this.getFormula().getSubFormulaLeft()) & this.getChild(0).getFormula().equals(this.getFormula().getSubFormulaRight());
    }

    public boolean isRuleIntroOr() {
        if (!this.getFormula().isOr()) {
            return false;
        }
        if (this.getNbChildren() != 1) {
            return false;
        }
        if (this.getChild(0).getFormula().equals(this.getFormula().getSubFormulaLeft())) {
            return true;
        }
        return this.getChild(0).getFormula().equals(this.getFormula().getSubFormulaRight());
    }

    public boolean isRuleIntroBottom() {
        if (!this.getFormula().isBottom()) {
            return false;
        }
        if (this.getNbChildren() != 2) {
            return false;
        }
        Formula A = this.getChild(0).getFormula();
        Formula notA = this.getChild(1).getFormula();
        if (!notA.isNot()) {
            return false;
        }
        return A.equals(notA.getSubFormulaForNot());
    }

    public boolean isRuleIntroImply() {
        if (!this.getFormula().isImply()) {
            return false;
        }
        if (this.getNbChildren() != 1) {
            return false;
        }
        return this.getChild(0).getFormula().equals(this.getFormula().getSubFormulaRight());
    }

    public boolean isRuleIntroNot() {
        if (this.getNbChildren() != 1) {
            return false;
        }
        if (!this.getChild(0).getFormula().isBottom()) {
            return false;
        }
        return this.getFormula().isNot();
    }

    public boolean isRuleEliminationForall() {
        if (this.getNbChildren() != 1) {
            return false;
        }
        if (!this.getChild(0).getFormula().isForAll()) {
            return false;
        }
        Formula Atx = this.getFormula();
        String x = this.getChild(0).getFormula().getQuantifierVariable();
        Formula A = this.getChild(0).getFormula().getQuantifierSubFormula();
        return Atx.brutalUnifiable(A, x) != null;
    }

    public boolean isRuleEliminationExists() {
        if (this.getNbChildren() != 2) {
            return false;
        }
        if (!this.getChild(0).getFormula().isExists()) {
            return false;
        }
        return this.getChild(1).getFormula().equals(this.getFormula());
    }

    public boolean checkRuleEliminationExists() {
        Formula existsA = this.getChild(0).getFormula();
        Formula A = existsA.getQuantifierSubFormula();
        String x = existsA.getQuantifierVariable();
        for (Formula hypothese : ((ProofFormulaNodeNatDet)this.getChild(1)).getHypothesesPrincipalesArbre()) {
            if (hypothese.equals(A) || !hypothese.isFreeVariable(x)) continue;
            return false;
        }
        return !this.getFormula().isFreeVariable(x);
    }

    public boolean checkRuleIntroExists() {
        Formula A = this.getFormula().getQuantifierSubFormula();
        String x = this.getFormula().getQuantifierVariable();
        Formula Atx = this.getChild(0).getFormula();
        Formula t = Atx.unifiable(A, x);
        return A.isSaine(x, t);
    }

    public boolean checkRuleEliminationForall() {
        Formula Atx = this.getFormula();
        String x = this.getChild(0).getFormula().getQuantifierVariable();
        Formula A = this.getChild(0).getFormula().getQuantifierSubFormula();
        Formula t = Atx.unifiable(A, x);
        return A.isSaine(x, t);
    }

    public boolean isRuleIntroForall() {
        if (this.getNbChildren() != 1) {
            return false;
        }
        if (!this.getFormula().isForAll()) {
            return false;
        }
        return this.getFormula().getQuantifierSubFormula().equals(this.getChild(0).getFormula());
    }

    public boolean checkRuleIntroForall() {
        for (Formula hypothese : ((ProofFormulaNodeNatDet)this.getChild(0)).getHypothesesPrincipalesArbre()) {
            if (!hypothese.isFreeVariable(this.getFormula().getQuantifierVariable())) continue;
            return false;
        }
        return true;
    }

    public boolean isRuleIntroExists() {
        if (this.getNbChildren() != 1) {
            return false;
        }
        if (!this.getFormula().isExists()) {
            return false;
        }
        Formula A = this.getFormula().getQuantifierSubFormula();
        String x = this.getFormula().getQuantifierVariable();
        Formula Atx = this.getChild(0).getFormula();
        return Atx.unifiable(A, x) != null;
    }

    public void calculerHypothesesTemporaires() {
        this.hypothesesDechargeesIciNumeros.clear();
        if (this.isRuleEliminationOr()) {
            Formula AorB = this.getChild(0).getFormula();
            this.hypothesesDechargeesIciNumeros.add(ProofFormulaNodeNatDet.getNumHypotheseTemporaireNouvelle());
            this.hypothesesDechargeesIciNumeros.add(ProofFormulaNodeNatDet.getNumHypotheseTemporaireNouvelle());
            ((ProofFormulaNodeNatDet)this.getChild(1)).marquerHypothesesTemporairesSousArbres(AorB.getSubFormulaLeft(), this.hypothesesDechargeesIciNumeros.get(0));
            ((ProofFormulaNodeNatDet)this.getChild(2)).marquerHypothesesTemporairesSousArbres(AorB.getSubFormulaRight(), this.hypothesesDechargeesIciNumeros.get(1));
        } else if (this.isRuleEliminationExists()) {
            Formula A = this.getChild(0).getFormula().getQuantifierSubFormula();
            this.hypothesesDechargeesIciNumeros.add(ProofFormulaNodeNatDet.getNumHypotheseTemporaireNouvelle());
            ((ProofFormulaNodeNatDet)this.getChild(1)).marquerHypothesesTemporairesSousArbres(A, this.hypothesesDechargeesIciNumeros.get(0));
        } else if (this.isRuleIntroImply()) {
            this.hypothesesDechargeesIciNumeros.add(ProofFormulaNodeNatDet.getNumHypotheseTemporaireNouvelle());
            this.marquerHypothesesTemporairesSousArbres(this.getFormula().getSubFormulaLeft(), this.hypothesesDechargeesIciNumeros.get(0));
        } else if (this.isRuleIntroNot()) {
            this.hypothesesDechargeesIciNumeros.add(ProofFormulaNodeNatDet.getNumHypotheseTemporaireNouvelle());
            this.marquerHypothesesTemporairesSousArbres(this.getFormula().getSubFormulaForNot(), this.hypothesesDechargeesIciNumeros.get(0));
        }
        for (ProofFormulaNode child : this.getChildren()) {
            ((ProofFormulaNodeNatDet)child).calculerHypothesesTemporaires();
        }
    }

    public Set<Formula> getHypothesesPrincipalesArbre() {
        if (this.isHypothese()) {
            HashSet<Formula> Hyp = new HashSet<Formula>();
            Hyp.add(this.getFormula());
            return Hyp;
        }
        if (this.isRuleEliminationOr()) {
            HashSet<Formula> Hyp = new HashSet<Formula>();
            Formula AorB = this.getChild(0).getFormula();
            Set<Formula> Hyp1 = ((ProofFormulaNodeNatDet)this.getChild(1)).getHypothesesPrincipalesArbre();
            Hyp1.remove(AorB.getSubFormulaLeft());
            Set<Formula> Hyp2 = ((ProofFormulaNodeNatDet)this.getChild(2)).getHypothesesPrincipalesArbre();
            Hyp2.remove(AorB.getSubFormulaRight());
            Hyp.addAll(Hyp1);
            Hyp.addAll(Hyp2);
            return Hyp;
        }
        if (this.isRuleEliminationExists()) {
            HashSet<Formula> Hyp = new HashSet<Formula>();
            Set<Formula> Hyp0 = ((ProofFormulaNodeNatDet)this.getChild(0)).getHypothesesPrincipalesArbre();
            Set<Formula> Hyp1 = ((ProofFormulaNodeNatDet)this.getChild(1)).getHypothesesPrincipalesArbre();
            Formula A = this.getChild(0).getFormula().getQuantifierSubFormula();
            Hyp1.remove(A);
            Hyp.addAll(Hyp0);
            Hyp.addAll(Hyp1);
            return Hyp;
        }
        if (this.isRuleIntroImply()) {
            Set<Formula> Hyp0 = ((ProofFormulaNodeNatDet)this.getChild(0)).getHypothesesPrincipalesArbre();
            Hyp0.remove(this.getFormula().getSubFormulaLeft());
            return Hyp0;
        }
        if (this.isRuleIntroNot()) {
            Set<Formula> Hyp0 = ((ProofFormulaNodeNatDet)this.getChild(0)).getHypothesesPrincipalesArbre();
            Hyp0.remove(this.getFormula().getSubFormulaForNot());
            return Hyp0;
        }
        HashSet<Formula> Hyp = new HashSet<Formula>();
        for (ProofFormulaNode child : this.getChildren()) {
            Hyp.addAll(((ProofFormulaNodeNatDet)child).getHypothesesPrincipalesArbre());
        }
        return Hyp;
    }

    private void getHypothesesArbre(Set<Formula> F) {
        if (this.isHypothese()) {
            F.add(this.getFormula());
        } else {
            for (ProofFormulaNode child : this.getChildren()) {
                ((ProofFormulaNodeNatDet)child).getHypothesesArbre(F);
            }
        }
    }

    public Set<Formula> getHypothesesArbre() {
        HashSet<Formula> F = new HashSet<Formula>();
        this.getHypothesesArbre(F);
        return F;
    }

    public ArrayList<Formula> getFormulasHypothesesDechargeesIciDansCeNoeud() {
        ArrayList<Formula> F = new ArrayList<Formula>();
        if (this.isRuleEliminationOr()) {
            F.add(this.getChild(0).getFormula().getSubFormulaLeft());
            F.add(this.getChild(0).getFormula().getSubFormulaRight());
        } else if (this.isRuleIntroImply()) {
            F.add(this.getFormula().getSubFormulaLeft());
        } else if (this.isRuleIntroNot()) {
            F.add(this.getFormula().getSubFormulaForNot());
        } else if (this.isRuleEliminationExists()) {
            F.add(this.getChild(0).getFormula().getQuantifierSubFormula());
        }
        return F;
    }

    public Set<HypotheseTemporaireDechargee> getHypothesesDechargeesIciDansCeNoeud() {
        HashSet<HypotheseTemporaireDechargee> S = new HashSet<HypotheseTemporaireDechargee>();
        ArrayList<Formula> F = this.getFormulasHypothesesDechargeesIciDansCeNoeud();
        for (int i = 0; i < F.size(); ++i) {
            S.add(new HypotheseTemporaireDechargee(this.hypothesesDechargeesIciNumeros.get(i), F.get(i)));
        }
        return S;
    }

    public Set<Formula> getHypothesesGeneres() {
        HashSet<Formula> F = new HashSet<Formula>();
        if (this.isHypothese()) {
            F.add(this.getFormula());
            return F;
        }
        this.getFormulasHypothesesDechargeesIciDansCeNoeud();
        return F;
    }

    public boolean isOK() {
        return this.getImageRule() != null || this.isHypothese();
    }

    public String getMessageCheck() {
        if (this.isRuleEliminationExists() && !this.checkRuleEliminationExists()) {
            return "variable libre !";
        }
        if (this.isRuleIntroForall() && !this.checkRuleIntroForall()) {
            return "variable libre !";
        }
        if (this.isRuleIntroExists() && !this.checkRuleIntroExists()) {
            return "substitution non saine !";
        }
        if (this.isRuleEliminationForall() && !this.checkRuleEliminationForall()) {
            return "substitution non saine !";
        }
        return "";
    }

    @Override
    public String getLaTEXCodeArbre() {
        String s = super.getLaTEXCodeArbre();
        if (this.isHypotheseTemporaire()) {
            s = "{" + s + "}^{(" + this.getNumHypotheseTemporaire() + ")}";
            return s;
        }
        if (this.isHypothese()) {
            return s;
        }
        if (this.isOK()) {
            s = s + this.getRuleNameLaTEXCode();
            for (int i : this.hypothesesDechargeesIciNumeros) {
                s = s + "(" + i + ")";
            }
            return s;
        }
        return s;
    }

    private String getRuleNameLaTEXCode() {
        if (this.isRuleEliminationAnd()) {
            return "(E\\wedge)";
        }
        if (this.isRuleEliminationImply()) {
            return "(E\\rightarrow)";
        }
        if (this.isRuleEliminationNotNot()) {
            return "(E\\neg)";
        }
        if (this.isRuleEliminationBottom()) {
            return "(E\\bot)";
        }
        if (this.isRuleEliminationOr()) {
            return "(E\\vee)";
        }
        if (this.isRuleIntroAnd()) {
            return "(I\\wedge)";
        }
        if (this.isRuleIntroOr()) {
            return "(I\\vee)";
        }
        if (this.isRuleIntroBottom()) {
            return "(I\\bot)";
        }
        if (this.isRuleIntroImply()) {
            return "(I\\rightarrow)";
        }
        if (this.isRuleIntroNot()) {
            return "(I\\neg)";
        }
        if (this.isRuleEliminationForall()) {
            return "(E\\forall)";
        }
        if (this.isRuleEliminationExists()) {
            return "(E\\exists)";
        }
        if (this.isRuleIntroForall()) {
            return "(I\\forall)";
        }
        if (this.isRuleIntroExists()) {
            return "(I\\exists)";
        }
        return null;
    }

    public ArrayList<Formula> getHypothesesDechargeables() {
        if (this.noFather()) {
            return this.getFormulasHypothesesDechargeesIciDansCeNoeud();
        }
        ProofFormulaNodeNatDet father = (ProofFormulaNodeNatDet)this.getFather();
        ArrayList<Formula> F = father.getHypothesesDechargeables(this);
        F.addAll(this.getFormulasHypothesesDechargeesIciDansCeNoeud());
        return F;
    }

    public ArrayList<Formula> getHypothesesDechargeables(ProofFormulaNodeNatDet child) {
        ArrayList<Object> F;
        if (this.noFather()) {
            F = new ArrayList();
        } else {
            ProofFormulaNodeNatDet father = (ProofFormulaNodeNatDet)this.getFather();
            F = father.getHypothesesDechargeables(this);
        }
        if (this.isRuleEliminationOr()) {
            if (child == this.getChild(1)) {
                F.add(this.getChild(0).getFormula().getSubFormulaLeft());
            } else if (child == this.getChild(2)) {
                F.add(this.getChild(0).getFormula().getSubFormulaRight());
            }
        } else {
            F.addAll(this.getFormulasHypothesesDechargeesIciDansCeNoeud());
        }
        return F;
    }

    public boolean isHypothesePrincipale() {
        return this.isHypothese() & !this.isHypotheseTemporaire();
    }

    public boolean isTreeOK() {
        if (this.isOK()) {
            for (ProofFormulaNode n : this.getChildren()) {
                if (((ProofFormulaNodeNatDet)n).isTreeOK()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

