/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jdom.Content;
import org.jdom.Element;
import panda.Formula;
import panda.FormulaBox;
import panda.LaTEX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProofFormulaNode {
    private Formula formula;
    private Icon iconFormulaLaTEX;
    private Point pointMilieuHaut;
    private ProofFormulaNode father = null;
    protected ArrayList<ProofFormulaNode> children = new ArrayList();
    private final int ecartChildrenNodes = 48;
    private static final int animIndiceMax = 8;
    private int animIndice = 0;
    private Point avantPointMilieuHaut;
    private boolean treeHidden = false;
    private ImageIcon imgTree = new ImageIcon(this.getClass().getResource("resources/arbre.png"));

    public boolean isAnimated() {
        return this.animIndice > 0;
    }

    public void animate() {
        if (this.isAnimated()) {
            --this.animIndice;
        }
    }

    ProofFormulaNode(Point pointMilieuHaut, Formula formula) {
        if (pointMilieuHaut == null) {
            this.pointMilieuHaut = null;
            this.avantPointMilieuHaut = null;
        } else {
            this.pointMilieuHaut = pointMilieuHaut;
            this.avantPointMilieuHaut = new Point(pointMilieuHaut.x, pointMilieuHaut.y);
        }
        this.setFormula(formula);
    }

    public boolean isOverFormula(Point point) {
        return this.getRectangleFormula().contains(point);
    }

    public Formula getFormula() {
        return this.formula;
    }

    public Rectangle getRectangleFormula() {
        return new Rectangle(this.getPointMilieuHautAnimation().x - this.iconFormulaLaTEX.getIconWidth() / 2, this.getPointMilieuHautAnimation().y, this.iconFormulaLaTEX.getIconWidth(), this.iconFormulaLaTEX.getIconHeight());
    }

    public Point getPointMilieuHaut() {
        return this.pointMilieuHaut;
    }

    public Point getPointMilieuBas() {
        return new Point(this.pointMilieuHaut.x, this.pointMilieuHaut.y + this.iconFormulaLaTEX.getIconHeight());
    }

    public void setPointMilieuHautImmediat(Point p) {
        this.avantPointMilieuHaut = new Point(p.x, p.y);
        this.pointMilieuHaut = new Point(p.x, p.y);
        this.animIndice = 0;
    }

    public void setPointMilieuHaut(Point p) {
        if (this.pointMilieuHaut == null) {
            this.animIndice = 0;
            this.avantPointMilieuHaut = new Point(p.x, p.y);
        } else {
            this.avantPointMilieuHaut = this.getPointMilieuHautAnimation();
            this.animIndice = this.avantPointMilieuHaut.distanceSq(p) == 0.0 ? 0 : 8;
        }
        this.pointMilieuHaut = p;
        this.positionsCompute();
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
        try {
            this.iconFormulaLaTEX = LaTEX.latexCodeToImageIcon(this.getFormulaLaTEXCode());
        }
        catch (Exception ex) {
            Logger.getLogger(ProofFormulaNode.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setFather(ProofFormulaNode father) {
        this.father = father;
    }

    public void addChild(ProofFormulaNode node) {
        if (!this.children.contains(node)) {
            if (node.getFather() != null) {
                node.getFather().removeChild(node);
            }
            this.children.add(node);
            node.setFather(this);
        }
    }

    public int getWidth() {
        int widthSum = 0;
        if (!this.isTreeHidden()) {
            for (ProofFormulaNode node : this.children) {
                widthSum += node.getWidth() + 48;
            }
            widthSum -= 48;
        }
        if (widthSum < this.iconFormulaLaTEX.getIconWidth()) {
            return this.iconFormulaLaTEX.getIconWidth();
        }
        return widthSum;
    }

    boolean askToBeFatherOf(ProofFormulaNode child) {
        return this.getRectangleTrait().intersects(child.getRectangleFormulaBas());
    }

    public Rectangle getRectangleFormulaBas() {
        return new Rectangle(this.getXMilieu() - this.getFormulaWidth() / 2, this.getYBottom() - 2, this.getFormulaWidth(), 4);
    }

    public Rectangle getRectangleTrait() {
        return new Rectangle(this.pointMilieuHaut.x - this.getWidth() / 2, this.pointMilieuHaut.y - 3, this.getWidth(), 6);
    }

    public void positionsCompute() {
        if (this.children.size() == 1) {
            ProofFormulaNode child = this.children.get(0);
            child.setPointMilieuBas(new Point(this.getXMilieu(), this.getYFormulaTop()));
        } else {
            int x = this.getXLeft();
            for (ProofFormulaNode child : this.children) {
                child.setPointMilieuBas(new Point(x + child.getWidth() / 2, this.getYFormulaTop()));
                x += child.getWidth() + 48;
            }
        }
    }

    public int getXLeft() {
        return this.pointMilieuHaut.x - this.getWidth() / 2;
    }

    public int getXRight() {
        return this.pointMilieuHaut.x + this.getWidth() / 2;
    }

    private void setPointMilieuBas(Point point) {
        this.setPointMilieuHaut(new Point(point.x, point.y - this.iconFormulaLaTEX.getIconHeight()));
    }

    public int getYFormulaTop() {
        return this.pointMilieuHaut.y;
    }

    public ProofFormulaNode getFather() {
        return this.father;
    }

    public ArrayList<ProofFormulaNode> getChildren() {
        return this.children;
    }

    public void addChildrenAndGrandChildrenEtc(Set<ProofFormulaNode> nodes) {
        nodes.addAll(this.children);
        for (ProofFormulaNode node : this.children) {
            node.addChildrenAndGrandChildrenEtc(nodes);
        }
    }

    public Set<ProofFormulaNode> getChildrenAndGrandChildrenEtc() {
        HashSet<ProofFormulaNode> nodes = new HashSet<ProofFormulaNode>();
        this.addChildrenAndGrandChildrenEtc(nodes);
        return nodes;
    }

    public void deconnectFromFather() {
        if (this.getFather() != null) {
            this.getFather().removeChild(this);
            this.setFather(null);
        }
    }

    public void deconnectFromAll() {
        this.deconnectFromFather();
        for (ProofFormulaNode child : this.children) {
            child.setFather(null);
        }
        this.children.clear();
    }

    public void removeChild(ProofFormulaNode currentNode) {
        while (this.children.contains(currentNode)) {
            this.children.remove(currentNode);
        }
        currentNode.setFather(null);
        this.getAncestor().positionsCompute();
    }

    public void drawTraitGros(Graphics g) {
        g.setColor(Color.BLUE);
        ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
        this.drawTrait(g);
    }

    protected void drawTrait(Graphics g) {
        g.drawLine(this.pointMilieuHaut.x - this.getWidth() / 2, this.pointMilieuHaut.y, this.pointMilieuHaut.x + this.getWidth() / 2, this.pointMilieuHaut.y);
    }

    private Point getPointMilieuHautAnimation() {
        float lambda = (float)this.animIndice / 8.0f;
        int x = Math.round((float)this.avantPointMilieuHaut.x * lambda + (float)this.pointMilieuHaut.x * (1.0f - lambda));
        int y = Math.round((float)this.avantPointMilieuHaut.y * lambda + (float)this.pointMilieuHaut.y * (1.0f - lambda));
        return new Point(x, y);
    }

    public void drawNode(Graphics g) {
        int x = this.getPointMilieuHautAnimation().x;
        int y = this.getPointMilieuHautAnimation().y;
        this.iconFormulaLaTEX.paintIcon(null, g, x - this.iconFormulaLaTEX.getIconWidth() / 2, y);
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
        if (this.getNbChildren() > 0) {
            this.drawTrait(g);
        }
    }

    public void drawNodeAndTree(Graphics g) {
        this.drawNode(g);
        if (this.isTreeHidden() & this.hasChildren()) {
            int w = 100;
            int h = 100;
            g.drawImage(this.imgTree.getImage(), this.getXMilieu() - w / 2, this.getYFormulaTop() - h, w, h, null);
        } else {
            for (ProofFormulaNode node : this.children) {
                node.drawNodeAndTree(g);
            }
        }
    }

    void drawAsCurrent(Graphics g) {
        g.setColor(new Color(0.5f, 0.5f, 0.5f));
        g.drawRoundRect(this.getRectangleFormula().x, this.getRectangleFormula().y, this.getRectangleFormula().width, this.getRectangleFormula().height, 5, 5);
        g.setColor(Color.BLACK);
        this.drawNode(g);
    }

    public void drawAsSelected(Graphics g) {
        this.drawNode(g);
        float[] f = new float[]{0.5f, 0.5f};
        g.setColor(new Color(1.0f, 0.8f, 0.8f));
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, f, 0.0f));
        this.fillPolygon(g);
        g.setColor(new Color(1.0f, 0.3f, 0.3f));
        ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
        g.drawRoundRect(this.getRectangleFormula().x - 2, this.getRectangleFormula().y - 2, this.getRectangleFormula().width + 4, this.getRectangleFormula().height + 4, 5, 5);
        g.setColor(Color.BLACK);
    }

    public int getNbChildren() {
        return this.children.size();
    }

    public ProofFormulaNode getChild(int i) {
        return this.children.get(i);
    }

    protected void echangerChildren2() {
        ProofFormulaNode child1 = this.getChild(0);
        ProofFormulaNode child0 = this.getChild(1);
        this.children.set(0, child0);
        this.children.set(1, child1);
    }

    public boolean hasFather() {
        return this.getFather() != null;
    }

    public boolean noChildren() {
        return this.getNbChildren() == 0;
    }

    public boolean noFather() {
        return this.getFather() == null;
    }

    public int getYBottom() {
        return this.pointMilieuHaut.y + this.iconFormulaLaTEX.getIconHeight();
    }

    public int getXMilieu() {
        return this.pointMilieuHaut.x;
    }

    public void addChildren(ArrayList<ProofFormulaNode> futureChildren) {
        for (ProofFormulaNode child : futureChildren) {
            this.addChild(child);
        }
    }

    public ArrayList<Point> getPolygon() {
        ArrayList<Point> pts = new ArrayList<Point>();
        pts.add(new Point(this.getXLeft(), this.getYFormulaTop()));
        if (this.isTreeHidden()) {
            pts.add(new Point(this.getXMilieu(), this.getYFormulaTop() - 100));
        } else {
            for (ProofFormulaNode child : this.children) {
                pts.addAll(child.getPolygon());
            }
        }
        pts.add(new Point(this.getXRight(), this.getYFormulaTop()));
        return pts;
    }

    private void fillPolygon(Graphics g) {
        ArrayList<Point> pts = this.getPolygon();
        pts.add(new Point(this.getXRightFormula(), this.getYBottom()));
        pts.add(new Point(this.getXLeftFormula(), this.getYBottom()));
        int[] xPoints = new int[pts.size()];
        int[] yPoints = new int[pts.size()];
        for (int i = 0; i < pts.size(); ++i) {
            xPoints[i] = pts.get((int)i).x;
            yPoints[i] = pts.get((int)i).y;
        }
        g.fillPolygon(xPoints, yPoints, pts.size());
    }

    private int getXLeftFormula() {
        return this.getXMilieu() - this.getFormulaWidth() / 2;
    }

    private int getXRightFormula() {
        return this.getXMilieu() + this.getFormulaWidth() / 2;
    }

    public void echangerChildren2(int i, int j) {
        ProofFormulaNode jNode = this.getChild(j);
        this.children.set(j, this.getChild(i));
        this.children.set(i, jNode);
        this.positionsCompute();
    }

    private int getFormulaWidth() {
        return this.iconFormulaLaTEX.getIconWidth();
    }

    private ProofFormulaNode getAncestor() {
        if (this.noFather()) {
            return this;
        }
        return this.getFather().getAncestor();
    }

    public String getFormulaLaTEXCode() {
        try {
            return FormulaBox.formulaSchemeToLatexCode(this.formula);
        }
        catch (Exception ex) {
            Logger.getLogger(ProofFormulaNode.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getLaTEXCodeArbre() {
        if (this.noChildren()) {
            return this.getFormulaLaTEXCode();
        }
        String s = "";
        for (ProofFormulaNode node : this.getChildren()) {
            s = s + node.getLaTEXCodeArbre() + "\\hspace{5mm}";
        }
        s = s + "\\hspace{-5mm}";
        return "\\frac{" + s + "}{" + this.getFormulaLaTEXCode() + "}";
    }

    public void translate(int dx, int dy) {
        this.pointMilieuHaut.x += dx;
        this.pointMilieuHaut.y += dy;
        if (this.avantPointMilieuHaut != this.pointMilieuHaut) {
            this.avantPointMilieuHaut.x += dx;
            this.avantPointMilieuHaut.y += dy;
        }
        for (ProofFormulaNode child : this.children) {
            child.translate(dx, dy);
        }
    }

    public int getFormulaRectangleHeight() {
        return this.iconFormulaLaTEX.getIconHeight();
    }

    public boolean isTreeHidden() {
        return this.treeHidden;
    }

    void treeShowAll() {
        this.treeHidden = false;
        for (ProofFormulaNode node : this.children) {
            node.treeShowAll();
        }
    }

    public void treeHide() {
        this.treeHidden = true;
        for (ProofFormulaNode node : this.children) {
            node.treeHide();
        }
    }

    private boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Element saveRecursive() {
        Element element = new Element("proofnode");
        Element elementFormula = new Element("formula");
        elementFormula.setText(this.getFormula().getSchemeString());
        Element elementPosition = new Element("graphicalposition");
        Element elementPositionX = new Element("x");
        Element elementPositionY = new Element("y");
        elementPositionX.setText(String.valueOf(this.getPointMilieuHaut().x));
        elementPositionY.setText(String.valueOf(this.getPointMilieuHaut().y));
        elementPosition.addContent((Content)elementPositionX);
        elementPosition.addContent((Content)elementPositionY);
        Element elementChildren = new Element("children");
        for (ProofFormulaNode child : this.getChildren()) {
            elementChildren.addContent((Content)child.saveRecursive());
        }
        element.addContent((Content)elementFormula);
        element.addContent((Content)elementPosition);
        element.addContent((Content)elementChildren);
        return element;
    }
}

