/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import panda.Formula;
import panda.FormulaBox;
import panda.JLabelSubFormulaPart;
import panda.SubFormula;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelFormulaSubFormulas
extends JPanel {
    final Formula formula;

    public PanelFormulaSubFormulas(Formula formula) {
        this.initComponents();
        this.formula = formula;
        try {
            this.treatFormula(formula);
        }
        catch (Exception ex) {
            Logger.getLogger(PanelFormulaSubFormulas.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private JLabelSubFormulaPart firstLabel(String schemeCode, String latexCode) {
        JLabelSubFormulaPart label = new JLabelSubFormulaPart(schemeCode, latexCode, null);
        this.setup(label);
        this.add(label);
        return label;
    }

    private void addLabel(String schemeCode, String latexCode, JLabelSubFormulaPart firstLabel) {
        JLabelSubFormulaPart label = new JLabelSubFormulaPart(schemeCode, latexCode, firstLabel);
        this.setup(label);
        this.add(label);
    }

    private JLabelSubFormulaPart firstLabelTerm(String schemeCode, String latexCode) {
        JLabelSubFormulaPart label = new JLabelSubFormulaPart(schemeCode, latexCode, null);
        this.add(label);
        this.setup(label);
        return label;
    }

    private void addLabelTerm(String schemeCode, String latexCode, JLabelSubFormulaPart firstLabel) {
        JLabelSubFormulaPart label = new JLabelSubFormulaPart(schemeCode, latexCode, firstLabel);
        this.setup(label);
        this.add(label);
    }

    public void treatFormula(Formula formula) throws Exception {
        if (formula.getSchemeString().startsWith("<")) {
            this.firstLabel(formula.getSchemeString(), "?");
        } else if (formula.getSchemeString().equals("top")) {
            this.firstLabel("top", "\\top");
        } else if (formula.getSchemeString().equals("bottom")) {
            this.firstLabel("bottom", "\\bot");
        } else if (!formula.getSchemeString().startsWith("(")) {
            this.firstLabel(formula.getSchemeString(), formula.getLaTEXCode());
        } else if (formula.isNot()) {
            JLabelSubFormulaPart first = this.firstLabel("(not ", "\\neg");
            this.treatFormula(formula.getSubFormulaForNot());
            this.addLabel(")", "", first);
        } else if (formula.getSubPart(1).getSchemeString().equals("and")) {
            if (formula.getNbSubParts() % 2 == 0) {
                throw new Exception("Il manque au moins une sous-formule dans cette conjonction");
            }
            JLabelSubFormulaPart first = this.firstLabel("(", "(");
            this.treatFormula(formula.getSubPart(0));
            for (int i = 1; i < formula.getNbSubParts(); i += 2) {
                if (!formula.getSubPart(i).toString().equals("and")) {
                    throw new Exception("J'attends un 'and'");
                }
                this.addLabel(" and ", " \\wedge ", first);
                this.treatFormula(formula.getSubPart(i + 1));
            }
            this.addLabel(")", ")", first);
        } else if (formula.getSubPart(1).getSchemeString().equals("or")) {
            if (formula.getNbSubParts() % 2 == 0) {
                throw new Exception("Il manque au moins une sous-formule dans cette disjonction");
            }
            JLabelSubFormulaPart first = this.firstLabel("(", "(");
            this.treatFormula(formula.getSubPart(0));
            for (int i = 1; i < formula.getNbSubParts(); i += 2) {
                if (!formula.getSubPart(i).toString().equals("or")) {
                    throw new Exception("J'attends un 'or'");
                }
                this.addLabel(" or ", " \\vee ", first);
                this.treatFormula(formula.getSubPart(i + 1));
            }
            this.addLabel(")", ")", first);
        } else if (formula.getSubPart(1).getSchemeString().equals("imply")) {
            JLabelSubFormulaPart first = this.firstLabel("(", "(");
            this.treatFormula(formula.getSubPart(0));
            this.addLabel(" imply ", " \\rightarrow ", first);
            this.treatFormula(formula.getSubPart(2));
            this.addLabel(")", ")", first);
        } else if (formula.getSubPart(1).getSchemeString().equals("equiv")) {
            JLabelSubFormulaPart first = this.firstLabel("(", "(");
            this.treatFormula(formula.getSubPart(0));
            this.addLabel(" equiv ", " \\rightarrow ", first);
            this.treatFormula(formula.getSubPart(2));
            this.addLabel(")", ")", first);
        } else if (formula.isForAll()) {
            JLabelSubFormulaPart first = this.firstLabel("(forall ", "\\forall ");
            this.addLabel(" " + formula.getQuantifierVariable() + " ", " " + formula.getQuantifierVariable() + ". ", first);
            this.treatFormula(formula.getQuantifierSubFormula());
            this.addLabel(")", "", first);
        } else if (formula.isExists()) {
            JLabelSubFormulaPart first = this.firstLabel("(exists ", "\\exists ");
            this.addLabel(" " + formula.getQuantifierVariable() + " ", " " + formula.getQuantifierVariable() + ". ", first);
            this.treatFormula(formula.getQuantifierSubFormula());
            this.addLabel(")", "", first);
        } else {
            this.treatPredicat(formula);
        }
    }

    private void treatPredicat(Formula predicat) {
        if (predicat.isAtomic()) {
            this.firstLabel(predicat.getSchemeString(), FormulaBox.predicatSymbolToLaTEX(predicat.getSchemeString()));
        } else if (predicat.getNbSubParts() == 1) {
            this.firstLabel(predicat.getSchemeString(), FormulaBox.predicatSymbolToLaTEX(predicat.getSchemeString()));
        } else {
            JLabelSubFormulaPart first = this.firstLabel("(" + predicat.getSubPart(0).getSchemeString(), FormulaBox.predicatSymbolToLaTEX(predicat.getSubPart(0).getSchemeString()));
            this.addLabelTerm(" ", "(", first);
            this.treatTerm(predicat.getSubPart(1));
            for (int i = 2; i < predicat.getNbSubParts(); ++i) {
                this.addLabel(" ", ", ", first);
                this.treatTerm(predicat.getSubPart(i));
            }
            this.addLabel(")", ")", first);
        }
    }

    protected void treatTerm(Formula term) {
        if (term.isAtomic()) {
            this.firstLabelTerm(term.getSchemeString(), term.getSchemeString());
        } else if (term.getNbSubParts() == 1) {
            this.firstLabelTerm(term.getSchemeString(), term.getSchemeString());
        } else {
            JLabelSubFormulaPart first = this.firstLabelTerm("(" + term.getSubPart(0).getSchemeString(), FormulaBox.predicatSymbolToLaTEX(term.getSubPart(0).getSchemeString()));
            this.addLabelTerm(" ", "(", first);
            this.treatTerm(term.getSubPart(1));
            for (int i = 2; i < term.getNbSubParts(); ++i) {
                this.addLabelTerm(" ", ", ", first);
                this.treatTerm(term.getSubPart(i));
            }
            this.addLabelTerm(")", ")", first);
        }
    }

    private void initComponents() {
        this.setName("Form");
        this.setLayout(new BoxLayout(this, 2));
    }

    private void setup(final JLabelSubFormulaPart label) {
        final PanelFormulaSubFormulas panel = this;
        label.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (label.isSelected()) {
                    PanelFormulaSubFormulas.this.deselectPlage(label);
                } else {
                    JLabelSubFormulaPart firstLabel = label.getFirstLabel();
                    JLabelSubFormulaPart lastLabel = PanelFormulaSubFormulas.this.getLastLabel(firstLabel);
                    for (Component c : PanelFormulaSubFormulas.this.getComponents()) {
                        if (!(c.getX() >= firstLabel.getX() & c.getX() <= lastLabel.getX())) continue;
                        ((JLabelSubFormulaPart)c).select();
                    }
                }
                for (MouseListener ml : panel.getMouseListeners()) {
                    ml.mouseClicked(e);
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private JLabelSubFormulaPart getLastLabel(JLabelSubFormulaPart firstLabel) {
        JLabelSubFormulaPart lastLabel = firstLabel;
        for (Component c : this.getComponents()) {
            if (!(c.getX() > lastLabel.getX() & ((JLabelSubFormulaPart)c).getFirstLabel() == firstLabel)) continue;
            lastLabel = (JLabelSubFormulaPart)c;
        }
        return lastLabel;
    }

    int getI(JLabelSubFormulaPart label) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != label) continue;
            return i;
        }
        return -1;
    }

    JLabelSubFormulaPart getJLabelSubFormulaPart(int i) {
        return (JLabelSubFormulaPart)this.getComponent(i);
    }

    private void deselectPlage(JLabelSubFormulaPart label) {
        int i;
        for (i = this.getI(label); i < this.getComponentCount() && this.getJLabelSubFormulaPart(i).isSelected(); ++i) {
            this.getJLabelSubFormulaPart(i).deSelect();
        }
        for (i = this.getI(label) - 1; i >= 0 && this.getJLabelSubFormulaPart(i).isSelected(); --i) {
            this.getJLabelSubFormulaPart(i).deSelect();
        }
    }

    private int getPositionSchemeCode(int i) {
        int pos = 0;
        for (int j = 0; j < i; ++j) {
            pos += this.getJLabelSubFormulaPart(j).getSchemeCode().length();
        }
        return pos;
    }

    public ArrayList<SubFormula> getSubFormulas() {
        ArrayList<SubFormula> A = new ArrayList<SubFormula>();
        int i = 0;
        while (i < this.getComponentCount()) {
            if (this.getJLabelSubFormulaPart(i).isSelected()) {
                int ifinal = this.getI(this.getLastLabel(this.getJLabelSubFormulaPart(i)));
                String subFormulaString = this.getSubFormulaString(i, ifinal);
                A.add(new SubFormula(this.formula.getSchemeString(), subFormulaString, this.getPositionSchemeCode(i)));
                i = ifinal + 1;
                continue;
            }
            ++i;
        }
        return A;
    }

    private String getSubFormulaString(int idebut, int ifinal) {
        String s = "";
        for (int i = idebut; i <= ifinal; ++i) {
            s = s + this.getJLabelSubFormulaPart(i).getSchemeCode();
        }
        return s;
    }

    public String getFormulaSchemeString() {
        return this.getSubFormulaString(0, this.getComponentCount() - 1);
    }
}

