/*
 * Decompiled with CFR 0.152.
 */
package panda;

import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import panda.Formula;
import panda.FormulaBox;
import panda.LaTEX;
import panda.Mission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItemExample
extends JMenuItem {
    private final Formula goalFormula;
    private final Set<Formula> hypothesisFormulas;

    public Set<Formula> getHypothesisFormulas() {
        return this.hypothesisFormulas;
    }

    public Formula getGoalFormula() {
        return this.goalFormula;
    }

    static String schemeFormulaToLaTEXCode(String schemeFormula) {
        try {
            return FormulaBox.formulaSchemeStringToLatexCode(schemeFormula);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static Icon schemeFormulaToIcon(String schemeFormula) {
        return LaTEX.latexCodeToImageIcon(MenuItemExample.schemeFormulaToLaTEXCode(schemeFormula));
    }

    private void setupIcon() {
        this.setIcon(new Mission(this.hypothesisFormulas, this.goalFormula).getIcon());
    }

    MenuItemExample(String schemeFormula) {
        this.goalFormula = new Formula(schemeFormula);
        this.hypothesisFormulas = new HashSet<Formula>();
        this.setupIcon();
    }

    MenuItemExample(String hyp1, String hyp2, String schemeFormula) {
        this.goalFormula = new Formula(schemeFormula);
        this.hypothesisFormulas = new HashSet<Formula>();
        this.hypothesisFormulas.add(new Formula(hyp1));
        this.hypothesisFormulas.add(new Formula(hyp2));
        this.setupIcon();
    }

    MenuItemExample(String hyp1, String hyp2, String hyp3, String schemeFormula) {
        this.goalFormula = new Formula(schemeFormula);
        this.hypothesisFormulas = new HashSet<Formula>();
        this.hypothesisFormulas.add(new Formula(hyp1));
        this.hypothesisFormulas.add(new Formula(hyp2));
        this.hypothesisFormulas.add(new Formula(hyp3));
        this.setupIcon();
    }

    MenuItemExample(String hyp1, String schemeFormula) {
        this.goalFormula = new Formula(schemeFormula);
        this.hypothesisFormulas = new HashSet<Formula>();
        this.hypothesisFormulas.add(new Formula(hyp1));
        this.setupIcon();
    }
}

